unit Spotdefs;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, StdCtrls,
     Buttons, IniFiles, Dialogs, SysUtils;

type
  TSetupSpot = class(TForm)
    Ok: TBitBtn;
    Cancel: TBitBtn;
    GroupBox2: TGroupBox;
    SetPwd: TBitBtn;
    PwdTypes: TComboBox;
    Gb: TGroupBox;
    Sb: TScrollBar;
    Spd: TLabel;
    L1: TLabel;
    L2: TLabel;
    SizeSpot: TScrollBar;
    Label1: TLabel;
    Label2: TLabel;
    SizeVal: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure CancelClick(Sender: TObject);
    procedure OkClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure SetPwdClick(Sender: TObject);
    procedure PwdTypesChange(Sender: TObject);
    procedure SbChange(Sender: TObject);
    procedure SizeSpotChange(Sender: TObject);
  private
    Loading : Boolean;
    { Private declarations }
  public

    { Public declarations }
  end;

var
  SetupSpot : TSetupSpot;
  Ini   : TIniFile;

implementation

Uses Globals, NewPass, CodeSpot;

{$R *.DFM}


procedure TSetupSpot.FormCreate(Sender: TObject);
begin
  Loading := True;
end;


procedure TSetupSpot.CancelClick(Sender: TObject);
begin
  Close;                                                   { Bye Bye }
end;

procedure TSetupSpot.OkClick(Sender: TObject);
Var
  Fnt : Integer;                                           { Temp for font style }
begin
  Ini := TIniFile.Create('Wow.Ini');                   { Create the Ini file }
  Ini.WriteInteger(AppTitle,'PwdType',
                  PwdTypes.ItemIndex);                     { Write the Password Type }
  Ini.WriteInteger(Apptitle,'Speed',100 - Sb.Position);    { Write the Speed }
  Ini.WriteInteger(Apptitle,'Size',SizeSpot.Position);     { Write the Size }

  Close;
end;

procedure TSetupSpot.FormActivate(Sender: TObject);
begin
  If Loading then begin                                    { App is loading }
    Loading := False;                                      { Reset Flag }
    ReadSpotDefaults;                                      { Read our defaults }
    Sb.Position := 100 - SpotSpeed;                        { Get the Speed }
    Spd.Caption := IntToStr(Sb.Position);                  { Set the Value }
    SizeSpot.Position := SpotSize;                         { Get the Size of the Spot }
    SizeVal.Caption := IntToStr(SizeSpot.Position);        { Set the Value }
    PwdTypes.ItemIndex := PwdType;                         { Set Password Type }
  end;
end;

procedure TSetupSpot.SetPwdClick(Sender: TObject);         { Set Pwd Type }
begin
  ChPwd := TChPwd.Create(Application);                     { Create the Dialog }
  if Pwd = '' then begin                                   { If NO Password }
    ChPwd.OldPwd.Enabled := False;                         { No Old Password }
    ChPwd.NewPwd.Enabled := True;                          { Enable New Password }
    ChPwd.Rpwd.Enabled := True;                            { Enable Retype password }
    end
  else begin
    ChPwd.OldPwd.Enabled := True;                          { Have PWD so enable OLD password }
    ChPwd.NewPwd.Enabled := False;                         { Disable NEW till old entered }
    ChPwd.Rpwd.Enabled := False;                           { Disable Retypr till Old Entered }
    end;
  ChPwd.ShowModal;                                         { Do the dialog }
  ChPwd.Free;                                              { Free the dialog }
end;

procedure TSetupSpot.PwdTypesChange(Sender: TObject);      { Changing Pwd Types }
begin
  If PwdTypes.ItemIndex = 1 then                           { If a WINDOWS password }
    SetPwd.Enabled := True                                 { Enable setting }
  else
    SetPwd.Enabled := False;                               { others can't be set so disable }

end;

procedure TSetupSpot.SbChange(Sender: TObject);            { Adjusting the time delay }
begin
  Spd.Caption := IntToStr(Sb.Position);                    { Set the new time delay }
end;

procedure TSetupSpot.SizeSpotChange(Sender: TObject);
begin
  SizeVal.Caption := IntToStr(SizeSpot.Position);          { Set Value }
end;

begin

end.
