unit Clntserv;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, About, Sockets;

type
  TForm1 = class(TForm)
    Connect: TButton;
    SendData: TButton;
    Listen: TButton;
    Close: TButton;
    CancelListen: TButton;
    Port: TEdit;
    Label2: TLabel;
    Edit1: TEdit;
    Memo1: TMemo;
    Label5: TLabel;
    HelpButton: TButton;
    Label1: TLabel;
    IPAddr: TEdit;
    Sockets1: TSockets;
    procedure ConnectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SendDataClick(Sender: TObject);
    procedure ListenClick(Sender: TObject);
    procedure CloseClick(Sender: TObject);
    procedure CancelListenClick(Sender: TObject);
    procedure HelpButtonClick(Sender: TObject);
    procedure Sockets1SessionConnected(Sender: TObject; Socket: Word);
    procedure Sockets1SessionAvailable(Sender: TObject; Socket: Word);
    procedure Sockets1DataAvailable(Sender: TObject; Socket: Word);
    procedure Sockets1SessionClosed(Sender: TObject; Socket: Word);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  clientserver: integer;

implementation

{$R *.DFM}

procedure TForm1.ConnectClick(Sender: TObject);
var
  szMsg: array[0..255] of char;
begin
  Listen.Enabled := False;
  Sockets1.IPAddr := IPAddr.Text;
  Sockets1.Port := Port.Text;
  Sockets1.SConnect;
  clientserver := 1;
  Connect.Enabled := False;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
Port.Text := Sockets1.Port;
IPAddr.Text := Sockets1.IPAddr;
Connect.Enabled := True;
SendData.Enabled := False;
Listen.Enabled := True;
Close.Enabled := False;
CancelListen.Enabled := False;
clientserver := 0;
end;

procedure TForm1.SendDataClick(Sender: TObject);
begin
  Sockets1.Text := Edit1.Text;
end;

procedure TForm1.ListenClick(Sender: TObject);
begin
  Edit1.Text := '';
  Edit1.Enabled := False;
  Connect.Enabled := False;
  SendData.Enabled := False;
  Sockets1.Port := Port.Text;
  Sockets1.SListen;
  Listen.Enabled := False;
  Close.Enabled := False;
  CancelListen.Enabled := True;
  clientserver := 2;
  Memo1.Lines.Add('Listening on socket('+IntToStr(Sockets1.MasterSocket)+')');
end;

procedure TForm1.CloseClick(Sender: TObject);
begin
  Sockets1.SClose;
  if clientserver <> 2 then {not server?}
  begin
    Connect.Enabled := True;
    SendData.Enabled := False;
    Listen.Enabled := True;
    Close.Enabled := False;
    CancelListen.Enabled := False;
    clientserver := 0;
  end;
end;

procedure TForm1.CancelListenClick(Sender: TObject);
begin
  If Sockets1.SocketNumber <> INVALID_SOCKET Then
    Sockets1.SClose;
  If Sockets1.MasterSocket <> INVALID_SOCKET Then
    Sockets1.SCancelListen;
  Connect.Enabled := True;
  SendData.Enabled := False;
  Listen.Enabled := True;
  Close.Enabled := False;
  CancelListen.Enabled := False;
end;

procedure TForm1.HelpButtonClick(Sender: TObject);
begin
  AboutBox.Show;
end;

procedure TForm1.Sockets1SessionConnected(Sender: TObject; Socket: Word);
begin
  Connect.Enabled := False;
  SendData.Enabled := True;
  Listen.Enabled := False;
  Close.Enabled := True;
  CancelListen.Enabled := False;
end;

procedure TForm1.Sockets1SessionAvailable(Sender: TObject; Socket: Word);
var
  new_client: TSocket;
begin
  new_client := Sockets1.SAccept;
  Memo1.Lines.Add('Client session accepted, socket(' + IntToStr(new_client) + ')');
  Listen.Enabled := False;
  CancelListen.Enabled := True;
end;

procedure TForm1.Sockets1DataAvailable(Sender: TObject; Socket: Word);
var
  Buf: string;
begin
  Memo1.Lines.Add('Data recevied from socket(' + IntToStr(Socket) + ')');
  Sockets1.SocketNumber := Socket;
  buf := Sockets1.Text;
  Memo1.Lines.Add('-->' + buf + '<--');
  If clientserver = 2 Then
  begin
    Sockets1.Text := buf;
    Memo1.Lines.Add('...Buffer echoed back to client');
  end;
end;

procedure TForm1.Sockets1SessionClosed(Sender: TObject; Socket: Word);
begin
  Memo1.Lines.Add('Lost connection on socket(' + IntToStr(Socket) + ')');
  Sockets1.SocketNumber := Socket;
  CloseClick(Self);
end;

end.

