unit mapi;

(*
   MAPI.DLL Interface Unit

   Messaging Applications Programming Interface.

   Purpose:
     This file defines the structures and constants used by
     that subset of the messaging applications programming
     interface which will be supported under Windows by
     Microsoft Mail for PC Networks vesion 3.2.

   Translated by Yasser Asmi (CIS 71543,2252)
*)

{$A+,I-,R-,S-,V-,B-,G+,X+,W-}

interface

uses
   wintypes;

const
   mapi_orig              = 0;             (* Recipient is message originator *)
   mapi_to                = 1;             (* Recipient is a primary recipient *)
   mapi_cc                = 2;             (* Recipient is a copy recipient *)
   mapi_bcc               = 3;             (* Recipient is blind copy recipient *)

   mapi_ole               = $00000001;     (* Attachment is OLE *)
   mapi_ole_static        = $00000002;     (* Use with mapi_ole, static object *)

   mapi_unread            = $00000001;
   mapi_receipt_requested = $00000002;
   mapi_sent              = $00000004;

   mapi_logon_ui          = $00000001;     (* Display logon UI *)
   mapi_new_session       = $00000002;     (* Do not use default. *)
   mapi_dialog            = $00000008;     (* Display a send note UI *)
   mapi_unread_only       = $00000020;     (* Only unread messages *)
   mapi_envelope_only     = $00000040;     (* Only header information *)
   mapi_peek              = $00000080;     (* Do not mark as read. *)
   mapi_guarantee_fifo    = $00000100;     (* use date order *)
   mapi_body_as_file      = $00000200;
   mapi_ab_nomodify       = $00000400;     (* Don't allow mods of AB entries *)
   mapi_suppress_attach   = $00000800;     (* Header + body, no files *)
   mapi_force_download    = $00001000;     (* Force download of new mail during MAPILogon *)


type
   tflags = longint;
   ulong = longint;
   lhandle = longint;

   plhandle = ^lhandle;
   pulong = ^ulong;

   pMapiFileDesc = ^tMapiFileDesc;
   tMapiFileDesc = record
      ulReserved : longint;         (* Reserved for future use (must be 0) *)
      flFlags : tflags;             (* Flags *)
      nPosition : longint;          (* Character in text to be replaced by attachment *)
      lpszPathName : pchar;         (* Full path name of attachment file *)
      lpszFileName : pchar;         (* Original file name (optional) *)
      lpFileType : pointer;         (* Attachment file type (optional) *)
   end;

   pMapiRecipDesc = ^tMapiRecipDesc;
   tMapiRecipDesc = record
      ulReserved : longint;         (* Reserved for future use *)
      ulRecipClass : longint;       (* Recipient class MAPI_TO, MAPI_CC, MAPI_BCC, MAPI_ORIG *)
      lpszName : pchar;             (* Recipient name *)
      lpszAddress : pchar;          (* Recipient address (optional) *)
      ulEIDSize : longint;          (* Count in bytes of size of pEntryID *)
      lpEntryID : pointer;          (* System-specific recipient reference *)
   end;

   pMapiMessage = ^tMapiMessage;
   tMapiMessage = record
      ulReserved : longint;               (* Reserved for future use (must be 0) *)
      lpszSubject : pchar;                (* Message Subject *)
      lpszNoteText : pchar;               (* Message Text *)
      lpszMessageType : pchar;            (* Message Class *)
      lpszDateReceived : pchar;           (* In YYYY/MM/DD HH:MM format *)
      lpszConversationID : pchar;         (* Conversation thread ID *)
      flFlags : tflags;                   (* Unread,return receipt *)
      lpOriginator : pMapiRecipDesc;      (* Originator descriptor *)
      nRecipCount : ulong;                (* Number of recipients *)
      lpRecips : pMapiRecipDesc;          (* Recipient descriptors *)
      nFileCount : ulong;                 (* # of file attachments *)
      lpFiles : pMapiFileDesc;            (* Attachment descriptors *)
   end;


function MAPILogon (ulUIParam : ulong;
                    lpszName, lpszPassword : pchar;
                    flFlags : tflags;
                    ulReserved : ulong;
                    lplhSession : plhandle) : ulong;

function MAPILogoff (lhSession : lhandle;
                     ulUIParam : ulong;
                     flFlags : tflags;
                     ulReserved : ulong) : ulong;

function MAPISendMail (lhSession : lhandle;
                       ulUIParam : ulong;
                       lpMessage : pMapiMessage;
                       flFlags : tflags;
                       ulReserved : ulong) : ulong;

function MAPISendDocuments (ulUIParam : ulong;
                            lpszDelimChar : pchar;
                            lpszFilePaths : pchar;
                            lpszFileNames : pchar;
                            ulReserved : ulong) : ulong;

function MAPIFindNext (lhSession : lhandle;
                       ulUIParam : ulong;
                       lpszMessageType, lpszSeedMessageID : pchar;
                       flFlags : tflags;
                       ulReserved : ulong;
                       lpszMessageID : pchar) : ulong;

function MAPIReadMail (lhSession : lhandle;
                       ulUIParam : ulong;
                       lpszMessageID : pchar;
                       flFlags : tflags;
                       ulReserved : ulong;
                       lppMessageOut : pMapiMessage) : ulong;

function MAPISaveMail (lhSession : lhandle;
                       ulUIParam : ulong;
                       pMessage : pMapiMessage;
                       flFlags : tflags;
                       ulReserved : ulong;
                       lpszMessageID : pchar) : ulong;

function MAPIDeleteMail (lhSession : lhandle;
                         ulUIParam : ulong;
                         lpszMessageID : pchar;
                         flFlags : tflags;
                         ulReserved : ulong) : ulong;

function MAPIFreeBuffer (pv : pointer) : ulong;

function MAPIAddress (lhSession : lhandle;
                      ulUIParam : ulong;
                      plszCaption : pchar;
                      nEditFields : ulong;
                      lpszLabels : pchar;
                      nRecips : ulong;
                      lpRecips : pMapiRecipDesc;
                      flFlags : tflags;
                      ulReserved : ulong;
                      lpnNewRecips : pUlong;
                      lppNewRecips : pMapiRecipDesc) : ulong;

function MAPIDetails (lhSession : lhandle;
                      ulUIParam : lhandle;
                      lpRecip : pMapiRecipDesc;
                      flFlags : tflags;
                      ulReserved : ulong) : ulong;

function MAPIResolveName (lhSession : lhandle;
                          ulUIParam : ulong;
                          lpszName : pchar;
                          flFlags : tflags;
                          ulReserved : ulong;
                          lppRecip : pMapiRecipDesc) : ulong;

const                                                 (* error codes *)
   success_success                 = 0;
   mapi_user_abort                 = 1;
   mapi_e_failure                  = 2;
   mapi_e_login_failure            = 3;
   mapi_e_disk_full                = 4;
   mapi_e_insufficient_memory      = 5;
   mapi_e_access_denied            = 6;
   mapi_e_too_many_sessions        = 8;
   mapi_e_too_many_files           = 9;
   mapi_e_too_many_recipients      = 10;
   mapi_e_attachment_not_found     = 11;
   mapi_e_attachment_open_failure  = 12;
   mapi_e_attachment_write_failure = 13;
   mapi_e_unknown_recipient        = 14;
   mapi_e_bad_reciptype            = 15;
   mapi_e_no_messages              = 16;
   mapi_e_invalid_message          = 17;
   mapi_e_text_too_large           = 18;
   mapi_e_invalid_session          = 19;
   mapi_e_type_not_supported       = 20;
   mapi_e_ambiguous_recipient      = 21;
   mapi_e_message_in_use           = 22;
   mapi_e_network_failure          = 23;
   mapi_e_invalid_editfields       = 24;
   mapi_e_invalid_recips           = 25;
   mapi_e_not_supported            = 26;


implementation


function MAPILogon;         external 'MAPI' Index 11;
function MAPILogoff;        external 'MAPI' Index 12;
function MAPISendMail;      external 'MAPI' Index 13;
function MAPISendDocuments; external 'MAPI' Index 10;
function MAPIFindNext;      external 'MAPI' Index 16;
function MAPIReadMail;      external 'MAPI' Index 15;
function MAPISaveMail;      external 'MAPI' Index 14;
function MAPIDeleteMail;    external 'MAPI' Index 17;
function MAPIFreeBuffer;    external 'MAPI' Index 18;
function MAPIAddress;       external 'MAPI' Index 19;
function MAPIDetails;       external 'MAPI' Index 20;
function MAPIResolveName;   external 'MAPI' Index 21;


end.
