unit splus;

(*
   SPLUS.DLL Interface Unit

   Schedule+ Calendaring Applications Program Interface.

   Purpose:
     This file defines the structures and constants used by
     that subset of the Schedule+ Calendaring Applications Program
     Interface which will be supported under Windows by
     Microsoft Schedule+ for Windows version 1.0.

   Translated by Yasser Asmi (CIS 71543,2252)
*)

{$A+,I-,R-,S-,V-,B-,G+,X+,W-}

interface

uses
   wintypes, mapi;

const
   splus_no_request_sent     = $00000000;
   splus_no_response         = $00000001;
   splus_positive_response   = $00000002;
   splus_negative_response   = $00000003;
   splus_ambiguous_response  = $00000004;

   splus_response_requested  = $00010000;
   splus_default_alarm       = $00001000;
   splus_modify_flags        = $00010000;
   splus_modify_assoc        = $00020000;
   splus_modify_attendees    = $00040000;
   splus_modify_text         = $00080000;
   splus_modify_times        = $00400000;
   splus_modify_project_name = $00800000;
   splus_modify_priority     = $01000000;
   splus_modify_all          = $01ff0000;

   splus_private             = $00000001;
   splus_tentative           = $00000004;
   splus_suppress_recipients = $00010000;

   splus_private_project     = $00000002;
   splus_boss_wants_copy     = $00000001;

type
   pSPlusAttendeeDesc = ^tSPlusAttendeeDesc;
   tSPlusAttendeeDesc = record
      ulReserved : ulong;            (* Reserved for future use. Must be 0. *)
      lpszUserType : pchar;          (* String specifying the user type *)
      lpUser : pMapiRecipDesc;       (* Identity of the attendee *)
      ulStatus : ulong;              (* Confirmation status *)
   end;

   pSPlusAssocDesc = ^tSPlusAssocDesc;
   tSPlusAssocDesc = record
      ulReserved : ulong;         (* Reserved for future use. Must be 0. *)
      lpszItemType : pchar;       (* String specifying the item type. *)
      flFlags : ulong;            (* Reserved for future use. Must be 0. *)
      lpszItemID : pchar;         (* Schedule+ ID for this item. *)
      nPosition : ulong;          (* Reserved for future use. Must be 0. *)
      lpszData : pchar;           (* Additional data specific to the type *)
   end;

   pSPlusMessage = ^tSPlusMessage;
   tSPlusMessage = record
      ulReserved : ulong;             (* Reserved for future use. Must be 0. *)
      lpszSubject : pchar;            (* Message subject *)
      lpszNoteText : pchar;           (* Message body text *)
      lpszMessageType : pchar;        (* Message class *)
      lpszDateReceived : pchar;       (* In YYYY/MM/DD HH:MM format *)
      lpszConversationID : pchar;     (* Conversation thread ID *)
      flFlags : ulong;                (* Unread, ReturnRecipt, Sent, Response *)
      lpOriginator : pMapiRecipDesc;  (* Originator descriptor *)
      nRecipCount : ulong;            (* Number of recipients *)
      lpRecips : pMapiRecipDesc;      (* Recipient descriptors *)
      nFileCount : ulong;             (* Number of file attachments *)
      lpFiles : pMapiFileDesc;        (* Attachment descriptors *)
      nSentForCount : ulong;          (* number of users message is sent for *)
      lpSentFor : pMapiRecipDesc;     (* Users that message is sent for *)
   end;

   pSPlusAppt = ^tSPlusAppt;
   tSPlusAppt = record
      ulReserved : ulong;               (* Reserved for future use. Must be 0. *)
      lpszItemType : pchar;             (* String specifying the item type *)
      flFlags : tflags;                 (* Private, Tentative *)
      lpCreator : pMapiRecipDesc;       (* Identity of appointment creator *)
      nAssocCount : ulong;              (* Number of associated items *)
      lpAssoc : pSPlusAssocDesc;        (* Array of associated item descriptors *)
      lpOrganizer : pMapiRecipDesc;     (* Identity of the meeting organizer *)
      lpszOrganizerItemID : pchar;      (* Meeting ID on organizer's schedule *)
      nAttendeeCount : ulong;           (* Number of attendees *)
      lpAttendees : pSPlusAttendeeDesc; (* Attendees for meeting and their status *)
      lpszText : pchar;                 (* Appointment text *)
      lpszBody : pchar;                 (* For future use: must be NULL/empty *)
      lpszRecurrence : pchar;           (* For future use: must be NULL/empty *)
      lpszDateStart : pchar;            (* In YYYY/MM/DD HH:MM format *)
      lpszDateEnd : pchar;              (* In YYYY/MM/DD HH:MM format *)
   end;

   pSPlusTask = ^tSPlusTask;
   tSPlusTask = record
      ulReserved : ulong;               (* Reserved for future use. Must be 0. *)
      lpszItemType : pchar;             (* "Simple Task" or "RecurTaskInstance" *)
      flFlags : tflags;                 (* Private, PrivateProject *)
      lpCreator : pMapiRecipDesc;       (* Identity of task creator *)
      nAssocCount : ulong;              (* Number of associated items *)
      lpAssoc : pSPlusAssocDesc;        (* Array of associated item descriptors *)
      lpOrganizer : pMapiRecipDesc;     (* For future use: must be NULL *)
      lpszOrganizerItemID : pchar;      (* For future use: must be NULL/empty *)
      nAttendeeCount : ulong;           (* For future use: must be 0 *)
      lpAttendees : pSPlusAttendeeDesc; (* For future use: ignored *)
      lpszText : pchar;                 (* Task text *)
      lpszBody : pchar;                 (* For future use: must be NULL/empty *)
      lpszRecurrence : pchar;           (* For future use: must be NULL/empty *)
      lpszDateDue : pchar;              (* Date when this task becomes overdue *)
      lpszDurationActive : pchar;       (* Delta time before due when active *)
      lpszProjectName : pchar;          (* Name of the project *)
      lpszPriority : pchar;             (* Priority of task *)
   end;

   pSPlusUserInfo = ^tSPlusUserInfo;
   tSPlusUserInfo = record
      ulReserved : ulong;           (* Reserved for future use. Must be 0. *)
      lpszUserType : pchar;         (* String specifying the user type *)
      flFlags : tflags;             (* BossWantsCopy *)
      lpAssistant : pMapiRecipDesc; (* Indicates users' assistant *)
      lpszStartTime : pchar;        (* Indicates start of daily work hours *)
      lpszEndTime : pchar;          (* Indicates end of daily work hours *)
      lpszTimeZone : pchar;         (* Reserved for future use. Must be NULL/empty *)
      lpszData : pchar;             (* Additional data specific to the type *)
   end;

   pSPlusRestriction = ^tSPlusRestriction;
   tSPlusRestriction = record
      ulReserved : ulong;            (* Reserved for future use. Must be 0. *)
      lpszItemType : pchar;          (* "Appt" or "Task" *)
      lpszRestrictionType : pchar;   (* A string indicating the restriction *)
      lpszRestrictionData : pchar;   (* Type dependent data *)
   end;


function SPLUSReadMeeting (lhSession : lhandle;
                           ulUIParam : ulong;
                           lpszMessageID : pchar;
                           flFlags : tflags;
                           ulReserved : ulong;
                           var lppMessage : pSPlusMessage;
                           var lppAppt : pSPlusAppt) : ulong;

function SPLUSSendMeeting (lhSession : lhandle;
                           ulUIParam : ulong;
                           lpMessage : pSPlusMessage;
                           lpAppt : pSPlusAppt;
                           flFlags : tflags;
                           ulReserved : ulong) : ulong;

{
function SPLUSSaveMeeting (lhSession : lhandle;
                           ulUIParam : ulong;
                           lpMessage : pSPlusMessage;
                           lpAppt : pSPlusAppt;
                           flFlags : tflags;
                           ulReserved : ulong;
                           lpszMessageID : pchar) : ulong;
}

function SPLUSBeginSession (lhMapiSession : lhandle;
                            ulUIParam : ulong;
                            flFlags : ulong;
                            ulReserved : ulong;
                            lplhSPlusSession : plhandle) : ulong;

function SPLUSEndSession (lhSPlusSession : lhandle;
                          ulUIParam : ulong;
                          flFlags : ulong;
                          ulReserved : ulong) : ulong;

function SPLUSReadFreeBusy (lhSPlusSession : lhandle;
                            ulUIParam : ulong;
                            nUserCount : ulong;
                            lpUsers : pMapiRecipDesc;
                            lpszMonth : pchar;
                            flFlags : ulong;
                            ulReserved : ulong;
                            lpszHaveInfo : pchar;
                            var lppszFreeBusy : pchar) : ulong;

function SPLUSReadUserInfo (lhSPlusSession : lhandle;
                            ulUIParam : ulong;
                            lpUser : pMapiRecipDesc;
                            flFlags : ulong;
                            ulReserved : ulong;
                            var lppUserInfo : pSPlusUserInfo) : ulong;

function SPLUSFindNextItem (lhSPlusSession : lhandle;
                            ulUIParam : ulong;
                            lpUser : pMapiRecipDesc;
                            lpRestriction : pSPlusRestriction;
                            lpszSeedItemID : pchar;
                            flFlags : ulong;
                            ulReserved : ulong;
                            lpszItemID : pchar) : ulong;


function SPLUSDeleteItem (lhSPlusSession : lhandle;
                          ulUIParam : ulong;
                          lpUser : pMapiRecipDesc;
                          lpszItemID : pchar;
                          flFlags : ulong;
                          ulReserved : ulong) : ulong;


function SPLUSSaveAppt (lhSPlusSession : lhandle;
                        ulUIParam : ulong;
                        lpUser : pMapiRecipDesc;
                        lpAppt : pSPlusAppt;
                        flFlags : ulong;
                        ulReserved : ulong;
                        lpszItemID : pchar) : ulong;

function SPLUSSaveTask (lhSPlusSession : lhandle;
                        ulUIParam : ulong;
                        lpUser : pMapiRecipDesc;
                        lpTask : pSPlusTask;
                        flFlags : ulong;
                        ulReserved : ulong;
                        lpszItemID : pchar) : ulong;

function SPLUSReadAppt (lhSPlusSession : lhandle;
                        ulUIParam : ulong;
                        lpUser : pMapiRecipDesc;
                        lpszItemID : pchar;
                        flFlags : ulong;
                        ulReserved : ulong;
                        var lppAppt : pSPlusAppt) : ulong;

function SPLUSReadTask (lhSPlusSession : lhandle;
                        ulUIParam : ulong;
                        lpUser : pMapiRecipDesc;
                        lpszItemID : pchar;
                        flFlags : ulong;
                        ulReserved : ulong;
                        var lppTask : pSPlusTask) : ulong;


const                                       (* error codes *)
   splus_e_invalid_sent_for       = 10000;
   splus_e_not_installed          = 10005;
   splus_e_no_items               = 10010;
   splus_e_no_schedule            = 10015;
   splus_e_no_privilege           = 10020;
   splus_e_invalid_address_format = 10025;
   splus_e_invalid_user           = 10030;
   splus_e_invalid_item           = 10035;
   splus_e_invalid_type           = 10040;
   splus_e_invalid_flags          = 10045;
   splus_e_invalid_assoc          = 10050;
   splus_e_invalid_organizer      = 10055;
   splus_e_invalid_organizer_id   = 10060;
   splus_e_invalid_attendees      = 10065;
   splus_e_invalid_time           = 10070;
   splus_e_invalid_priority       = 10075;
   splus_e_invalid_month          = 10080;
   splus_e_invalid_restriction    = 10085;
   splus_e_alarm_ring_in_past     = 10090;
   splus_e_not_online             = 10095;
   success_no_schedule            = 10100;

implementation


function SPLUSReadMeeting;    external 'SPLUS' Index 12;
function SPLUSSendMeeting;    external 'SPLUS' Index 10;
function SPLUSBeginSession;   external 'SPLUS' Index 13;
function SPLUSEndSession;     external 'SPLUS' Index 14;
function SPLUSReadFreeBusy;   external 'SPLUS' Index 22;
function SPLUSReadUserInfo;   external 'SPLUS' Index 21;
function SPLUSFindNextItem;   external 'SPLUS' Index 19;
function SPLUSDeleteItem;     external 'SPLUS' Index 20;
function SPLUSSaveAppt;       external 'SPLUS' Index 17;
function SPLUSSaveTask;       external 'SPLUS' Index 18;
function SPLUSReadAppt;       external 'SPLUS' Index 15;
function SPLUSReadTask;       external 'SPLUS' Index 16;

end.
