{
 Designer:  Craig Ward
 Date:      1/9/95

 Function:  Check execution of WinExec command line
*******************************************************************************}
unit WinChk;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs;

type
 TCheckWinExec = class(TComponent)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    { Public declarations }
    function custCheckWinExec(i: integer): string;
  published
    { Published declarations }
end;

procedure Register;

{****************************************************************************}
implementation

{procedure to register this as a custom component}
procedure Register;
begin
  RegisterComponents('Samples', [TCheckWinExec]);
end;

{read the returned value, and return text}
function TCheckWinExec.custCheckWinExec(i: integer): string;
var
 s: string;
begin
 case i of
  0:
   result := 'System was out of memory, executable file was corrupt, or relocations were invalid.';
  2:
   result := 'File was not found.';
  3:
   result := 'Path was not found.';
  5:
   result :=	'Attempt was made to dynamically link to a task, or there was a sharing or network-protection error.';
  6:
   result := 'Library required separate data segments for each task.';
  8:
   result :=	'There was insufficient memory to start the application.';
  10:
   result := 'Windows version was incorrect.';
  11:
   result :=	'Executable file was invalid. Either it was not a Windows application or there was an error in the .EXE image.';
  12:
   result :=	'Application was designed for a different operating system.';
  13:
   result := 'Application was designed for MS-DOS 4.0.';
  14:
   result :=	'Type of executable file was unknown.';
  15:
   result := 'Attempt was made to load a real-mode application (developed for an earlier version of Windows).';
  16:
   result := 'Attempt to load second instance of an executable containing multiple data segments not marked read-only.';
  19:
   result :=	'Attempt was made to load a compressed executable file. The file must be decompressed before it can be loaded.';
  20:
   result := 'Dynamic-link library (DLL) file was invalid. One of the DLLs required to run this application was corrupt.';
  21:
   result :=	'Application requires 32-bit extensions.';
 end;
end;


end.
