{$N+}
{$DEFINE USE_SENDMESSAGE}  { change the "$" to a "-" if you
                           don't want to use SendMessage()
                           (ONLY if you're compiling a .WLL!) }

UNIT CAPILib;
{ Library routines to support the Word's API
  translated from "C" to BPascal by M.Austermeier 100116.3455@compuserve.com
  req. Borland Pascal 7.x or Delphi 1.x to compile

"These materials were developed from a Product of Microsoft Corporation,
which reserves all rights. They have been modified by Martin Austermeier"
See also the disclaimer in README.TXT

}

INTERFACE
USES
  WdCmds, WdFid;


CONST
  T_NONE   = 0;       { TypeXXX }
  T_SHORT  = 1;
  T_LONG   = 2;
  T_DOUBLE = 3;
  T_STRING = 4;

CONST
  MAX_ARGS = 34;  { MaxArgs based on largest dialog }

TYPE
  TFType = Integer;  { s. T_xxx }

TYPE
  TArrayDef = RECORD
    cArrayDimensions : Integer;
    arrayDimensions : Array[0..0] OF Byte;
  END;
  PArrayDef = ^TArrayDef;

  AFlag = (T0, T1, T2, T3, DataIsArray, DlgSetData, DlgGetData, bufferTooSmall);
  TFlags = SET OF AFlag;

  PDoubleArray = Pointer;
  PStringArray = ^PChar;

  TOperator = RECORD  { WDOPR }
    dat : RECORD CASE Integer OF
      0 : (vShort : Integer);
      1 : (vLong : LongInt);
      2 : (vDouble : Double);
      3 : (vString : PChar);
      4 : (Arr : PArrayDef;
           ptr : RECORD CASE Boolean OF
             FALSE : (DoubleArray : PDoubleArray);
             TRUE : (StringArray : PStringArray);
           END;
          );
    END;

    bufferSize : Word;
    ft : RECORD CASE Boolean OF
      FALSE : (flags : TFlags);  { type & flags }
      TRUE : (typ : TFType);    { 2 bytes }
    END;
    { resvd : Byte; }
    fldID : Word;
  END;
  POperator = ^TOperator;


TYPE
  { Input and output constants for dialog commands }
  EnumIOMode = (DLG_GET_DATA, DLG_SET_DATA);
  TIOMode = SET OF EnumIOMode;

TYPE  { DlgOption }
  ADlgOption = (CMD_DEFAULTS, { GetCurValues }
                CMD_DIALOG,  {display dialog}
                CMD_ACTION,
                CMD_DLG_ACTION);

TYPE
  TControlBlock = RECORD
    cmdID : Integer;       { *new: command ID }
    retBuf : Pointer;      { *new* for automatic function return }
    retBufSize : Word;     { *new* for automatic function return }
    isFunction : Boolean;  { *new: is it a WordBasic FUNCTION? }
    dlgIOMode : TIOMode;   { *new }
    dlgOpts : ADlgOption;  { *new }
    argsCount : Integer;   { cArgs (=index in args array) }
    returnOp : TOperator;  { wdopReturn }
    args : Array[0..MAX_ARGS-1] OF TOperator; { wdoprArgs[MaxArgs] }
  END;
  PControlBlock = ^TControlBlock;

TYPE
  TWordCommand = OBJECT
    wcb : TControlBlock;

    {----------------------------------}
    CONSTRUCTOR Init(commandID : Integer;
                     retType : TFType;
                     retBuf : PChar;
                     retBufSize : Word);
    { commandID: see WDCMDS.PAS;
      retType : type of function return;
      retBuf : (only if retType <> T_NONE) pointer to a buffer where
                RETURNed values are to be stored (max Len=retBufSize)
    }
    {----------------------------------}
    DESTRUCTOR Done;
    {----------------------------------}
    PROCEDURE AddShortParam(shortVal : Integer);
    {----------------------------------}
    PROCEDURE AddLongParam(longVal : Integer);
    {----------------------------------}
    PROCEDURE AddDoubleParam(doubleVal : Double);
    {----------------------------------}
    PROCEDURE AddStringParam(strP : PChar);
    {----------------------------------}
    FUNCTION Execute : Integer;
    { call wdCommandDispatch;
      returns 0 if OK, else wdError.xx }
    {----------------------------------}
  PRIVATE
    PROCEDURE _GetResult(buffer : Pointer; bufSize : Word);
    { copies function result into buffer^, if available }
    {----------------------------------}
  END;
  PWordCommand = ^TWordCommand;


  TWordDlgCommand = OBJECT(TWordCommand)
    {----------------------------------}
    CONSTRUCTOR Init(commandID : Integer;
                     retType : TFType;
                     retBuf : PChar;
                     retBufSize : Word;
                     dialogOption : ADlgOption;
                     fMode : TIOMode);
    {----------------------------------}
    PROCEDURE AddShortDlgField(fieldId : Word; shortVal : Integer);
    {----------------------------------}
    PROCEDURE AddLongDlgField(fieldId : Word; longVal : LongInt);
    {----------------------------------}
    PROCEDURE AddDoubleDlgField(fieldId : Word; doubleVal : Double);
    {----------------------------------}
    PROCEDURE AddStringDlgField(fieldId : Word; strP : PChar; bufSize : Word);
    {----------------------------------}
  PRIVATE
    {----------------------------------}
    PROCEDURE _SetDlgField(fieldId : Word; fType : TFType);
    {----------------------------------}
  END;
  PWordDlgCommand = ^TWordDlgCommand;


  TWordArrayCommand = OBJECT(TWordCommand)
    { AddStringArray; AddDoubleArray NOT IMPLEMENTED! }
  END;
  PWordArrayCommand = ^TWordArrayCommand;

{-------------------------------------------------------------------}
FUNCTION Register(docID : Integer; functionName, description : PChar) : Word;
{ Register new command with Word }
{-------------------------------------------------------------------}

IMPLEMENTATION
USES
  WinTypes, WinProcs;


VAR
  hWordWnd : HWnd;


CONSTRUCTOR TWordCommand.Init(commandID : Integer;
                              retType : TFType;
                              retBuf : PChar;
                              retBufSize : Word);
BEGIN
  FillChar(wcb, SizeOf(wcb), 0);

  wcb.cmdID := commandID;
  wcb.returnOp.ft.typ := retType;
  wcb.retBuf := retBuf;
  wcb.retBufSize := retBufSize;

  IF (retType = T_STRING) THEN WITH wcb.returnOp DO BEGIN
    dat.vString := retBuf;
    bufferSize := retBufSize;
  END;
END;


DESTRUCTOR TWordCommand.Done;
BEGIN { remove VMT } END;


PROCEDURE TWordCommand.AddShortParam(shortVal : Integer);
BEGIN
  WITH wcb.args[wcb.argsCount] DO BEGIN
    dat.vShort := shortVal;
    ft.typ := T_SHORT;
  END;
  Inc(wcb.argsCount);
END;


PROCEDURE TWordCommand.AddLongParam(longVal : Integer);
BEGIN
  WITH wcb.args[wcb.argsCount] DO BEGIN
    dat.vLong := longVal;
    ft.typ := T_LONG;
  END;
  Inc(wcb.argsCount);
END;


PROCEDURE TWordCommand.AddDoubleParam(doubleVal : Double);
BEGIN
  WITH wcb.args[wcb.argsCount] DO BEGIN
    dat.vDouble := doubleVal;
    ft.typ := T_DOUBLE;
  END;
  Inc(wcb.argsCount);
END;


PROCEDURE TWordCommand.AddStringParam(strP : PChar);
BEGIN
  WITH wcb.args[wcb.argsCount] DO BEGIN
    dat.vString := strP;
    ft.typ := T_STRING;
  END;
  Inc(wcb.argsCount);
END;


{ AddStringArray; AddDoubleArray NOT IMPLEMENTED! }


PROCEDURE TWordCommand._GetResult(buffer : Pointer; bufSize : Word);
BEGIN
  IF (wcb.returnOp.ft.typ = T_NONE)  { no function result }
  OR (wcb.returnOp.ft.typ = T_STRING) { unnecessary with T_STRING }
  OR (buffer = NIL)  { no return buffer provided }
  THEN  
    Exit;  

  Move (wcb.returnOp.dat, buffer^, bufSize);  { copy result to buffer }
END;




{$IFNDEF USE_SENDMESSAGE *********************************************}

FUNCTION WdCommandDispatch(commandId,
                           dlgOptions,
                           cArgs : Integer;
                           operators : POperator;
                           ret : POperator) : Integer;
FAR; EXTERNAL 'WINWORD';


FUNCTION TWordCommand.Execute : Integer;
VAR
  retP : POperator;
  ret : Integer;
BEGIN
  WITH wcb DO BEGIN
    IF (returnOp.ft.typ <> T_NONE) THEN
      retP := @returnOp
    ELSE
      retP := NIL;

    ret :=
      WdCommandDispatch(cmdId,
                     Integer(dlgOpts),
                     argsCount,
                     @args,
                     retP);
    IF (ret = 0) THEN
      _GetResult(retBuf, retBufSize);
    Execute := ret;

  END;
END;


{$ELSE (USE_SENDMESSAGE; Word is to be called from .EXE via Sendmessage()) *** }


FUNCTION TWordCommand.Execute : Integer;
{ call wdCommandDispatch via SendMessage
  (takes the same time; avoids stack problems when called
  from your .EXE instead of a .WLL);
  returns 0 if OK, else wdError.xx }
CONST
  WM_USER = $0400;
  WM_WORD_CAPI = WM_USER + $0300;

  WINWORD_CLASS = 'OpusApp';
VAR
  msg : RECORD
    cmdID : Integer;
    dlgOpts : Integer;
    cArgs : Integer;
    lpwdoprArgs,
    lpwdoprReturn : PControlBlock;
  END;
  ret : Integer;
BEGIN
  { get hWordWnd }
  IF NOT IsWindow(hWordWnd) THEN
    hWordWnd := FindWindow(WINWORD_CLASS, NIL);

  IF (hWordWnd = 0) THEN BEGIN
    Execute := 5031;  { wdError.errCAPICommandFailed }
  END ELSE WITH wcb DO BEGIN
    msg.cmdID := cmdId;
    msg.dlgOpts := Integer(dlgOpts);
    msg.cArgs := argsCount;
    msg.lpwdoprArgs := @args;
    IF (returnOp.ft.typ <> T_NONE) THEN
      msg.lpwdoprReturn := @returnOp
    ELSE
      msg.lpwdoprReturn := NIL;

    ret := SendMessage(hWordWnd, WM_WORD_CAPI, 0, LongInt(@msg));
    IF (ret = 0) THEN
      _GetResult(retBuf, retBufSize);
    Execute := ret;
  END;
END;
{$ENDIF USE_SENDMESSAGE **************************************************}


(*************************************************************************
                           TWordDlgCommand
 *************************************************************************)
CONSTRUCTOR TWordDlgCommand.Init(commandID : Integer;
                 retType : TFType;
                 retBuf : PChar;
                 retBufSize : Word;
                 dialogOption : ADlgOption;
                 fMode : TIOMode);
BEGIN
  INHERITED Init(commandID, retType, retBuf, retBufSize);
  wcb.dlgOpts := dialogOption;
  wcb.dlgIOMode := fMode;
END;


PROCEDURE TWordDlgCommand._SetDlgField(fieldId : Word; fType : TFType);
BEGIN
  WITH wcb.args[wcb.argsCount] DO BEGIN
    ft.typ := fType;
    fldId := fieldId;
    IF (DLG_GET_DATA IN wcb.dlgIOMode) THEN
      Include(ft.flags, DlgGetData);
    IF (DLG_SET_DATA IN wcb.dlgIOMode) THEN
      Include(ft.flags, DlgSetData);
  END;
END;


PROCEDURE TWordDlgCommand.AddShortDlgField(fieldId : Word; shortVal : Integer);
BEGIN
  wcb.args[wcb.argsCount].dat.vShort := shortVal;
  _SetDlgField(fieldId, T_SHORT);
  Inc(wcb.argsCount);
END;


PROCEDURE TWordDlgCommand.AddLongDlgField(fieldId : Word; longVal : LongInt);
BEGIN
  wcb.args[wcb.argsCount].dat.vLong := longVal;
  _SetDlgField(fieldId, T_LONG);
  Inc(wcb.argsCount);
END;


PROCEDURE TWordDlgCommand.AddDoubleDlgField(fieldId : Word; doubleVal : Double);
BEGIN
  wcb.args[wcb.argsCount].dat.vDouble := doubleVal;
  _SetDlgField(fieldId, T_DOUBLE);
  Inc(wcb.argsCount);
END;


PROCEDURE TWordDlgCommand.AddStringDlgField(fieldId : Word; strP : PChar; bufSize : Word);
BEGIN
  wcb.args[wcb.argsCount].dat.vString := strP;
  _SetDlgField(fieldId, T_STRING);
  wcb.args[wcb.argsCount].bufferSize := bufSize;
  Inc(wcb.argsCount);
END;


(*************************************************************************
                              Utilities
 *************************************************************************)
FUNCTION Register(docID : Integer; functionName, description : PChar) : Word;
VAR
  wcb : TWordCommand;
BEGIN
  wcb.Init(wdAddCommand, T_SHORT, NIL, 0);
  wcb.AddShortParam(docID);
  wcb.AddStringParam(functionName);
  IF (Assigned(description)) THEN
    wcb.AddStringParam(description);

  Register := wcb.Execute;
  wcb.Done;
END;

{ CAPIAddXXXX NOT IMPLEMENTED! }

(************************************************************************
                                ExitProc
 ************************************************************************)
VAR
  saveExit : Pointer;
  hWordLib : THandle;

PROCEDURE MyExitProc; FAR;
BEGIN
  exitProc := saveExit;
  IF (hWordLib > 31) THEN
    FreeLibrary(hWordLib);
END;


(************************************************************************
                                   Init
 ************************************************************************)
BEGIN
  hWordWnd := 0;
END.


(*** the following won't work :-(
that is why the WLL conditional definition has to be set..

CONST
  WINWORD_NAME = 'WINWORD';

VAR
  proc : TFarProc ABSOLUTE wordDispatcher;
  wHandle : THandle;
  fName : Array[0..79] OF Char;


  wordDispatcher := NIL;  { assume: Word not found }

  wHandle := GetModuleHandle(WINWORD_NAME);
  IF (wHandle = 0) then
    hWordLib := 0  { WinWord not loaded }
  ELSE BEGIN
    hWordLib := LoadLibrary(WINWORD_NAME);

    IF (hWordLib > 31) THEN BEGIN
      { set wordDispatcher (via "proc") }
      proc := GetProcAddress(hWordLib, 'WDCOMMANDDISPATCH');
      MessageBox(0, 'WinWord found', 'WLLTEST', MB_OK);
      saveExit := exitProc;
      exitProc := @MyExitProc;
    END ELSE BEGIN
      proc := GetProcAddress(wHandle, 'WDCOMMANDDISPATCH');
      wvsprintf(fName, '%x', wHandle);
      if (proc = NIL) then
        MessageBox(0, fName, 'WLLTEST', MB_OK);

    END;
  END;

END.
***)


