{ include file for WLLTEST and EXETEST }

(****************************************************************************
                       utility functions
 ****************************************************************************)
PROCEDURE ErrorBox(caption : PChar; err : Integer);
VAR
  s : Array[0..10] OF Char;
BEGIN
  Str(err, s);
  MessageBox(0, s, caption, MB_OK);
END;


FUNCTION ExecuteCommand(VAR wcb : TWordCommand) : Boolean;
{ call Word API; display error message }
VAR
  i : Integer;
  st : Array[0..5] OF Char;
BEGIN
  i := wcb.Execute;         { Execute the command }

  IF (i <> 0) THEN BEGIN
    Str(wcb.wcb.cmdId, st);  { use cmdID as error box caption }
    ErrorBox(st, i);
  END;
  ExecuteCommand := (i = 0);
END;


(****************************************************************************
                            sample functions
 ****************************************************************************)
FUNCTION WEditGoTo(dest : PChar) : Boolean;
{ example of a dialog command }
VAR
  wcb : TWordDlgCommand;
BEGIN
  wcb.Init(wdEditGoTo, T_NONE, NIL, 0, CMD_ACTION, [DLG_SET_DATA]);

  wcb.AddStringDlgField(fidDestination, dest, StrLen(dest)+1);
  WEditGoTo := ExecuteCommand(wcb);
  wcb.Done;
END;


FUNCTION WInsert(txt : PChar) : Boolean;
{ example of a non-dialog command }
VAR
  wcb : TWordCommand;
  i : Integer;
BEGIN
  wcb.Init(wdInsert, T_NONE, NIL, 0);
  wcb.AddStringParam(txt);
  WInsert := ExecuteCommand(wcb);;
  wcb.Done;
END;


FUNCTION WSelection(st : PChar; maxSize : Word) : Boolean;
{ example of a function returning a string }
VAR
  wcb : TWordCommand;
  p : PChar;
BEGIN
  wcb.Init(wdSelectionStr, T_STRING, st, maxSize);
  WSelection := ExecuteCommand(wcb);
  wcb.Done;
END;


FUNCTION WInt(n : Double; VAR rslt : Integer) : Boolean;
{ example of a function returning an Integer }
VAR
  wcb : TWordCommand;
  p : PChar;
BEGIN
  wcb.Init(wdInt, T_SHORT, @rslt, SizeOf(rslt));
  wcb.AddDoubleParam(n);
  WInt := ExecuteCommand(wcb);
  wcb.Done;
END;


PROCEDURE Test1;
VAR
  strBuf : Array[0..100] OF Char;
  int : Integer;
BEGIN
  { get Selection$() }
  IF NOT WSelection(strBuf, SizeOf(strBuf)) THEN
    Exit;
  MessageBox(0, strBuf, 'Selection', MB_OK);

  { EditGoto .dest="\StartOfDoc" }
  IF NOT WEditGoTo('\StartOfDoc') THEN
    Exit;

  { Insert "Test" }
  IF NOT WInsert('Test') THEN
    Exit;

  IF (WInt(123.4567, int)) THEN BEGIN
    Str(int, strBuf);
    MessageBox(0, strBuf, 'Int() result', MB_OK);
  END ELSE
    Exit;
END;

{EOF}

