unit XDB;

interface


 Const
    inactive = 1;
    active = 2;
    XDB_free = 0;
    SQL_ERROR = -1;
    SQL_NO_DATA_FOUND = 100;
    SQL_SUCCESS = 0;
    SQL_SUCCESS_WITH_INFO = 1;
    SQL_CLOSE = 0;
    SQL_CHAR = 1;
    SQL_NUMERIC = 2;
    SQL_DECIMAL = 3;
    SQL_INTEGER = 4;
    SQL_SMALLINT = 5;
    SQL_FLOAT = 6;
    SQL_REAL = 7;
    SQL_DOUBLE = 8;
    SQL_DATE = 9;
    SQL_TIME = 10;
    SQL_TIMESTAMP = 11;
    SQL_VARCHAR = 12;
    SQL_DATA_SOURCE_NAME = 6;
    SQL_USER_NAME = 8;
    SQL_ACTIVE_STATEMENTS = 1;
    SQL_IDENTIFIER_QUOTE_CHAR = 29;
    SQL_ASYNC_ENABLE = 4;
    SQL_DBMS_NAME = 17;
    CacheBuffer: LongInt = 3000;
    MaxFieldLength = 15; {Dieser Wert mu fr die Datenbank angepasst werden}

 {ODBC.DLL}
 function SQLAllocEnv(Var InternHENV: Longint): Integer;
 function SQLFreeEnv(InternHENV: Longint): Integer;
 function SQLAllocConnect(InternHENV: Longint; Var InternHdbc: Longint): Integer;
 function SQLDriverConnect(hdbc: Longint; hwnd: Integer; szCsin: PChar;
          szCLen: Integer; szCsout: PChar; cbCSMax: Integer;
          Var cbCsOut: Integer; f: Integer): Integer;
 function SQLAllocStmt(hdbc: Longint; Var hstmt: Longint): Integer;
 function SQLFreeStmt(hstmt: Longint; EndOption: Integer): Integer;
 function SQLFreeConnect(hdbc: Longint): Integer;
 function SQLDisconnect(hdbc: Longint): Integer;
 function SQLError(env: Longint; hdbc: Longint; hstmt: Longint; SQLState: PChar;
          Var NativeError: LongInt; Buffer: PChar; Buflen: Integer; Var Outlen: Integer): Integer;
 function SQLGetInfo(hdbc: Longint; infotype: Integer; Var szInfo: Integer;
          InfoMax: Integer; Var InfoOut: Integer): Integer;
 function SQLGetInfoStr(hdbc: Longint; infotype: Integer; szInfo: PChar;
          InfoMax: Integer; Var InfoOut: Integer): Integer;
 function SQLTables(hstmt: longint; q: longint; cbq: Integer; cbqo: longint;
          cbo: integer; t: PChar; cbt: Integer; tt: PChar; cbtt: Integer): Integer;
 function SQLNumResultCols(hstmt: longint; Var NumCols: Integer): Integer;
 function SQLFetch(hstmt: longint):Integer;
 function SQLGetData(hstmt: longint; col: Integer; wConvType: Integer; lpbBuf: PChar;
           dwbuflen: longint; Var lpcbout: longint):Integer;
 function SQLPrepare(hstmt: longint; sqlString: PChar; strlen: Longint): Integer;
 function SQLExecDirect(hstmt: Longint; sqlString: PChar; sqllen: Longint): Integer;
 function SQLDescribeCol(hstmt: Longint; colnum: Integer; colname: PChar; Buflen: Integer;
           Var colnamelen: Integer; Var dtype: Integer; var dl: Longint; var ds: Integer;
           Var n: Integer): Integer;
 function SQLBindCol(hstmt: Longint; col: Integer; wConvType: Integer; rgbValue: Pointer;
           cbValueMax: Longint; pcbValue: PChar): Integer;
 function SQLSetParam(hstmt: Longint; ipar: Integer; fCType: Integer; fSqlType: Integer;
           cbColDef: Longint; ibScale: Integer; sqlstring: PChar; Var sqlstrlen: Longint): Integer;
 function SQLExecute(hstmt: Longint): Integer;
 function SQLSetStmtOption(hstmt: Longint; foption: Integer; vParam: Longint): Longint;
 function SQLRowCount(hstmt: Longint; Var pcrow: Longint):Integer;


 {Eigene Object's}


 Type ODBCHandles = Class(TObject)
      DBMS_Name : String[30];
      Server : String;
      Owner : String[15];
      DL : String[1];
      Status : Integer; {0=free 1=inactive 2=active}
      MaxAnzStmt : Integer;
      Hdbc : Array[1..20] of Longint;
      Stmt : Array[1..20] of Longint;
      StmtStatus : Array[1..20] of Integer; {0=free 1=inactive 2=active}
      AnzStmt: Integer;
      HENV: Longint;
      AnzDynasets: Integer;
      function Attempt(SqlStatus: Integer; ErrorText: String): Boolean;
      function GetNewStmt: Integer;
      function DescribeError(hdbc: longint; hstmt: longint): String;
      function IExecuteSQL(sql: PChar): Longint;
 end;



 Type XDB_Dynaset = Class(TObject)
    EOF: Boolean;
    BOF: Boolean;
    ReadOnly: Integer;
    Errcode: Integer;
    ErrText: String;
    RecordCount: Integer;
    FieldCount: Integer;
 Private
    Intern: ODBCHandles;
    PDataChanged: PChar; {Pointer auf Datenbereich}
    PTypes: PChar;       {Pointer auf Datenbereich Byte}
    PMaxLength: PChar; {Pointer auf Datenbereich Integer}
    InternFieldNames: PChar; {Pointer auf Datenbereich}
    PLength: PChar;   {Pointer auf Datenbereich Longint   --> Diese zwei Datenfelder }
    PData: PChar;     {Pointer auf Datenbereich           --> immer zusammen lassen  }
    FileBuffer: PChar;  {Pointer auf <Cachebuffer> Bytes Filebuffer}
    FileHandle: Integer;
    MemoryHandleA: Longint;
    MemoryHandleB: Longint;
    ExtendedScrolling: Integer; {0=Only Forward 1=Extended Large Table}
    ExtendedKeyName: String[MaxFieldLength]; {Feldname Primary Key}
    ExtendedKeyType: Integer;
    KeyPuffer:Array[0..255] of Char;
    PFields:Array[1..255] of Pointer; {Pufferadressen der einzelnen Col}
    TimeStampNr: Integer;
    TimeStamp: String[MaxFieldLength];
    StmtInd1: Integer;
    StmtInd2: Integer;
    KeyLength: Longint;
    KeyMaxLength: Integer;
    KeySqlType: Integer;
    IFile: Array[0..144] of Char;
    FilePos: Longint;
    FileLength: Longint;
    BufferLength: Longint;
    TableName: String[40];
    InsertDynaset: Boolean;
    InsertFlag: Boolean;
    ParamType1: Byte;
    ParamType2: Byte;
    ParamType3: Byte;
    ParamLength1: Longint;
    ParamLength2: Longint;
    ParamLength3: Longint;
    PParam1: Array[0..60] of Char;
    PParam2: Array[0..60] of Char;
    PParam3: Array[0..60] of Char;
    OpenMerker: Boolean;
    function ibECopy(dest: PChar; source: String): PChar;
    function GetFieldsPNr(nr: Integer): String;
    function GetFields(Index: String): String;
    function GetFieldsNr(Index: Byte): String;
    function GetSQLLength: Longint;
    function GetUpdateSQL(pSQL: PChar): Boolean;
    procedure SetFields(Index: String; AValue: String);
    procedure SetFieldsNr(Index: Byte; AValue: String);
    function GetChanged(Index: String): Boolean;
    procedure SetChanged(Index: String; AValue: Boolean);
    procedure ResetDataChange;
    function GetTypes(Index: String): Byte;
    function GetTypesNr(Index: Byte): Byte;
    function GetMaxLengthNr(Index: Integer): Longint;
    function FileMoveFirst: Integer;
    function FileMoveLast: Integer;
    function FileMoveNext: Integer;
    function FileMovePrevious: Integer;
    function FileGetCurrent: Integer;
    function FileAddRec: Integer;

 public
    constructor Create(pt1: Byte; pt2: Byte; pt3: Byte; InternDB: ODBCHandles; SQL: PChar;
                       Opt: Integer; Const PrimaryKey: String; Const ScrollMode: Integer;
                       Const TimeStampName: String);
    destructor Close;
    procedure AddNew;
    function Update: Boolean;
    function MoveFirst: Boolean;
    function MoveLast: Boolean;
    function MoveNext: Boolean;
    function MovePrevious: Boolean;
    function ExecuteDynaset(p1: String; p2: String; p3: String): Boolean;
    function GetFieldNr(Index: String): Integer;
    function GetFieldName(Index: Integer): String;
    property Fields[Index: String]: String Read GetFields Write SetFields;
    property FieldsNr[Index: Byte]: String Read GetFieldsNr Write SetFieldsNr;
    property Changed[Index: String]: Boolean Read GetChanged Write SetChanged;
    property Types[Index: String]: Byte Read GetTypes;
    property TypesNr[Index: Byte]: Byte Read GetTypesNr;
    property MaxLengthNr[Index: Integer]: Longint Read GetMaxLengthNr;
 End;


  Type XDB_Database = class(TObject)
      ConnectionString : String;
      ReadOnly : Boolean;
      Errcode : Integer;
      ErrText : String;
      DL : String[1];
      Owner : String[15];
      DBMS_Name : String[30];
      function GetOwner(TableName: String): String;
      function CreateDynaset(SQL: PChar; Opt: Integer; PrimaryKey: String;
                             ScrollMode: Integer; TimeStamp: String):XDB_Dynaset;
      function PrepareDynaset(p1: Byte; p2: Byte; p3: Byte; SQL: PChar; Opt: Integer; PrimaryKey: String;
                             ScrollMode: Integer; TimeStamp: String):XDB_Dynaset;
 private
      Intern: ODBCHandles;
      function Attempt(SqlStatus: Integer; ErrorText: String): Boolean;
 public
      constructor OpenDatabase(ConnectString: String; Opt: Integer);
      destructor Close;
 end;




implementation

uses  WinProcs, Forms, Sysutils;

{ODBC.DLL}
 function SQLAllocEnv; external 'ODBC';
 function SQLFreeEnv; external 'ODBC';
 function SQLAllocConnect; external 'ODBC';
 function SQLDriverConnect; external 'ODBC';
 function SQLAllocStmt; external 'ODBC';
 function SQLFreeStmt; external 'ODBC';
 function SQLFreeConnect; external 'ODBC';
 function SQLDisconnect; external 'ODBC';
 function SQLError; external 'ODBC';
 function SQLGetInfo; external 'ODBC';
 function SQLGetInfoStr; external 'ODBC' name 'SQLGetInfo';
 function SQLTables; external 'ODBC';
 function SQLNumResultCols; external 'ODBC';
 function SQLFetch; external 'ODBC';
 function SQLGetData; external 'ODBC';
 function SQLPrepare; external 'ODBC';
 function SQLExecDirect; external 'ODBC';
 function SQLDescribeCol; external 'ODBC';
 function SQLBindCol; external 'ODBC';
 function SQLSetParam; external 'ODBC';
 function SQLExecute; external 'ODBC';
 function SQLSetStmtOption; external 'ODBC';
 function SQLRowCount; external 'ODBC';






 {Implementation XDB_Dynaset}

constructor XDB_Dynaset.Create(pt1: Byte; pt2: Byte; pt3: Byte; InternDB: ODBCHandles;
                               SQL: PChar; Opt: Integer;
                               Const PrimaryKey: String; Const ScrollMode: Integer;
                               Const TimeStampName: String);
Var
  MaxColWidth: Longint; ColTypeCode: Integer; ColNullable: Integer;
  Outlen: Integer; LongOutLen: Longint;
  ColScale: Integer;
  pm: Integer; i: Integer; t: Integer;
  BindMerker: Boolean;
  sql2: Array[0..255] of Char;
  sql3: Array[0..255] of Char;
  P1, P2: PChar;
  hstmt: Longint; hdbc: Longint;
  Reclen: Integer;
  XDB_SBuffer:Array[0..255] of Char;
  FeldPuffer:Array[0..4000] of Char;
  FPointer: PChar;
  FPuf: String[6];
  PPTypes: PChar;
  PPMaxLength: PChar;
  PPLength: PChar;
  PPData: Pchar;
  XDB_rc: Integer;
  HilfPointer: PChar;
  HilfInteger: Integer;
  HilfIntegerPointer: ^Integer;
begin
  inherited Create;
  Openmerker := False;
  Intern := InternDB;
  RecordCount := 0;
  TimeStamp := TimeStampName;
  ExtendedScrolling := Scrollmode;
  ExtendedKeyName := PrimaryKey;
  If (ExtendedScrolling = 1) and (ExtendedKeyName = '') Then
  begin
      Application.MessageBox('Feldname des Primary-Key-Feldes mu angegeben werden',
      'Abbruch',48);
      Exit;
  end;

  If StrLen(sql) > 254  Then
  begin
      Application.MessageBox('Lnge des SQL-Textes ist derzeit auf 254 begrenzt',
      'Abbruch',48);
      Exit;
  end;

  If ExtendedKeyType = 0 Then ExtendedKeyType := 1;

  If Intern.Status <> active Then
  begin
     Application.MessageBox('Datenbank nicht geffnet', 'HINWEIS', 48);
     Exit;
  end;

  InsertDynaset := False;
  Errcode := 0;
  ErrText := '';
  FilePos := 1;
  FileLength := 0;

  StmtInd1 := 0;
  StmtInd2 := 0;
  ParamType1 := pt1;
  ParamType2 := pt1;
  ParamType3 := pt1;

    {Get a New Statementhandle}
  StmtInd1 := Intern.GetNewStmt;
  If StmtInd1 = 0 Then Exit;

    {Prepared SQL }
    If pt1 > 0 Then {Parameter }
    begin
      {Paramater definieren }
      SQLSetParam(Intern.Stmt[StmtInd1], 1, 1, pt1, 60, 0, @PParam1, ParamLength1);
      If pt2 > 0 Then SQLSetParam(Intern.Stmt[StmtInd1], 2, 1, pt2, 60, 0, @PParam2, ParamLength2);
      If pt3 > 0 Then SQLSetParam(Intern.Stmt[StmtInd1], 3, 1, pt3, 60, 0, @PParam3, ParamLength3);
    End;

  StrCopy(sql3, sql);
  StrUpper(sql3);

  {Initialise
   Wenn Extended Scrolling, dann wird nur mit dem Primary Key zugegriffen }
  If ExtendedScrolling = 1 Then
  begin
      {Get a New Statementhandle for the Prepare}
      StmtInd2 := Intern.GetNewStmt;
      If StmtInd2 = 0 Then exit;

      {Build an "Select-SQL" for the Primary Key}
      P1 := StrPos(sql3, ' FROM ');
      StrPCopy(sql2, 'Select ' + Intern.DL + ExtendedKeyName + Intern.DL);
      P2 := @sql2;
      P2 := P2 + StrLen(sql2);
      StrCopy(P2, P1);
      If ParamType1 > 0 Then
      begin
         XDB_rc := SQLPrepare(Intern.Stmt[StmtInd1], sql2, StrLen(sql2));
      end
      Else
      begin
         XDB_rc := SQLExecDirect(Intern.Stmt[StmtInd1], sql2, StrLen(sql2));
      end;
      If XDB_rc <> SQL_SUCCESS Then
      begin
         Errcode := XDB_rc;
         ErrText := Intern.DescribeError(Intern.Hdbc[StmtInd1], Intern.Stmt[StmtInd1]);
         SQLFreeStmt(Intern.Stmt[StmtInd1], 2);
         SQLFreeStmt(Intern.Stmt[StmtInd1], 3);
         Intern.StmtStatus[StmtInd1] := inactive;
         Intern.StmtStatus[StmtInd2] := inactive;
         StmtInd1 := 0;
         StmtInd2 := 0;
         StrPCopy(sql2, ErrText);
         Application.MessageBox(sql2, 'HINWEIS', 48);
         Exit;
      End;

      {Get the SQL-Data-Type of the Primary Key }
      SQLDescribeCol(Intern.Stmt[StmtInd1], 1, XDB_SBuffer,
         255, Outlen, ColTypeCode, MaxColWidth, ColScale, ColNullable);
      KeySqlType := ColTypeCode;
      KeyMaxLength := MaxColWidth;

      {Bind the Primary Key }
      Case ColTypeCode of
       SQL_FLOAT, SQL_DOUBLE: pm := SQL_DOUBLE;
             SQL_REAL :       pm := SQL_REAL;
             SQL_INTEGER:     pm := SQL_INTEGER;
             SQL_SMALLINT:    pm := SQL_SMALLINT;
             SQL_DATE:        pm := SQL_DATE;
             SQL_TIMESTAMP:   pm := SQL_TIMESTAMP;
      Else
        pm := SQL_CHAR;
      End;

      XDB_rc := SQLBindCol(Intern.Stmt[StmtInd1], 1, pm,
             @KeyPuffer, 256, @KeyLength);

      If XDB_rc <> SQL_SUCCESS Then
      begin
         Errcode := XDB_rc;
         ErrText := Intern.DescribeError(Intern.Hdbc[StmtInd1], Intern.Stmt[StmtInd1]);
         SQLFreeStmt(Intern.Stmt[StmtInd1], 2);
         SQLFreeStmt(Intern.Stmt[StmtInd1], 3);
         Intern.StmtStatus[StmtInd1] := inactive;
         Intern.StmtStatus[StmtInd2] := inactive;
         StmtInd1 := 0;
         StmtInd2 := 0;
         StrPCopy(sql2, ErrText);
         Application.MessageBox(sql2, 'HINWEIS', 48);
         Exit;
      end;
      {Perpare the SQL }
      StrCopy(sql2,sql);
      StrUpper(sql2);
      P1 := StrPos(sql2, ' WHERE ');
      If P1 = nil Then P1 := StrPos(sql2, ' ORDER BY ');
      If P1 <> nil Then P1[0] := #0;
      P1 := StrEnd(sql2);
      StrPCopy(P1,' WHERE ' + Intern.DL + ExtendedKeyName + Intern.DL + ' = ? ');
      XDB_rc := SQLPrepare(Intern.Stmt[StmtInd2], sql2, StrLen(sql2));
      If XDB_rc <> SQL_SUCCESS Then
      begin
         Errcode := XDB_rc;
         ErrText := Intern.DescribeError(Intern.Hdbc[StmtInd2], Intern.Stmt[StmtInd2]);
         SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
         SQLFreeStmt(Intern.Stmt[StmtInd1], 2);
         SQLFreeStmt(Intern.Stmt[StmtInd1], 3);
         SQLFreeStmt(Intern.Stmt[StmtInd2], 0);
         SQLFreeStmt(Intern.Stmt[StmtInd2], 2);
         SQLFreeStmt(Intern.Stmt[StmtInd2], 3);
         Intern.StmtStatus[StmtInd1] := inactive;
         Intern.StmtStatus[StmtInd2] := inactive;
         StmtInd1 := 0;
         StmtInd2 := 0;
         StrPCopy(sql2, ErrText);
         Application.MessageBox(sql2, 'HINWEIS', 48);
         Exit;
       end;

       {Paramater definieren }
       XDB_rc := SQLSetParam(Intern.Stmt[StmtInd2], 1, pm,
           KeySqlType, KeyMaxLength, 0, @KeyPuffer, KeyLength);

       hstmt := Intern.Stmt[StmtInd2];
       hdbc := Intern.Hdbc[StmtInd2];
  end
  else
  begin
       If ParamType1 > 0 Then
       begin
          XDB_rc := SQLPrepare(Intern.Stmt[StmtInd1], sql, StrLen(sql));
       end
       Else
       begin
          XDB_rc := SQLExecDirect(Intern.Stmt[StmtInd1], sql, StrLen(sql));
       end;
       If XDB_rc <> SQL_SUCCESS Then
       begin
         Errcode := XDB_rc;
         ErrText := Intern.DescribeError(Intern.Hdbc[StmtInd1], Intern.Stmt[StmtInd1]);
         Intern.StmtStatus[StmtInd1] := inactive;
         StmtInd1 := 0;
         StrPCopy(sql2,ErrText);
         Application.MessageBox(sql2, 'HINWEIS', 48);
         Exit;
       End;
       hstmt := Intern.Stmt[StmtInd1];
       hdbc := Intern.Hdbc[StmtInd1];
  End;

  {Durchfhren
  'Ermittle Anzahl Spalten }
  XDB_rc := SQLNumREsultCols(hstmt, FieldCount);
  If XDB_rc <> SQL_SUCCESS Then
  begin
     Errcode := XDB_rc;
     ErrText := Intern.DescribeError(hdbc, hstmt);
     If StmtInd1 <> 0 Then
     begin
        SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
        SQLFreeStmt(Intern.Stmt[StmtInd1], 2);
        SQLFreeStmt(Intern.Stmt[StmtInd1], 3);
        Intern.StmtStatus[StmtInd1] := inactive;
        StmtInd1 := 0;
     End;
     If StmtInd2 <> 0 Then
     begin
        SQLFreeStmt(Intern.Stmt[StmtInd2], 0);
        SQLFreeStmt(Intern.Stmt[StmtInd2], 2);
        SQLFreeStmt(Intern.Stmt[StmtInd2], 3);
        Intern.StmtStatus[StmtInd2] := inactive;
        StmtInd2 := 0;
     End;
     StrPCopy(sql2, ErrText);
     Application.MessageBox(sql2, 'HINWEIS', 48);
     Exit;
  End;


  If FieldCount > 0 Then
  begin
     {Reserviere Speicher 8 x Anzahl Spalten}
       MemoryHandleA := GlobalAlloc(0, CacheBuffer + 1 + (FieldCount * 4));
       If MemoryHandleA = 0 Then {Kein Speicher}
       begin
          Application.MessageBox('Zuwenig Hauptspeicher verfgbar', 'Fataler Error', 48);
          ErrText := 'Memory low';
          Errcode := 331;
          If StmtInd1 <> 0 Then
          begin
             SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
             SQLFreeStmt(Intern.Stmt[StmtInd1], 2);
             SQLFreeStmt(Intern.Stmt[StmtInd1], 3);
             Intern.StmtStatus[StmtInd1] := inactive;
             StmtInd1 := 0;
          End;
          If StmtInd2 <> 0 Then
          begin
             SQLFreeStmt(Intern.Stmt[StmtInd2], 0);
             SQLFreeStmt(Intern.Stmt[StmtInd2], 2);
             SQLFreeStmt(Intern.Stmt[StmtInd2], 3);
             Intern.StmtStatus[StmtInd2] := inactive;
             StmtInd2 := 0;
          End;
          Exit;
       End;
       {Heap Speicheradressen errechnen}
       HilfPointer := GlobalLock(MemoryHandleA);
       FileBuffer := HilfPointer;
       HilfPointer := HilfPointer + CacheBuffer + 1;
       PDataChanged := HilfPointer;
       HilfPointer := HilfPointer + FieldCount;
       PTypes := HilfPointer;
       PPTypes := HilfPointer;
       HilfPointer := HilfPointer + FieldCount;
       PMaxLength := HilfPointer;
       PPMaxLength := HilfPointer;
       {Get Columnnames und bind it}
       Reclen := 0;
       TimeStampNr := 0;
       FPointer := @FeldPuffer;
       For i := 1 To FieldCount Do
       begin
            XDB_rc := SQLDescribeCol(hstmt, i, XDB_SBuffer, 255, Outlen, ColTypeCode,
                                    MaxColWidth, ColScale, ColNullable);
            FPuf := IntToStr(i);
            While Length(FPuf) < 3 Do FPuf := '0' + FPuf;
            FPuf := '!' + FPuf + '!+';
            StrPCopy(FPointer, FPuf);
            FPointer:= FPointer + 6;

            If XDB_SBuffer[0] = '"' Then
            begin
               StrMove(FPointer, XDB_SBuffer + 1, Outlen - 2);
               FPointer := FPointer + Outlen - 2;
            end
            Else
            begin
               StrMove(FPointer, XDB_SBuffer, Outlen);
               FPointer := FPointer + Outlen;
            End;
            {Korrektur Feldlngen}
            Case ColTypeCode of
               SQL_FLOAT, SQL_DOUBLE : HilfInteger := 8;
               SQL_REAL : HilfInteger := 4;
               SQL_INTEGER : HilfInteger := 4;
               SQL_SMALLINT : HilfInteger := 2;
               SQL_DATE : HilfInteger := 6;
               SQL_TIMESTAMP : HilfInteger := 16;
            Else
               HilfInteger := MaxColWidth + 1; {Wegen Null-Terminator 1 Byte mehr}
            End;
            PPTypes[0] := CHR(ColTypeCode);
            INC(PPTypes);
            StrMove(PPMaxLength,@HilfInteger, 2);
            INC(PPMaxLength, 2);
            Reclen := Reclen + HilfInteger;
   end;
   {Reserviere Speicher fr Datenbereiche}
   MemoryHandleB := GlobalAlloc(0, FPointer - @FeldPuffer + Reclen + 10 + (FieldCount * 4));
   If MemoryHandleB = 0 Then {Kein Speicher}
   begin
          Application.MessageBox('Zuwenig Hauptspeicher verfgbar', 'Fataler Error', 48);
          ErrText := 'Memory low';
          Errcode := 1;
          If StmtInd1 <> 0 Then
          begin
             SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
             SQLFreeStmt(Intern.Stmt[StmtInd1], 2);
             SQLFreeStmt(Intern.Stmt[StmtInd1], 3);
             Intern.StmtStatus[StmtInd1] := inactive;
             StmtInd1 := 0;
          End;
          If StmtInd2 <> 0 Then
          begin
             SQLFreeStmt(Intern.Stmt[StmtInd2], 0);
             SQLFreeStmt(Intern.Stmt[StmtInd2], 2);
             SQLFreeStmt(Intern.Stmt[StmtInd2], 3);
             Intern.StmtStatus[StmtInd2] := inactive;
             StmtInd2 := 0;
          End;
          Exit;
   End;
   {Heap Speicheradressen errechnen}
   InternFieldNames := GlobalLock(MemoryHandleB);
   StrLCopy(InternFieldNames, FeldPuffer, FPointer - @FeldPuffer);
   PLength := InternFieldNames + (FPointer - @FeldPuffer) + 1;
   PData := PLength + (FieldCount * 4);
   PPTypes := PTypes;
   PPLength := PLength;
   PPMaxLength := PMaxLength;
   PPData := PData;
   {Binden der Datenbereiche}
   For i := 1 To FieldCount Do
     begin
            HilfIntegerPointer := @PPMaxLength[0];
            Case ORD(PPTypes[0]) of
             SQL_FLOAT, SQL_DOUBLE: XDB_rc := SQLBindCol(hstmt, i, SQL_DOUBLE, PPData, HilfIntegerPointer^, PPLength);
             SQL_REAL :             XDB_rc := SQLBindCol(hstmt, i, SQL_REAL, PPData, HilfIntegerPointer^, PPLength);
             SQL_INTEGER:           XDB_rc := SQLBindCol(hstmt, i, SQL_INTEGER, PPData, HilfIntegerPointer^, PPlength);
             SQL_SMALLINT:          XDB_rc := SQLBindCol(hstmt, i, SQL_SMALLINT, PPData, HilfIntegerPointer^, PPlength);
             SQL_DATE:              XDB_rc := SQLBindCol(hstmt, i, SQL_DATE, PPData, HilfIntegerPointer^, PPlength);
             SQL_TIMESTAMP:         XDB_rc := SQLBindCol(hstmt, i, SQL_TIMESTAMP, PPData, HilfIntegerPointer^, PPlength);
            Else
               XDB_rc := SQLBindCol(hstmt, i, SQL_CHAR, PPData, HilfIntegerPointer^, PPLength);
            End;
            PFields[i] := PPData;
            INC(PPData, HilfIntegerPointer^);
            INC(PPTypes);
            INC(PPLength, 4);
            INC(PPMaxLength, 2);
   end;
   If TimeStamp <> '' Then TimeStampNr := GetFieldNr(TimeStamp);
   if ExtendedScrolling = 2 then KeyMaxLength := Reclen + (FieldCount * 4);

   OpenMerker := True;
   INC(Intern.AnzDynasets);

   If ParamType1 = 0 Then
   begin
       {'Werte abholen
        'Lesen 1.Datensatz }
        EOF := False;
        BOF := False;
        MoveNext;
        If EOF Then
        begin
           BOF := True;
           AddNew;
        end;

   End;
  End
  Else
  Begin
     OpenMerker := True;
     INC(Intern.AnzDynasets);
  End;

  If TableName = '' Then {Get the touched Table-Name}
  begin
     P1 := StrPos(sql3, ' FROM ');
     P2 := @sql2;
     P1 := P1 + 5;
     {Suchen nach dem ersten zeichen}
     While ((P1 - sql3) < Strlen(sql3)) and (P1[0] = #32) Do INC(P1);
     StrCopy(P2,P1);
     P1 := P2;
     While (P1[0] <> #32) and ((P1 - sql2) < Strlen(sql2)) Do INC(P1);
     P1[0] := #0;
     TableName := StrPas(sql2);
  End;
 end;


destructor XDB_Dynaset.Close;
Var i: Boolean;
begin
   {Globaler Speicher Freigeben}
   Openmerker := False;
   DEC(Intern.AnzDynasets);
   if FileHandle <> 0 then
   begin
     _lClose(FileHandle);
     DeleteFile(StrPas(IFile));
   end;
   if MemoryHandleB <> 0 then
   begin
       i := GlobalUnlock(MemoryHandleB);
       MemoryHandleB := GlobalFree(MemoryHandleB);
   end;
   if MemoryHandleA <> 0 then
   begin
       i := GlobalUnlock(MemoryHandleA);
       MemoryHandleA := GlobalFree(MemoryHandleA);
   end;
   inherited Destroy;
end;




function XDB_Dynaset.ExecuteDynaset(p1: String; p2: String; p3: String): Boolean;
      {Diese Function bringt eine zuvor mit PrepareDynaset vorbereitete
       Sql-Selectanweisung zur Ausfhrung}
Var i: Integer;
begin

      {Parameter in Puffer Kopieren }
       ExecuteDynaset := False;
       If Intern.Status <> active Then
       begin
          Application.MessageBox('Datenbank nicht geffnet', 'HINWEIS',48);
          Exit;
       End;
       ParamLength1 := Length(p1);
       ParamLength2 := Length(p2);
       ParamLength3 := Length(p3);
       If ParamType1 > 0 Then StrPCopy(PParam1, p1);
       If ParamType2 > 0 Then StrPCopy(PParam2, p2);
       If ParamType3 > 0 Then StrPCopy(PParam3, p3);

       {Cursor schlieen }
       SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
       i := SQLExecute(Intern.Stmt[StmtInd1]);
       If i < 0 Then
       begin
          Errcode := i;
          ErrText := 'Fehler beim SQLExecute';
          Exit;
       End;
       {Initialise }
       FilePos := 1;
       FileLength := 0;
      {Lesen n.Datensatz }
       EOF := False;
       BOF := False;
       If i = SQL_SUCCESS Then
       Begin
         MoveNext;
         ExecuteDynaset := True;
       End
       Else
       Begin
         ExecuteDynaset := False;
       End;


end;



procedure XDB_Dynaset.ResetDataChange;
Var p: PChar;
begin
    p := PDataChanged;
    while p < (PDataChanged + FieldCount) do
    begin
       p[0] := #48;
       INC(p);
    end;
    InsertFlag := False;
end;


Function XDB_Dynaset.MoveNext: Boolean;
Var XDB_rc, i: Integer;
Var Puffer:Array[0..255] of Char;
begin
  if not Openmerker then exit;
  if EOF then
  begin
   MoveNext := False;
   exit;
  end;

  if ExtendedScrolling <> 0 then
  begin
     XDB_rc := FileMoveNext;
     if (XDB_rc = SQL_SUCCESS) and (ExtendedScrolling = 1) then
     begin
        i := SQL_SUCCESS;
        XDB_rc := 1;
        While (XDB_rc <> SQL_SUCCESS) and (i = SQL_SUCCESS) Do
        begin
           XDB_rc := SQLFreeStmt(Intern.Stmt[StmtInd2], 0);
           i := SQLExecute(Intern.Stmt[StmtInd2]);
           {Lesen n. Datensatz}
           if i = SQL_SUCCESS then
           begin
              XDB_rc := SQLFetch(Intern.Stmt[StmtInd2]);
              if XDB_rc <> SQL_SUCCESS Then i := FileMoveNext;
           end;
        end;
     end;
  end
  else
  begin
     XDB_rc := SQLFetch(Intern.Stmt[StmtInd1]);
     If (XDB_rc <> SQL_SUCCESS) And (ParamType1 = 0) Then {EOF}
     begin
       if (XDB_rc = SQL_SUCCESS_WITH_INFO) then
       begin
          ErrText := Intern.DescribeError(Intern.Hdbc[StmtInd1], Intern.Stmt[StmtInd1]);
          StrPCopy(Puffer, ErrText);
          Application.MessageBox(Puffer,'Hinweis! Bitte melden',48);
          INC(RecordCount);
       end
       else
       begin
        SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
        SQLFreeStmt(Intern.Stmt[StmtInd1], 2);
        Intern.StmtStatus[StmtInd1] := inactive;
        StmtInd1 := 0;
       end;
     end
     Else
     begin
        INC(RecordCount);
     End;
  end;

  If XDB_rc = SQL_SUCCESS Then
  Begin
     BOF := False;
     EOF := False;
     MoveNext := True;
     ResetDataChange;
 End
  Else
  Begin
     EOF := True;
     MoveNext := False;
  end;

end;




Function XDB_Dynaset.MovePrevious: Boolean;
Var XDB_rc, i: Integer;
begin
  if not Openmerker then exit;
  if BOF or (ExtendedScrolling = 0) or (InsertDynaset) then
  begin
   MovePrevious := False;
   exit;
  end;

  MovePrevious := True;
  BOF := False;

  i := FileMovePrevious;
  If (i = SQL_SUCCESS) And (ExtendedScrolling = 1) Then
  begin
     XDB_rc := 1;
     While (XDB_rc <> SQL_SUCCESS) And (i = SQL_SUCCESS) Do
     begin
         XDB_rc := SQLFreeStmt(Intern.Stmt[StmtInd2], 0);
         i := SQLExecute(Intern.Stmt[StmtInd2]);
         {Lesen n.Datensatz }
         If i = SQL_SUCCESS Then
         begin
            XDB_rc := SQLFetch(Intern.Stmt[StmtInd2]);
            If XDB_rc <> SQL_SUCCESS Then i := FileMovePrevious;
         end;
     end;
  end;

  If (i = SQL_SUCCESS) Or ((ExtendedScrolling = 2) And (XDB_rc = SQL_SUCCESS)) Then
  begin
      BOF := False;
      EOF := False;
      ResetDataChange;
  end
  Else
  begin
      BOF := True;
      MovePrevious := False;
  end;

end;




Function XDB_Dynaset.MoveFirst: Boolean;
Var XDB_rc, i: Integer;
begin
    If (ExtendedScrolling = 0) Or InsertDynaset Then
    begin
        MoveFirst := False;
        Exit;
    end;
    XDB_rc := FileMoveFirst;

    if (XDB_rc = SQL_SUCCESS) and (ExtendedScrolling = 1) then
    begin
        i := SQL_SUCCESS;
        XDB_rc := 1;
        While (XDB_rc <> SQL_SUCCESS) and (i = SQL_SUCCESS) Do
        begin
           XDB_rc := SQLFreeStmt(Intern.Stmt[StmtInd2], 0);
           i := SQLExecute(Intern.Stmt[StmtInd2]);
           {Lesen n. Datensatz}
           if i = SQL_SUCCESS then
           begin
              XDB_rc := SQLFetch(Intern.Stmt[StmtInd2]);
              if XDB_rc <> SQL_SUCCESS Then i := FileMoveNext;
           end;
        end;
    end;


    If XDB_rc = SQL_SUCCESS Then
    begin
       EOF := False;
       BOF := False;
       MoveFirst := True;
       ResetDataChange;
   end
    Else
    begin
       BOF := True;
       MoveFirst := False;
    End;
end;



Function XDB_Dynaset.MoveLast: Boolean;
Var XDB_rc,i: Integer;
begin
    If (ExtendedScrolling = 0) Or InsertDynaset Then
    begin
        MoveLast := False;
        Exit;
    end;
    XDB_rc := FileMoveLast;

    if (XDB_rc = SQL_SUCCESS) and (ExtendedScrolling = 1) then
    begin
        i := SQL_SUCCESS;
        XDB_rc := 1;
        While (XDB_rc <> SQL_SUCCESS) and (i = SQL_SUCCESS) Do
        begin
           XDB_rc := SQLFreeStmt(Intern.Stmt[StmtInd2], 0);
           i := SQLExecute(Intern.Stmt[StmtInd2]);
           {Lesen n. Datensatz}
           if i = SQL_SUCCESS then
           begin
              XDB_rc := SQLFetch(Intern.Stmt[StmtInd2]);
              if XDB_rc <> SQL_SUCCESS Then i := FileMovePrevious;
           end;
        end;
    end;

    If XDB_rc = SQL_SUCCESS Then
    begin
       EOF := False;
       BOF := False;
       MoveLast := True;
       ResetDataChange;
    end
    Else
    begin
       EOF := True;
       MoveLast := False;
    End;


end;




function XDB_Dynaset.FileMoveNext: Integer;
    { Diese Function liest den nchsten Satz eines
      extended Dynasets
      Return 0 wenn ok,  1 wenn EOF}
Var i, XDB_rc: Integer;
begin
    If ((FilePos + KeyMaxLength) >= FileLength) And (StmtInd1 <> 0) Then
    begin
        {Neuen Satz von Datenbank holen }
         XDB_rc := SQLFetch(Intern.Stmt[StmtInd1]);
         If XDB_rc = SQL_SUCCESS Then
         begin
            INC(RecordCount, 1);
            FileMoveNext := FileAddRec;
         end
         Else
         begin
            XDB_rc := SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
            If ParamType1 = 0 Then
            begin
               XDB_rc := SQLFreeStmt(Intern.Stmt[StmtInd1], 2);
               Intern.StmtStatus[StmtInd1] := inactive;
               StmtInd1 := 0;
            End;
            FileMoveNext := 1;
         End;

    end
    Else
    Begin
        {Satz von Temp-File }
        INC(FilePos, KeyMaxLength);
        FileMoveNext := FileGetCurrent;
    End;
end;


function XDB_Dynaset.FileMoveLast: Integer;
   { Diese Function liest den letzten Satz eines
     extended Dynasets
     Return: 0 wenn ok,   1 wenn EOF   }
Var XDB_rc, pm, i: Integer;
    eof_m: Integer;
begin
   eof_m := 0;
   if StmtInd1 <> 0 then
   begin
     While eof_m = 0 Do {Lesen bis EOF}
     Begin
        {Neuen Satz von Datenbank holen }
         XDB_rc := SQLFetch(Intern.Stmt[StmtInd1]);
         If XDB_rc = SQL_SUCCESS Then
         Begin
            INC(RecordCount, 1);
            eof_m := FileAddRec;
         end
         Else
         begin
            XDB_rc := SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
            If ParamType1 = 0 Then
            begin
               XDB_rc := SQLFreeStmt(Intern.Stmt[StmtInd1], 2);
               Intern.StmtStatus[StmtInd1] := inactive;
               StmtInd1 := 0;
            End;
            eof_m := 1;
         End;
     end;
   end;
   FilePos := FileLength - KeyMaxLength + 1;
   FileMoveLast := FileGetCurrent;

end;



function XDB_Dynaset.FileMovePrevious: Integer;
    { Diese Function liest den vorhergehenden Satz eines
      extended Dynasets
      Return 0 wenn ok,  1 wenn EOF}
begin
    DEC(FilePos, KeyMaxLength);
    FileMovePrevious := FileGetCurrent;
end;




function XDB_Dynaset.FileMoveFirst: Integer;
begin
      FilePos := 1;
      FileMoveFirst := FileGetCurrent;
end;



function XDB_Dynaset.FileAddRec: Integer;
Var PBuf: PChar;
  i: Integer;
begin
    i:= 1;
   {Diese Subroutine schreibt einen Satz in die Temporary-Key-File }
    If (FileLength + KeyMaxLength) < CacheBuffer Then
    begin
       PBuf := FileBuffer + FileLength + 1;
       if ExtendedScrolling = 1 then
       begin
          {Kopiere Daten von KeyPuffer}
          StrMove(PBuf, KeyPuffer, KeyMaxLength);
       end
       else
       begin
         {Kopiere Daten von Satzpuffer}
         StrMove(PBuf, PLength, KeyMaxLength);
       end;
       INC(FileLength, KeyMaxLength);
       FilePos := FileLength - KeyMaxLength + 1;
    end
    Else
    begin
       {Datei schreiben }
        If FileHandle = 0 Then
        begin
           GetTempFileName(#0, 'sql', 0, IFile);
           FileHandle := _lcreat(IFile, 0);
           BufferLength := FileLength - 1;
        End;
        if ExtendedScrolling = 1 then
        begin
           {Schreibe KeyValue in File}
           i := _lwrite(FileHandle, KeyPuffer, KeyMaxLength);
        end
        else
        begin
           {Schreibe Satzpuffer in File}
           i := _lwrite(FileHandle, PLength, KeyMaxLength);
        end;
        INC(FileLength, KeyMaxLength);
        FilePos := FileLength - KeyMaxLength + 1;
    End;
    if i = 0 then
    begin
       FileAddRec := 1;
    end
    else
    begin
       FileAddRec := 0;
    end;

end;



function XDB_Dynaset.FileGetCurrent: Integer;
Var m,i: Integer;
    PBuf: PChar;
begin
    If FilePos < 1 Then
    begin
       FilePos := 1;
       FileGetCurrent := 1;
       Exit;
    end;
    If FilePos > (FileLength - KeyMaxLength + 1) Then
    begin
       FilePos := FileLength - KeyMaxLength + 1;
       FileGetCurrent := 1;
       Exit;
    end;
    If (FilePos + KeyMaxLength) <= CacheBuffer Then
    begin
       {Lesen vom Puffer }
        PBuf := FileBuffer + FilePos;
        if ExtendedScrolling = 1 then
        begin {Lesen in KeyValue}
           StrMove(KeyPuffer, PBuf, KeyMaxLength);
        end
        else
        begin {Lesen in Satzpuffer}
           StrMove(PLength, PBuf, KeyMaxLength);
        end;
    end
    Else
    begin
       {Lesen von Datei }
         _llseek(FileHandle, FilePos - BufferLength - 2,0);
         if ExtendedScrolling = 1  then
         begin
            i := _lread(FileHandle, KeyPuffer, KeyMaxLength);
         end
         else
         begin
            i := _lread(FileHandle, PLength, KeyMaxLength);
         end;
         If i < 1 Then
         begin
            FileGetCurrent := 1;
            Exit;
         end;
    End;
    FileGetCurrent := 0;
end;



function XDB_Dynaset.GetSQLLength: Longint;
Var i: Integer; l:longint; lg: Byte;
    pInt: ^Integer;
begin
    l := 54 + Length(TableName);
    lg := MaxFieldLength + 4;
    pint := @PMaxLength[0];
    for i := 0 to FieldCount - 1 do
    begin
        if PDataChanged[i] = #49 then
        begin
           INC(l, pInt^ + lg);
        end;
        INC(pint);
    end;
    GetSQLLength := l;
end;



function XDB_Dynaset.Update: Boolean;
Var
   p: PChar;
   laenge: longint;
   anzahl: longint;
   pLong : ^Longint;
   XDB_rc : Integer;
begin
   Update := False;
   if Not Openmerker then exit;

   If InsertDynaset Then
   Begin
{     If Not XDB_InternInsert; Then
        Update := False;
        Exit;
     End;
}     XDB_rc := 1;
  end
  Else
  Begin
    laenge := GetSQLLength;
    GetMem(p, laenge);
    if GetUpdateSQL(p) then
    Begin
       XDB_rc := Intern.IExecuteSQL(p);
       if XDB_rc > 0 then
       begin
         If (StrLIComp(p, 'INSERT INTO', 11) = 0) and (ExtendedScrolling > 0) Then {Insert-SQL   }
         Begin
             {Neuer Satz in Temporres File speichern}
             if ExtendedScrolling = 1 then StrLCopy(KeyPuffer, PFields[GetFieldNr(ExtendedKeyName)], KeyMaxLength);
             FileAddRec;
         End;
         if TimeStampNr > 0 then {Timestamp-Value setzen}
         begin
             If StrLIComp(p, 'INSERT INTO', 11) <> 0 then
             begin
                pLong := PFields[TimeStampNr];
                INC(pLong^);
             end
             else
             begin
                pLong := PFields[TimeStampNr];
                pLong^ := 1;
             end;
         end;

       end;
    End;
    FreeMem(p, laenge);
  End;

  If XDB_rc < 1 Then
  Begin
    Update := False;
    If XDB_rc = 0 Then
    Begin
       Errcode := -400;
       ErrText := 'Datensatz wurde zwischenzeitlich von einem anderen Programm verndert';
    End
    Else
    begin
       Errcode := XDB_rc;
       ErrText := 'Update/Insert fehlgeschlagen';
    End;
 End
 Else
 Begin
    Update := True;
    ResetDataChange;
    InsertFlag := False;
 End;



end;

procedure XDB_Dynaset.AddNew;
 {Diese Funktion lscht alle Felder im Dynaset und setzt
 'einen Insert-Merker }
Var i : Integer;
    laenge: ^Longint;
begin
    laenge := @PLength[0];
    For i := 1 To FieldCount do
    begin
      laenge^ := 0;
      INC(laenge);
    end;
    ResetDataChange;
    InsertFlag := True;
end;



function XDB_Dynaset.ibECopy(dest: PChar; source: String): PChar;
begin
     strmove(dest, @source[1], ORD(source[0]));
     ibECopy := dest + Length(source);
end;



function XDB_Dynaset.GetUpdateSQL(pSQL: PChar): Boolean;
{ Diese Function analysiert alle Felder und erstellt fr die
  genderten Felder einen SQL-String (Update oder Insert)
  Return: True wenn genderte Felder vorhanden waren
}
Var i: Integer; Outlen: Longint; r: Integer;
    ppSQL: PCHar;
    pLong: ^Longint;
begin

GetUpdateSQL := False;
ppSQL := pSQL;
If InsertFlag Then {Insert Record}
begin
  ppSQL := ibECopy(ppSQL, 'INSERT INTO ' + TableName + ' (');
  {Bilden der Feldliste}
  r := 0;
  for i := 0 to FieldCount -1 do
  begin
    if PDataChanged[i] = '1' then {Spalte wurde gendert }
    begin
      if r <> 0 then ppSQL := ibECopy(ppSQL, ', ');
      r := 1;
      ppSQL := ibECopy(ppSQL, GetFieldName(i));
    end;
  end;
  if r = 1 then GetUpdateSQL := True;

  If TimeStamp <> '' Then  ppSQL := ibECopy(ppSQL, ', ' +
                           Intern.DL + TimeStamp + Intern.DL);

  {Bilden der Werteliste}
  ppSQL := ibECopy(ppSQL,') VALUES (');
  r := 0;
  for i := 0 to FieldCount - 1 Do
  begin
    if PDataChanged[i] = '1' then {Spalte wurde gendert }
    begin
      if r <> 0 then ppSQL := ibECopy(ppSQL, ', ');
      r := 1;
      ppSQL := ibECopy(ppSQL, GetFieldsPNr(i));
    end;
  end;
  If TimeStamp <> '' Then ppSQL := ibECopy(ppSQL, ', 1');

end
else
begin {Update SQL}

  ppSQL := ibECopy(ppSQL, 'UPDATE '+ TableName + ' SET ');
  {Bilden der Feld/Werte-liste}
  r := 0;
  for i := 0 to FieldCount - 1 Do
  begin
    if PDataChanged[i] = '1' then {Spalte wurde gendert }
    begin
      if r <> 0 then ppSQL := ibECopy(ppSQL, ', ');
      r := 1;
      ppSQL := ibECopy(ppSQL, Intern.DL + GetFieldName(i + 1) + Intern.DL + '=' + GetFieldsPNr(i + 1));
   end;
  end;
  if r = 1 then GetUpdateSQL := True;

  {Wenn Timestamp, dann Wert um 1 erhhen}
  If TimeStamp <> '' Then
  begin
     pLong := PFields[TimeStampNr];
     ppSQL := ibECopy(ppSQL, ', ' + Intern.DL + TimeStamp + Intern.DL +
                                     '=' + IntToStr(pLong^ + 1));
  end;

  {Where-Klausel}
  r := 0;
  If ExtendedKeyName <> '' Then
  begin
     ppSQL := ibECopy(ppSQL, ' WHERE ');
     ppSQL := ibECopy(ppSQL, Intern.DL + ExtendedKeyName + Intern.DL);
     ppSQL := ibECopy(ppSQL, '=');
     ppSQL := ibECopy(ppSQL, GetFieldsPNr(GetFieldNr(ExtendedKeyName)));
     r := 1; {Merker, da bereits ein WHERE enthalten ist}
  end;

  {TimeStamp - Wert in Where-Klausel eintragen}
  If TimeStamp <> '' Then
  begin
     if r = 0 then
     begin
        ppSQL := ibECopy(ppSQL, ' WHERE ');
     end
     else
     begin
        ppSQL := ibECopy(ppSQL, ' AND ');
     end;
     ppSQL := ibECopy(ppSQL, Intern.DL + TimeStamp + Intern.DL +
                                     '=' + IntToStr(pLong^));
  end;


end; {InsertFlag }

ppSQL[0]:= #0;

end;



function XDB_Dynaset.GetTypes(Index: String): Byte;
begin
   if Not Openmerker then exit;
   GetTypes := GetTypesNr(GetFieldNr(Index) - 1);
end;

function XDB_Dynaset.GetTypesNr(Index: Byte): Byte;
begin
   if Not Openmerker then exit;
   GetTypesNr := ORD(PTypes[Index]);
end;

function XDB_Dynaset.GetChanged(Index: String): Boolean;
begin
   if Not Openmerker then exit;
end;

procedure XDB_Dynaset.SetChanged(Index: String; AValue: Boolean);
begin
   if Not Openmerker then exit;
end;

function XDB_Dynaset.GetFields(Index: String): String;
begin
   if Not Openmerker then exit;
   GetFields := GetFieldsNr(GetFieldNr(Index) - 1);
end;

function XDB_Dynaset.GetFieldsNr(Index: Byte): String;
Var
    i : Integer;
    laenge: ^Longint;
    pDouble: ^Double;
    pSingle: ^Single;
    pLong: ^Longint;
    pInt: ^Integer;
    pText: PChar;
    e: String[20];
    f1: String[2];
    f2: String[2];
begin
   if Not Openmerker then exit;
   if (Index < 0) or (Index > FieldCount - 1) then exit;
   laenge := @PLength[Index * 4];
   if laenge^ < 1 then  {Null-Value}
   begin
     Case ORD(PTypes[Index]) of
       SQL_FLOAT, SQL_DOUBLE, SQL_REAL, SQL_INTEGER, SQL_SMALLINT: GetFieldsNr := '0';
      Else
       GetFieldsNr := '';
      end;
   end
   else
   begin
     Case ORD(PTypes[Index]) of
       SQL_FLOAT, SQL_DOUBLE: Begin
                                pDouble := PFields[Index+1];
                                Str(pDouble^ : 0 : 4,e);
                                GetFieldsNr := e;
                              end;
       SQL_REAL:              Begin
                                pSingle := PFields[Index+1];
                                Str(pSingle^ : 0 : 2,e);
                                GetFieldsNr := e;
                              End;
       SQL_INTEGER:           Begin
                                pLong := PFields[Index+1];
                                GetFieldsNr := IntToStr(pLong^);
                              End;
       SQL_SMALLINT:          Begin
                                pInt := PFields[Index+1];
                                GetFieldsNr := IntToStr(pInt^);
                              End;
       SQL_DATE, SQL_TIMESTAMP:
                              Begin
                                pINT := PFields[Index+1];
                                e:= IntToStr(pINT^);
                                While Length(e) < 4 Do e := '0' + e;
                                INC(pINT);
                                f1 := IntToStr(pINT^);
                                While Length(f1) < 2 Do f1 := '0' + f1;
                                INC(pINT);
                                f2 := IntToStr(pINT^);
                                While Length(f2) < 2 Do f2 := '0' + f2;
                                GetFieldsNr := f2 + '.' + f1 + '.' + e;
                              End;
      Else
       Begin
         pText := PFields[Index+1];
         i := laenge^ - 1;
         While (pText[i] = #32) and (i > 0) Do DEC(i);
         pText[i + 1] := #0;
         GetFieldsNr := StrPas(pText);
       End;
      end;
   end;

end;



function XDB_Dynaset.GetFieldsPNr(nr: Integer): String;
{Diese Function ermittelt zu einer Feld-Nr. den aktuellen Update/Insert-Wert
 und wird zur Bildung eines SQL-Strings verwendet. }
Var
    i : Integer;
    laenge: ^Longint;
    pDouble: ^Double;
    pSingle: ^Single;
    pLong: ^Longint;
    pInt: ^Integer;
    pText: PChar;
    e: String[20];
    f1: String[2];
    f2: String[2];
begin
   DEC(nr);
   laenge := @PLength[nr * 4];
   if laenge^ < 1 then  {Null-Value}
   begin
     Case ORD(PTypes[nr]) of
       SQL_FLOAT, SQL_DOUBLE, SQL_REAL, SQL_INTEGER, SQL_SMALLINT: GetFieldsPNr := 'NULL';
      Else
       GetFieldsPNr := 'NULL';
      end;
   end
   else
   begin
     Case ORD(PTypes[nr]) of
       SQL_FLOAT, SQL_DOUBLE: Begin
                                pDouble := PFields[nr+1];
                                Str(pDouble^ : 0 : 4,e);
                                GetFieldsPNr := e;
                              end;
       SQL_REAL:              Begin
                                pSingle := PFields[nr+1];
                                Str(pSingle^ : 0 : 2,e);
                                GetFieldsPNr := e;
                              End;
       SQL_INTEGER:           Begin
                                pLong := PFields[nr+1];
                                GetFieldsPNr := IntToStr(pLong^);
                              End;
       SQL_SMALLINT:          Begin
                                pInt := PFields[nr+1];
                                GetFieldsPNr := IntToStr(pInt^);
                              End;
       SQL_DATE, SQL_TIMESTAMP:
                              Begin
                                pINT := PFields[nr+1];
                                e:= IntToStr(pINT^);
                                While Length(e) < 4 Do e := '0' + e;
                                INC(pINT);
                                f1 := IntToStr(pINT^);
                                While Length(f1) < 2 Do f1 := '0' + f1;
                                INC(pINT);
                                f2 := IntToStr(pINT^);
                                While Length(f2) < 2 Do f2 := '0' + f2;
                                GetFieldsPNr := '{d ' + CHR(39) + e + '-' + f1 + '-' + f2 + CHR(39) + '}';
                              End;
      Else
       Begin
         pText := PFields[nr+1];
         GetFieldsPNr := CHR(39) + StrPas(pText) + CHR(39);
       End;
      end;
   end;

end;




Function XDB_Dynaset.GetFieldNr(Index: String): Integer;
Var p:Array[0..40] of Char;
    e,e2: PChar;
    f:String[3];
begin
    strPCopy(p,'!+' + Index);
    e := StrPos(InternFieldNames, p);
    if e = nil then
    begin
       strPCopy(p,'Feldname "' + Index + '" in Tabelle "' + TableName + '" nicht gefunden!');
       Application.MessageBox(p,'Hinweis',48);
       GetFieldNr := 0;
    end
    else
    begin
       e:= e - 3;
       f[0] := #3;
       f[1] := e[0];
       f[2] := e[1];
       f[3] := e[2];
       GetFieldNr := StrToInt(f);
    end;
end;


Function XDB_Dynaset.GetFieldName(Index: Integer): String;
Var p:Array[0..40] of Char;
    e,e2: PChar;
    f:String[3];
begin
    f := IntToStr(Index);
    while Length(f) < 3 do f := '0' + f;

    strPCopy(p, '!' + f + '!+');
    e := StrPos(InternFieldNames, p);
    if e = nil then
    begin
       strPCopy(p,'Feldnr "' + IntToStr(Index) + '" in Tabelle "' + TableName + '" nicht gefunden!');
       Application.MessageBox(p,'Hinweis',48);
       GetFieldName := '';
    end
    else
    begin
       e2 := e + 6;
       e := StrPos(e2, '!');
       if e <> nil then
       begin
          StrLCopy(p, e2, e - e2);
          GetFieldName := StrPas(p);
       end else
       begin
          GetFieldName := '';
       end;
    end;
end;


Function XDB_Dynaset.GetMaxLengthNr(Index: Integer): Longint;
Var pInt: ^Integer;
begin
    pInt := @PMaxLength[0];
    INC(pInt, Index);
    GetMaxLengthNr := pInt^;
end;



procedure XDB_Dynaset.SetFields(Index: String; AValue: String);
begin
   if Not Openmerker then exit;
   SetFieldsNr(GetFieldNr(Index) - 1, AValue);
end;

procedure XDB_Dynaset.SetFieldsNr(Index: Byte; AValue: String);
Var
    nr,i : Integer;
    laenge: ^Longint;
    pDouble: ^Double;
    pSingle: ^Single;
    pLong: ^Longint;
    pInt: ^Integer;
    pText: PChar;
begin
   if Not Openmerker then exit;
   if (Index < 0) or (Index > FieldCount - 1) then exit;
   PDataChanged[Index] := '1';
   laenge := @PLength[Index * 4];
   Case ORD(PTypes[Index]) of
       SQL_FLOAT, SQL_DOUBLE: Begin
                                pDouble := PFields[Index+1];
                                Val(AValue, pDouble^, i);
                                laenge^ := 8;
                              end;
       SQL_REAL:              Begin
                                pSingle := PFields[Index+1];
                                Val(AValue, pSingle^, i);
                                laenge^ := 4;
                              End;
       SQL_INTEGER:           Begin
                                pLong := PFields[Index+1];
                                Val(AValue, pLong^, i);
                                laenge^ := 4;
                              End;
       SQL_SMALLINT:          Begin
                                pInt := PFields[Index+1];
                                Val(AValue, pInt^, i);
                                laenge^ := 2;
                              End;
       SQL_DATE, SQL_TIMESTAMP:
                              Begin
                                pINT := PFields[Index+1];
                                Val(Copy(AValue,7,4), pINT^, i);
                                INC(pINT);
                                Val(Copy(AValue,4,2), pINT^, i);
                                INC(pINT);
                                Val(Copy(AValue,1,2), pINT^, i);
                                laenge^ := 16;
                              End;
      Else
       Begin
         pText := PFields[Index+1];
         StrPCopy(PText, AValue);
         laenge^ := Length(AValue);
       End;
      end;

end;





{*************************  Implementation ODBCHandles  ******************}

function ODBCHandles.IExecuteSQL(sql: PCHar): Longint;
  {Diese Funktion fhrt einen SQL-String aus und gibt die
  Anzahl der genderten Stze zurck }
Var
   NumberOfRecords: Longint;
   StmtInd1: Integer;
   i :Integer;
   XDB_rc : Integer;
   ErrText: String;
   p: Array[0..255] of Char;
   vgl: String[6];
begin
  IExecuteSql := -2;
  If Status <> active Then
  begin
      Application.MessageBox('Datenbank nicht geffnet', 'HINWEIS', 48);
      Exit;
  End;

  {Get a new Statementhandle }
  StmtInd1 := GetNewStmt;
  If StmtInd1 = 0 Then Exit;
  XDB_rc := SQLSetStmtOption(Stmt[StmtInd1], SQL_ASYNC_ENABLE, 1);

  {Sql-Durchfhren }
  i := 2;
  While i = 2 Do
  Begin
     i := SQLExecDirect(Stmt[StmtInd1], sql, StrLen(sql));
     WaitMessage;
     WaitMessage;
     WaitMessage;
     WaitMessage;
  end;
  If i <> SQL_SUCCESS Then
  begin
     ErrText := DescribeError(Hdbc[StmtInd1], Stmt[StmtInd1]);
     XDB_rc := SQLFreeStmt(Stmt[StmtInd1], 0);
     XDB_rc := SQLSetStmtOption(Stmt[StmtInd1], SQL_ASYNC_ENABLE, 0);
     StmtStatus[StmtInd1] := inactive;
     StrPCopy(p, ErrText);
     Application.MessageBox(p,'HINWEIS',48);
     Exit;
  End;

{ Ermitteln wieviele Stze gendert wurden }
  StrMove(@vgl[1], sql, 6);
  vgl[0] := #6;
  vgl := UpperCase(vgl);
  if (vgl = 'UPDATE') or (vgl = 'INSERT') or (vgl = 'DELETE') then
  begin
     XDB_rc := SQLRowCount(Stmt[StmtInd1], NumberOfRecords);
     If XDB_rc = SQL_SUCCESS Then
     begin
        If NumberOfRecords = -1 Then NumberOfRecords := 1;
        IExecuteSql := NumberOfRecords;
     End;
  End
  Else
  Begin
     IExecuteSql := 1;
  End;

  SQLFreeStmt(Stmt[StmtInd1], 0);
  SQLSetStmtOption(Stmt[StmtInd1], SQL_ASYNC_ENABLE, 0);
  StmtStatus[StmtInd1] := inactive;

end;




function ODBCHandles.Attempt(SqlStatus: Integer; ErrorText: String): Boolean;
Var Puffer:Array[0..255] of Char;
begin
      if SqlStatus <> 0 then
      begin
         StrPCopy(Puffer,ErrorText);
         Application.MessageBox(Puffer,'Unexpected ODBC Driver Function failure!',16);
         Attempt := False;
      end
      else
      begin
         Attempt := True;
      end;
end;

function ODBCHandles.DescribeError(hdbc: longint; hstmt: longint): String;
Var XDB_rc: Integer;
Var Native: Longint;
Var Outlen: Integer;
Var SBuffer1: Array[0..16] of Char;
Var SBuffer3: Array[0..255] of Char;
Var ErrT: String;
begin
  FillChar(SBuffer1, 16, #0);
  ErrT := '';
  Repeat
    FillChar(SBuffer3, 255, #0);
    XDB_rc := SQLError(0, hdbc, hstmt, SBuffer1, Native, SBuffer3, 255, Outlen);
    If (XDB_rc = SQL_SUCCESS) Or (XDB_rc = SQL_SUCCESS_WITH_INFO) Then
    begin
        If Outlen = 0 Then
        begin
           ErrT := 'Error --- No Information available';
        end
        Else
        begin
           ErrT := ErrT + StrPas(SBuffer3) + Chr(13) + Chr(10);
        End;
    End;
  Until XDB_rc <> SQL_SUCCESS;

  DescribeError := ErrT;
end;


Function ODBCHandles.GetNewStmt: Integer;
    {Diese Function ermittelt ein freies Statement-Handle
     Wenn die Datenbank nur ein aktives Statement untersttzt
     wird eine weitere Connection geffnet}
Var i, m : Integer;
    cbout: Integer;
    XDB_rc: Integer;
    SServer:Array[0..255] of Char;
    Puffer: Array[0..256] of Char;
    ErrText: String;
begin

    GetNewStmt := 0;
    {Suchen eines ungenutzten Handles}
    For i := 1 To AnzStmt Do
    begin
        If StmtStatus[i] = inactive Then
        begin
           StmtStatus[i] := active;
           GetNewStmt := i;
           Exit;
        End;
    End;

    {Neuvergabe eines Handles }
    m := 0;
    For i := 1 To AnzStmt + 1 Do
    begin
        If StmtStatus[i] = XDB_free Then
        begin
           StmtStatus[i] := active;
           m := i;
           break;
        End;
    End;
    If m = 0 Then Exit;
    If m > AnzStmt Then AnzStmt := m;
    If MaxAnzStmt < AnzStmt Then
    begin
       {Neue Connection erffnen
        Allocate a connection handle }
       if not Attempt(SQLAllocConnect(HENV, Hdbc[m]), 'Cannot allocate connection handle') then
       begin
          StmtStatus[m] := active;
          Exit;
       End;
       { Make the connection }
       StrPCopy(Puffer, Server);
       XDB_rc := SQLDriverConnect(Hdbc[m], GetFocus,
          Puffer, Length(Server), SServer, 255, cbout, 1);
       If XDB_rc = SQL_ERROR Then
       begin
          StmtStatus[m] := XDB_free;
          ErrText := DescribeError(Hdbc[m], 0);
          StrpCopy(Puffer,ErrText);
          Application.MessageBox(Puffer,'Fehler',48);
          SQLFreeConnect(Hdbc[m]);
          Exit;
       End;
    end
    Else
    begin
       {Gleiche Connection }
       Hdbc[m] := Hdbc[1];
    end;

  { Allocate a statement handle}
  if not Attempt(SQLAllocStmt(Hdbc[m], Stmt[m]), 'Cannot allocate statment handle') then
  begin
    If MaxAnzStmt < AnzStmt Then
    begin
       SQLDisconnect(Hdbc[m]);
       SQLFreeConnect(Hdbc[m]);
    End;
    StmtStatus[m] := XDB_free;
    Exit;
  End;
  StmtStatus[m] := active;
  GetNewStmt := m;

end;




{*********************  Implementation XDB_Database ************************* }

constructor XDB_Database.OpenDatabase(ConnectString: String; Opt: Integer);
   {opt: 0=Read and Write 1=ReadOnly}
Var XDB_rc, cbout: Integer;
Var SServer:Array[0..255] of Char;
Var Puffer:Array[0..255] of Char;
Var i, infovalue: Integer;
begin
   inherited Create;
   Intern := ODBCHandles.Create;

   If Intern.Status = active then
   begin
      Application.MessageBox('Datenbank bereits geffnet','HINWEIS',48);
      exit;
   end;

   {Allociere EnvHandle}
   if Not Attempt(SQLAllocEnv(Intern.HENV), 'Cannot allocate environment handle') then exit;

   {Allociere ConnectHandle}
   if Not Attempt(SQLAllocConnect(Intern.HENV, Intern.Hdbc[1]), 'Cannot allocate Connection-Handle') then
   begin
      Attempt(SQLFreeEnv(Intern.HENV), 'Cannot Free Environment-Handle');
      Intern.Status := XDB_free;
      exit;
   end;

   {Make the connection}
  StrPCopy(Puffer, ConnectString);
  XDB_rc := SQLDriverConnect(Intern.Hdbc[1], GetFocus,
            Puffer, Length(ConnectString), SServer, 255, cbout, 1);
  If (XDB_rc = SQL_ERROR) And (ConnectString <> '') Then {erneuter Versuch ohne Connectstring}
  begin
     ConnectString := '';
     StrPCopy(Puffer, ConnectString);
     XDB_rc := SQLDriverConnect(Intern.Hdbc[1], GetFocus,
     Puffer, Length(ConnectString), SServer, 255, cbout, 1)
  end;

  If XDB_rc = SQL_ERROR then
  begin
     ErrCode := XDB_rc;
     ErrText := Intern.DescribeError(Intern.Hdbc[1], 0);
     StrpCopy(Puffer,ErrText);
     Application.MessageBox(Puffer,'HINWEIS',48);
     Attempt(SQLFreeConnect(Intern.Hdbc[1]), 'Cannot Free Connection-Handle');
     Attempt(SQLFreeEnv(Intern.HENV), 'Cannot Free Environment-Handle');
     Intern.Status := XDB_free;
     exit;
  end
  else
  begin
    if XDB_rc = SQL_NO_DATA_FOUND then
    begin
     ErrText := 'Keine Verbindung';
     StrPCopy(Puffer, ConnectString);
     Application.MessageBox(Puffer,'HINWEIS',48);
     Attempt(SQLDisconnect(Intern.Hdbc[1]), 'Cannot Disconnect');
     Attempt(SQLFreeConnect(Intern.Hdbc[1]), 'Cannot Free Connection-Handle');
     Attempt(SQLFreeEnv(Intern.HENV), 'Cannot Free Environment-Handle');
     ErrCode := XDB_rc;
     Intern.Status := XDB_free;
     exit;
    end;
  end;

    { Allocate a statement handle }
  if not Attempt(SQLAllocStmt(Intern.Hdbc[1], Intern.Stmt[1]), 'Cannot allocate statment handle') then
  begin
    SQLDisconnect(Intern.Hdbc[1]);
    SQLFreeConnect(Intern.Hdbc[1]);
    SQLFreeEnv(Intern.HENV);
    Intern.Status := XDB_free;
    Exit;
  End;


  {Connection established }
  SServer[cbout] := #0;
  Intern.Server := StrPas(SServer);
  {MsgBox Datab.Server, 48, "Connect" }
  Intern.Status := active;
  Intern.AnzStmt := 1;
  Intern.StmtStatus[1] := inactive;
  i := Pos(';', Intern.Server);
  If (i > cbout) Or (i = 0) Then i := cbout + 1;
  If (i < 4) Then
    ConnectionString := Intern.Server
  Else
    ConnectionString := Copy(Intern.Server, 1, i - 1);

  If opt = 1 Then
     ReadOnly := True
  Else
     ReadOnly := False;


  {Get the Count of the maximal active statements}
  XDB_rc := SQLGetInfo(Intern.Hdbc[1], SQL_ACTIVE_STATEMENTS, infovalue, 2, cbout);
  If XDB_rc = SQL_ERROR Then
  begin
     Intern.MaxAnzStmt := 10;
  end
  Else
  begin
   If infovalue = 0 Then
   begin
      Intern.MaxAnzStmt := 9999;
   end
   Else
   begin
      Intern.MaxAnzStmt := infovalue;
   End;
  End;

  {Get the Delimiter for Identifiers }
  Intern.DL := '';
  XDB_rc := SQLGetInfoStr(Intern.Hdbc[1], SQL_IDENTIFIER_QUOTE_CHAR, Puffer, 255, cbout);
  If (XDB_rc <> SQL_ERROR) And (cbout > 0) Then
  begin
     Puffer[cbout] := #0;
     Intern.DL := StrPas(Puffer);
  end;
  DL := Intern.DL;

  {Ermitteln des Datenbank-Owner's }
  Intern.Owner := GetOwner('');
  If Intern.Owner <> '' Then Intern.Owner := Intern.DL + Intern.Owner + Intern.DL + '.';
  Owner := Intern.Owner;

  {Get the DBMS-Name  }
  Intern.DBMS_Name := '';
  XDB_rc := SQLGetInfoStr(Intern.Hdbc[1], SQL_DBMS_NAME, Puffer, 255, cbout);
  If (XDB_rc <> SQL_ERROR) And (cbout > 0) Then
  begin
     Puffer[cbout] := #0;
     Intern.DBMS_Name := StrPas(Puffer);
  end;
  DBMS_Name := Intern.DBMS_Name;

end;


destructor XDB_Database.Close;
Var i, XDB_rc: integer;
begin
  If Intern.Status = XDB_free then
  begin
     Application.MessageBox('Datenbank nicht geffnet','HINWEIS',48);
  end
  else
  begin
   if Intern.AnzDynasets > 0 then
      Application.MessageBox('Nicht alle Dynasets wurden korrekt geschlossen!','HINWEIS',48);

   {Alle Statements und Connections schlieen}
   For i := 1 To Intern.AnzStmt do
   begin
      If Intern.StmtStatus[i] <> XDB_free Then
      begin
         {Statement freigeben}
         SQLFreeStmt(Intern.Stmt[i], 1);
         Intern.StmtStatus[i] := XDB_free;
         If (Intern.MaxAnzStmt < 2) Or (i = Intern.AnzStmt) Then {Connection schlieen}
         begin
            SQLDisconnect(Intern.Hdbc[i]);
            SQLFreeConnect(Intern.Hdbc[i]);
         end;
      end;
   end;
  end;
   Intern.Status := XDB_free;
   Intern.AnzStmt := 0;

   {Environment freigeben}
   if Not Attempt(SQLFreeEnv(Intern.HENV), 'Cannot Free Environment-Handle') then exit;

   intern.free;
   inherited Destroy;

end;


function XDB_Database.Attempt(SqlStatus: Integer; ErrorText: String): Boolean;
Var Puffer:Array[0..255] of Char;
begin
      if SqlStatus <> 0 then
      begin
         StrPCopy(Puffer,ErrorText);
         Application.MessageBox(Puffer,'Unexpected ODBC Driver Function failure!',16);
         Attempt := False;
         ErrText := ErrorText;
         ErrCode := SqlStatus;
      end
      else
      begin
         ErrText := '';
         ErrCode := 0;
         Attempt := True;
      end;
end;


function XDB_Database.CreateDynaset(SQL: PChar; Opt: Integer; PrimaryKey: String;
                                    ScrollMode: Integer; TimeStamp: String): XDB_Dynaset;
begin
    CreateDynaset := XDB_Dynaset.Create(0, 0, 0, Intern, SQL, Opt, PrimaryKey, ScrollMode, TimeStamp);
end;



function XDB_Database.PrepareDynaset(p1: Byte; p2: Byte; p3: Byte; SQL: PChar; Opt: Integer;
                                    PrimaryKey: String; ScrollMode: Integer; TimeStamp:
                                     String): XDB_Dynaset;
begin

    PrepareDynaset := XDB_Dynaset.Create(p1, p2, p3, Intern, SQL, Opt, PrimaryKey, ScrollMode, TimeStamp);
end;





Function XDB_Database.GetOwner(TableName: String): String;
Var StmtInd1: Integer;
    i, NumCols, XDB_rc: Integer;
    LongOutLen: Longint;
    Puffer1: Array[0..255] of Char;
    Puffer2: Array[0..255] of Char;
    Puffer3: Array[0..255] of Char;
begin
  GetOwner := '';
  {Get a new Statementhandle }
  StmtInd1 := Intern.GetNewStmt;
  If StmtInd1 = 0 Then Exit;

  If TableName = '' Then TableName := '%';
  { Lesen der Tabellen }
  StrPCopy(Puffer1,TableName);
  StrPCopy(Puffer2,'''TABLE''');
  XDB_rc := SQLTables(Intern.Stmt[StmtInd1], 0, 0, 0, 0, Puffer1,
    StrLen(Puffer1), Puffer2, StrLen(Puffer2));
  If XDB_rc <> SQL_SUCCESS Then
  begin
     ErrText := Intern.DescribeError(Intern.Hdbc[StmtInd1], Intern.Stmt[StmtInd1]);
     SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
     Intern.StmtStatus[StmtInd1] := inactive;
     StrpCopy(Puffer1,ErrText);
     Application.MessageBox(Puffer1,'Fehler',48);
     Exit;
  End;

  XDB_rc := SQLNumResultCols(Intern.Stmt[StmtInd1], NumCols);
  If (XDB_rc <> SQL_SUCCESS) Or (NumCols = 0) Then
  begin
     ErrText := Intern.DescribeError(Intern.Hdbc[StmtInd1], Intern.Stmt[StmtInd1]);
     SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
     Intern.StmtStatus[StmtInd1] := inactive;
     StrpCopy(Puffer1,ErrText);
     Application.MessageBox(Puffer1,'Fehler',48);
     Exit;
  End;

  {Lesen Datensatz }
  XDB_rc := SQLFetch(Intern.Stmt[StmtInd1]);
  If XDB_rc = SQL_SUCCESS Then
  begin
     {Lesen Spalte Table-Owner und Name }
     Attempt(SQLGetData(Intern.Stmt[StmtInd1], 2, 1, Puffer1, 255,
      LongOutLen), 'Call to SQLGetData Failed');
     If LongOutLen <> -1 Then
     begin
        Puffer1[LongOutLen] := #0;
        GetOwner := StrPas(Puffer1);
     end;
  End;

  SQLFreeStmt(Intern.Stmt[StmtInd1], 0);
  Intern.StmtStatus[StmtInd1] := inactive;


end;


end.
