unit Dbprintd;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, Gauges, ExtCtrls, Messages, DBPrintF, DBPrintT,
  Printers, DB, SysUtils;

const
  WM_StartPrint=WM_User+1000;

type
  TNotifyDrawDataEvent=procedure(Sender:TObject;Field:TField;var PrintValue:String) of object;

  TPrintingDialog = class(TForm)
    AbortButton: TBitBtn;
    Bevel1: TBevel;
    PrintingLabel: TLabel;
    OnLabel: TLabel;
    PrintTitleLabel: TLabel;
    PrinterLabel: TLabel;
    PrintingGauge: TGauge;
    procedure FormShow(Sender: TObject);
    procedure AbortButtonClick(Sender: TObject);
  private
    CopyCount:Integer;
    PrintingStatus:Byte;
    PageYPos:Integer;
    CharWidth:Real;
    PageNo:Integer;
    RowStepCount:Integer;
    EndOfPage:Boolean;
    BottomMargin:Integer;
    procedure SetPrinterFont(AFont:TFont);
    procedure WMStartPrint(var Msg:TMessage); message WM_StartPrint;
    procedure StartPrint;
    procedure PrintTitle;
    procedure ProcessPrint;
    procedure TotalsPrint;
    procedure AveragePrint;
    procedure EndPrint;
    procedure AbortPrint;
    procedure DoPrint;
  public
    Copies:Integer;
    FieldSpesifications:TFieldSpesifications;
    Translation:TTranslation;
    FOnDrawData:TNotifyDrawDataEvent;
    procedure SetTitle(ATitle:String);
  end;

implementation

{$R *.DFM}

procedure TPrintingDialog.WMStartPrint(var Msg:TMessage);

begin
  DoPrint;
end;

procedure TPrintingDialog.SetTitle(ATitle:String);

begin
  PrinterLabel.Caption:=ATitle;
end;

procedure TPrintingDialog.SetPrinterFont(AFont:TFont);

var DPI:Integer;

begin
  Printer.Canvas.Font:=AFont;
  DPI := GetDeviceCaps(Printer.Handle, LOGPIXELSX);
  Printer.Canvas.Font.PixelsPerInch:=DPI;
end;

procedure TPrintingDialog.FormShow(Sender: TObject);

var i:integer;

begin
  CopyCount:=0;
  if Copies<=0 then Copies:=1;
  FieldSpesifications.SetDataSource(FieldSpesifications.FDataSource);
  PrintingGauge.MaxValue:=FieldSpesifications.FDataSource.DataSet.RecordCount*Copies;
  PrintingGauge.Progress:=0;
  Caption:=Translation.GetText(13);
  PrintingLabel.Caption:=Translation.GetText(14);
  OnLabel.Caption:=Translation.GetText(15);
  AbortButton.Caption:=Translation.GetText(18);
  PrinterLabel.Caption:=Printer.Printers[Printer.Printerindex];
  PrintTitleLabel.Caption:=FieldSpesifications.FPrintTitle;
  PrintingStatus:=0;
  Printer.BeginDoc;
  PostMessage(Handle,wm_StartPrint,0,0);
end;

procedure TPrintingDialog.StartPrint;

var i:integer;
    TotalSize:Integer;
    xPos:Integer;

begin
  Inc(CopyCount);
  RowStepCount:=0;
  PageYPos:=0;
  PageNo:=1;
  PrintingStatus:=1;
  EndOfPage:=True;
  Printer.Title:=FieldSpesifications.FPrintTitle;
  TotalSize:=0;
  CharWidth:=0;
  FieldSpesifications.FDataSource.DataSet.First;
  SetPrinterFont(FieldSpesifications.FDataListFont);
  BottomMargin:=Printer.Canvas.TextHeight('ABC')*3;
  SetPrinterFont(FieldSpesifications.FDataTitleFont);
  if FieldSpesifications.FPageNumbering then
    BottomMargin:=BottomMargin+Printer.Canvas.TextHeight('ABC');
  BottomMargin:=Printer.PageHeight-BottomMargin;
  with FieldSpesifications do begin
    i:=0;
    while FieldSpesification[i]<>NIL do begin
      if FieldSpesification[i].PrintField then TotalSize:=TotalSize+FieldSpesification[i].FieldSize;
      FieldSpesification[i].FieldTotals:=0;
      inc(i);
    end;
    if TotalSize>0 then CharWidth:=Printer.PageWidth/TotalSize;
    i:=0;
    xPos:=round(CharWidth/2);
    while FieldSpesification[i]<>NIL do begin
      if FieldSpesification[i].PrintField then begin
        FieldSpesification[i].PrintPos:=xPos;
        xPos:=xPos+Round(CharWidth*FieldSpesification[i].FieldSize);
      end;
      inc(i);
    end;
  end;
  SetPrinterFont(FieldSpesifications.FOutputHeadingFont);
  Printer.Canvas.TextOut(0,PageYPos,FieldSpesifications.FOutputHeading);
  PageYPos:=PageYPos+Round(Printer.Canvas.TextHeight(FieldSpesifications.FOutputHeading)*1.5);
  SetPrinterFont(FieldSpesifications.FOutputInfoFont);
  if FieldSpesifications.FOutputInfo.Count>0 then for i:=0 to FieldSpesifications.FOutputInfo.Count-1 do begin
    Printer.Canvas.TextOut(0,PageYPos,FieldSpesifications.FOutputInfo.Strings[i]);
    PageYPos:=PageYPos+Printer.Canvas.TextHeight('ABC');
  end;
  PageYPos:=PageYPos+Printer.Canvas.TextHeight('ABC');
end;

procedure TPrintingDialog.PrintTitle;

var i:integer;
    Rect:TRect;
    s:string;

begin
  With FieldSpesifications do begin
    {Printing field title}
    SetPrinterFont(FDataTitleFont);
    if FColLines then Inc(PageYPos,3);
    i:=0;
    while FieldSpesification[i]<>NIL do begin
      if FieldSpesification[i].PrintField then begin
        Rect.Top:=PageYPos;Rect.Left:=FieldSpesification[i].PrintPos;
        Rect.Bottom:=Rect.Top+Printer.Canvas.TextHeight('ABC');
        Rect.Right:=Rect.Left+Round((FieldSpesification[i].FieldSize-1)*CharWidth);
        Printer.Canvas.TextRect(Rect,Rect.Left,Rect.Top,FieldSpesification[i].FieldTitle);
        if FColLines then begin
          Printer.Canvas.Pen.Width:=2;
          Printer.Canvas.MoveTo(round(Rect.Right+CharWidth/2),PageYPos-3);
          Printer.Canvas.LineTo(round(Rect.Right+CharWidth/2),
                                PageYPos+Printer.Canvas.TextHeight('ABC'));
        end;
      end;
      inc(i);
    end;
    PageYPos:=PageYPos+Printer.Canvas.TextHeight('ABC');
    if FColLines then begin
      Printer.Canvas.Pen.Width:=3;
      Printer.Canvas.MoveTo(0,PageYPos);
      Printer.Canvas.LineTo(0,PageYPos-Printer.Canvas.TextHeight('ABC')-3);
      Printer.Canvas.LineTo(Printer.PageWidth-1,PageYPos-Printer.Canvas.TextHeight('ABC')-3);
      Printer.Canvas.LineTo(Printer.PageWidth-1,PageYPos);
    end;
    Printer.Canvas.Pen.Width:=3;
    Printer.Canvas.MoveTo(0,PageYPos);
    Printer.Canvas.LineTo(Printer.PageWidth,PageYPos);
    Inc(PageYPos,3);
    EndOfPage:=False;
  end;
end;

procedure TPrintingDialog.ProcessPrint;

var i:integer;
    Rect:TRect;
    s:string;
    XPos:Integer;

begin
  if EndOfPage then PrintTitle;
  {Printing field data}
  With FieldSpesifications do begin
    PrintingGauge.Progress:=PrintingGauge.Progress+1;
    SetPrinterFont(FDataListFont);
    i:=0;
    while FieldSpesification[i]<>NIL do begin
      if FieldSpesification[i].PrintField then begin
        Rect.Top:=PageYPos;Rect.Left:=FieldSpesification[i].PrintPos;
        Rect.Bottom:=Rect.Top+Printer.Canvas.TextHeight('ABC');
        Rect.Right:=Rect.Left+Round((FieldSpesification[i].FieldSize-1)*CharWidth);

        Case FDataSource.DataSet.Fields[i].DataType of
          ftString   :s:=FDataSource.Dataset.Fields[i].AsString;
          ftSmallInt :s:=FDataSource.Dataset.Fields[i].AsString;
          ftInteger  :s:=FDataSource.Dataset.Fields[i].AsString;
          ftWord     :s:=FDataSource.Dataset.Fields[i].AsString;
          ftBoolean  :if FDataSource.DataSet.Fields[i].AsBoolean then
                         s:=Translation.GetText(19) else s:=Translation.GetText(20);
          ftFloat    :s:=FloatToStrF(FDataSource.DataSet.Fields[i].AsFloat,ffNumber,18,FieldSpesification[i].FieldDecimals);
          ftCurrency :s:=FloatToStrF(FDataSource.DataSet.Fields[i].AsFloat,ffCurrency,18,FieldSpesification[i].FieldDecimals);
          ftDate     :s:=FDataSource.Dataset.Fields[i].AsString;
          ftTime     :s:=FDataSource.Dataset.Fields[i].AsString;
          ftDateTime :s:=FDataSource.Dataset.Fields[i].AsString;
        end;
        if Assigned(FOnDrawData) then begin
          FOnDrawData(Self,FDataSource.Dataset.Fields[i],s);
        end;
        Case FieldSpesification[i].FieldAlignment of
          0:XPos:=Rect.Left;
          1:XPos:=Round(Rect.Left+(Rect.Right-Rect.Left)/2-Printer.Canvas.TextWidth(s)/2);
          2:XPos:=Rect.Right-Printer.Canvas.TextWidth(s);
        end;
        Printer.Canvas.TextRect(Rect,XPos,Rect.Top,s);
        if FColLines then begin
          Printer.Canvas.Pen.Width:=2;
          Printer.Canvas.MoveTo(round(Rect.Right+CharWidth/2),PageYPos-3);
          Printer.Canvas.LineTo(round(Rect.Right+CharWidth/2),
                                PageYPos+Printer.Canvas.TextHeight('ABC'));
        end;
        if FieldSpesification[i].PrintTotals then
          FieldSpesification[i].FieldTotals:=FieldSpesification[i].FieldTotals+FDataSource.Dataset.Fields[i].AsFloat;
      end;
      inc(i);
    end;
    if FColLines then begin
      Printer.Canvas.Pen.Width:=3;
      Printer.Canvas.MoveTo(0,PageYPos-3);
      Printer.Canvas.LineTo(0,PageYPos+Printer.Canvas.TextHeight('ABC'));
      Printer.Canvas.MoveTo(Printer.PageWidth-1,PageYPos-3);
      Printer.Canvas.LineTo(Printer.PageWidth-1,PageYPos+Printer.Canvas.TextHeight('ABC'));
    end;
    PageYPos:=PageYPos+Printer.Canvas.TextHeight('ABC');

    if PageYPos>=BottomMargin then EndOfPage:=True;

    FDataSource.DataSet.Next;

    if FRowLines and (FRowLineStep>0) then begin
      Inc(RowStepCount);
      if (RowStepCount=FRowLineStep) or (FDataSource.DataSet.EOF) or EndOfPage then begin
        RowStepCount:=0;
        Printer.Canvas.Pen.Width:=2;
        Printer.Canvas.MoveTo(0,PageYPos);
        Printer.Canvas.LineTo(Printer.PageWidth,PageYPos);
        Inc(PageYPos,2);
      end;
    end;

    if EndOfPage or FDataSource.DataSet.EOF then begin
      if FPageNumbering then begin
        s:='- '+IntToStr(PageNo)+' -';
        SetPrinterFont(FDataTitleFont);
        Printer.Canvas.TextOut(Printer.PageWidth div 2-
                               Printer.Canvas.TextWidth(s) div 2,
                               Printer.PageHeight-
                               Printer.Canvas.TextHeight('ABC'),
                               s);
      end;
      if not FDataSource.DataSet.EOF then begin
        PageYPos:=0;
        Inc(PageNo);
        Printer.NewPage;
      end;
    end;
    if FDataSource.DataSet.EOF then PrintingStatus:=2;
  end;
end;

procedure TPrintingDialog.TotalsPrint;

var TxtHeight:Integer;
    i:integer;
    s:string;
    Decimals:Integer;
    XPos:Integer;
    Rect:TRect;

begin
  if FieldSpesifications.FPrintTotals then with FieldSpesifications do begin
    SetPrinterFont(FDataTitleFont);
    TxtHeight:=Printer.Canvas.TextHeight('ABC')*3;
    SetPrinterFont(FDataListFont);
    TxtHeight:=TxtHeight+Printer.Canvas.TextHeight('ABC')+9;
    if PageYPos+TxtHeight>=BottomMargin then begin
      PageYPos:=0;
      Inc(PageNO);
      Printer.NewPage;
      EndOfPage:=True;
    end
    else begin
      SetPrinterFont(FDataTitleFont);
      PageYPos:=PageYPos+Printer.Canvas.TextHeight('ABC');
    end;
    SetPrinterFont(FDataTitleFont);
    Printer.Canvas.Pen.Width:=3;
    Printer.Canvas.MoveTo(0,PageYPos+3+Printer.Canvas.TextHeight('ABC'));
    Printer.Canvas.LineTo(0,PageYPos);
    Printer.Canvas.LineTo(Printer.PageWidth-2,PageYPos);
    Printer.Canvas.LineTo(Printer.PageWidth-2,PageYPos+3+Printer.Canvas.TextHeight('ABC'));
    Printer.Canvas.LineTo(0,PageYPos+3+Printer.Canvas.TextHeight('ABC'));
    Inc(PageYPos,3);
    Printer.Canvas.TextOut(Round(Printer.PageWidth/2-Printer.Canvas.TextWidth(Translation.GetText(5))/2),
                           PageYPos,Translation.GetText(5));
    Inc(PageYPos,Printer.Canvas.TextHeight('ABC')+3);
    PrintTitle;
    SetPrinterFont(FDataListFont);
    i:=0;
    while FieldSpesification[i]<>NIL do with FieldSpesification[i] do begin
      Rect.Top:=PageYPos;Rect.Left:=PrintPos;
      Rect.Bottom:=Rect.Top+Printer.Canvas.TextHeight('ABC');
      Rect.Right:=Rect.Left+Round((FieldSize-1)*CharWidth);
      if PrintField and PrintTotals then begin

        Case FDataSource.DataSet.Fields[i].DataType of
          ftSmallInt :s:=FloatToStrF(FieldTotals,ffNumber,18,0);
          ftInteger  :s:=FloatToStrF(FieldTotals,ffNumber,18,0);
          ftWord     :s:=FloatToStrF(FieldTotals,ffNumber,18,0);
          ftFloat    :s:=FloatToStrF(FieldTotals,ffNumber,18,FieldDecimals);
          ftCurrency :s:=FloatToStrF(FieldTotals,ffCurrency,18,FieldDecimals);
          ftDate     :s:=DateToStr(FieldTotals);
          ftTime     :s:=TimeToStr(FieldTotals);
          ftDateTime :s:=DateTimeToStr(FieldTotals);
        end;

        Case FieldAlignment of
          0:XPos:=Rect.Left;
          1:XPos:=Round(Rect.Left+(Rect.Right-Rect.Left)/2-Printer.Canvas.TextWidth(s)/2);
          2:XPos:=Rect.Right-Printer.Canvas.TextWidth(s);
        end;
        Printer.Canvas.TextRect(Rect,XPos,Rect.Top,s);
      end;
      if PrintField and FColLines then begin
        Printer.Canvas.Pen.Width:=2;
        Printer.Canvas.MoveTo(round(Rect.Right+CharWidth/2),PageYPos-3);
        Printer.Canvas.LineTo(round(Rect.Right+CharWidth/2),
                              PageYPos+Printer.Canvas.TextHeight('ABC'));
      end;
      inc(i);
    end;
    if FColLines then begin
      Printer.Canvas.Pen.Width:=3;
      Printer.Canvas.MoveTo(0,PageYPos-3);
      Printer.Canvas.LineTo(0,PageYPos+Printer.Canvas.TextHeight('ABC'));
      Printer.Canvas.MoveTo(Printer.PageWidth-1,PageYPos-3);
      Printer.Canvas.LineTo(Printer.PageWidth-1,PageYPos+Printer.Canvas.TextHeight('ABC'));
    end;
    PageYPos:=PageYPos+Printer.Canvas.TextHeight('ABC');
    if FRowLines then begin
      Printer.Canvas.Pen.Width:=2;
      Printer.Canvas.MoveTo(0,PageYPos);
      Printer.Canvas.LineTo(Printer.PageWidth,PageYPos);
      Inc(PageYPos,2);
    end;
  end;
  PrintingStatus:=3;
end;

procedure TPrintingDialog.AveragePrint;

var TxtHeight:Integer;
    i:integer;
    s:string;
    Decimals:Integer;
    XPos:Integer;
    Rect:TRect;

begin
  if FieldSpesifications.FPrintAverage then with FieldSpesifications do begin
    SetPrinterFont(FDataTitleFont);
    TxtHeight:=Printer.Canvas.TextHeight('ABC')*3;
    SetPrinterFont(FDataListFont);
    TxtHeight:=TxtHeight+Printer.Canvas.TextHeight('ABC')+9;
    if PageYPos+TxtHeight>=BottomMargin then begin
      PageYPos:=0;
      Inc(PageNO);
      Printer.NewPage;
      EndOfPage:=True;
    end
    else begin
      SetPrinterFont(FDataTitleFont);
      PageYPos:=PageYPos+Printer.Canvas.TextHeight('ABC');
    end;
    SetPrinterFont(FDataTitleFont);
    Printer.Canvas.Pen.Width:=3;
    Printer.Canvas.MoveTo(0,PageYPos+3+Printer.Canvas.TextHeight('ABC'));
    Printer.Canvas.LineTo(0,PageYPos);
    Printer.Canvas.LineTo(Printer.PageWidth-2,PageYPos);
    Printer.Canvas.LineTo(Printer.PageWidth-2,PageYPos+3+Printer.Canvas.TextHeight('ABC'));
    Printer.Canvas.LineTo(0,PageYPos+3+Printer.Canvas.TextHeight('ABC'));
    Inc(PageYPos,3);
    Printer.Canvas.TextOut(Round(Printer.PageWidth/2-Printer.Canvas.TextWidth(Translation.GetText(6))/2),
                           PageYPos,Translation.GetText(6));
    Inc(PageYPos,Printer.Canvas.TextHeight('ABC')+3);
    PrintTitle;
    SetPrinterFont(FDataListFont);
    i:=0;
    while FieldSpesification[i]<>NIL do with FieldSpesification[i] do begin
      FieldTotals:=FieldTotals/FDataSource.DataSet.RecordCount;
      Rect.Top:=PageYPos;Rect.Left:=PrintPos;
      Rect.Bottom:=Rect.Top+Printer.Canvas.TextHeight('ABC');
      Rect.Right:=Rect.Left+Round((FieldSize-1)*CharWidth);
      if PrintField and PrintAverage then begin

        Case FDataSource.DataSet.Fields[i].DataType of
          ftSmallInt :s:=FloatToStrF(FieldTotals,ffNumber,18,FieldDecimals);
          ftInteger  :s:=FloatToStrF(FieldTotals,ffNumber,18,FieldDecimals);
          ftWord     :s:=FloatToStrF(FieldTotals,ffNumber,18,FieldDecimals);
          ftFloat    :s:=FloatToStrF(FieldTotals,ffNumber,18,FieldDecimals);
          ftCurrency :s:=FloatToStrF(FieldTotals,ffCurrency,18,FieldDecimals);
          ftDate     :s:=DateToStr(FieldTotals);
          ftTime     :s:=TimeToStr(FieldTotals);
          ftDateTime :s:=DateTimeToStr(FieldTotals);
        end;

        Case FieldAlignment of
          0:XPos:=Rect.Left;
          1:XPos:=Round(Rect.Left+(Rect.Right-Rect.Left)/2-Printer.Canvas.TextWidth(s)/2);
          2:XPos:=Rect.Right-Printer.Canvas.TextWidth(s);
        end;
        Printer.Canvas.TextRect(Rect,XPos,Rect.Top,s);
      end;
      if PrintField and FColLines then begin
        Printer.Canvas.Pen.Width:=2;
        Printer.Canvas.MoveTo(round(Rect.Right+CharWidth/2),PageYPos-3);
        Printer.Canvas.LineTo(round(Rect.Right+CharWidth/2),
                              PageYPos+Printer.Canvas.TextHeight('ABC'));
      end;
      inc(i);
    end;
    if FColLines then begin
      Printer.Canvas.Pen.Width:=3;
      Printer.Canvas.MoveTo(0,PageYPos-3);
      Printer.Canvas.LineTo(0,PageYPos+Printer.Canvas.TextHeight('ABC'));
      Printer.Canvas.MoveTo(Printer.PageWidth-1,PageYPos-3);
      Printer.Canvas.LineTo(Printer.PageWidth-1,PageYPos+Printer.Canvas.TextHeight('ABC'));
    end;
    PageYPos:=PageYPos+Printer.Canvas.TextHeight('ABC');
    if FRowLines then begin
      Printer.Canvas.Pen.Width:=2;
      Printer.Canvas.MoveTo(0,PageYPos);
      Printer.Canvas.LineTo(Printer.PageWidth,PageYPos);
      Inc(PageYPos,2);
    end;
    if FPageNumbering and EndOfPage then begin
      s:='- '+IntToStr(PageNo)+' -';
      SetPrinterFont(FDataTitleFont);
      Printer.Canvas.TextOut(Printer.PageWidth div 2-
                             Printer.Canvas.TextWidth(s) div 2,
                             Printer.PageHeight-
                             Printer.Canvas.TextHeight('ABC'),
                             s);
    end;

  end;
  PrintingStatus:=4;
end;

procedure TPrintingDialog.EndPrint;

begin
  if CopyCount<Copies then begin
    Printer.NewPage;
    PrintingStatus:=0;
  end
  else begin
    Printer.EndDoc;
    PrintingStatus:=9;
  end;
end;

procedure TPrintingDialog.AbortPrint;

begin
  Printer.Abort;
  Printer.EndDoc;
  PrintingStatus:=9;
end;

procedure TPrintingDialog.DoPrint;

begin
  Repeat
    Application.ProcessMessages;
    if Printer.Aborted then PrintingStatus:=5;
    Case PrintingStatus of
      0:StartPrint;
      1:ProcessPrint;
      2:TotalsPrint;
      3:AveragePrint;
      4:EndPrint;
      5:AbortPrint;
    end;
  Until PrintingStatus=9;
  Close;
end;

procedure TPrintingDialog.AbortButtonClick(Sender: TObject);
begin
  PrintingStatus:=5;
end;

end.
