unit Dllmgr01;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Grids, Srtgrid, StdCtrls, ExtCtrls, ToolHelp, Menus,
  DLLMgr02;

type
  TDLLManager = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Save1: TMenuItem;
    Exit1: TMenuItem;
    Sort1: TMenuItem;
    byName1: TMenuItem;
    byUseCount1: TMenuItem;
    byHandle1: TMenuItem;
    byLoadPath1: TMenuItem;
    byLoadOrder1: TMenuItem;
    Include1: TMenuItem;
    DLLs1: TMenuItem;
    EXEs1: TMenuItem;
    DRVs1: TMenuItem;
    FONs1: TMenuItem;
    All1: TMenuItem;
    Management1: TMenuItem;
    LoadDLL1: TMenuItem;
    UnloadDLL1: TMenuItem;
    N2: TMenuItem;
    Refresh2: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Compare1: TMenuItem;
    N3: TMenuItem;
    OpenDialog2: TOpenDialog;
    Notebook1: TNotebook;
    DLLList: TSortedStringGrid;
    Panel3: TPanel;
    CompareGrid: TSortedStringGrid;
    Panel4: TPanel;
    tHelp1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Contents1: TMenuItem;
    procedure ExitBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure byName1Click(Sender: TObject);
    procedure byUseCount1Click(Sender: TObject);
    procedure byHandle1Click(Sender: TObject);
    procedure byLoadPath1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure DLLs1Click(Sender: TObject);
    procedure UnloadDLL1Click(Sender: TObject);
    procedure Refresh2Click(Sender: TObject);
    procedure LoadDLL1Click(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure Compare1Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    procedure ListModules;
    procedure SortCheck(Item : integer);
    procedure IncludeCheck(Item : integer);
    { Private declarations }
  public

  end;

var
  DLLManager: TDLLManager;

implementation

{$R *.DFM}

procedure TDLLManager.ListModules;

var
  ModuleData : TModuleEntry;
  i : integer;
  S : string;

begin
  fillchar(ModuleData,sizeof(ModuleData),0);
  for i := 1 to DLLList.RowCount - 1 do DLLList.Rows[i].Clear;
  ModuleData.dwSize := sizeof(ModuleData);
  i := 1;
  if ModuleFirst(@ModuleData) then
  repeat
    S := StrPas(ModuleData.szEXEPath);
    if DLLs1.Checked and (Pos('.DLL',UpperCase(S)) > 0) or
       EXEs1.Checked and (Pos('.EXE',UpperCase(S)) > 0) or
       DRVs1.Checked and (Pos('.DRV',UpperCase(S)) > 0) or
       FONs1.Checked and (Pos('.FON',UpperCase(S)) > 0) or
       All1.Checked  then
    with DLLList do
    begin
      Cells[0,i] := StrPas(ModuleData.szModule);
      Cells[1,i] := IntToHex(ModuleData.hModule,4);
      Cells[2,i] := IntToStr(ModuleData.wUsageFlags);
      Cells[3,i] := StrPas(ModuleData.szEXEPath);
      inc(i);
    end;
  until not ModuleNext(@ModuleData);
  Panel3.Caption := Format('%d Loaded DLLs',[i]);
end;

procedure TDLLManager.SortCheck(Item : integer);

begin
  if Item = 0 then ByName1.Checked := TRUE else ByName1.Checked := FALSE;
  if Item = 1 then ByUseCount1.Checked := TRUE else ByUseCount1.Checked := FALSE;
  if Item = 2 then ByHandle1.Checked := TRUE else ByHandle1.Checked := FALSE;
  if Item = 3 then ByLoadPath1.Checked := TRUE else ByLoadPath1.Checked := FALSE;
  if Item = 4 then ByLoadOrder1.Checked := TRUE else ByLoadOrder1.Checked := FALSE;
end;

procedure TDLLManager.IncludeCheck(Item : integer);

begin
  if Item = 0 then DLLs1.Checked := TRUE else DLLs1.Checked := FALSE;
  if Item = 1 then EXEs1.Checked := TRUE else EXEs1.Checked := FALSE;
  if Item = 2 then DRVs1.Checked := TRUE else DRVs1.Checked := FALSE;
  if Item = 3 then FONs1.Checked := TRUE else FONs1.Checked := FALSE;
  if Item = 4 then All1.Checked := TRUE else All1.Checked := FALSE;
end;

procedure TDLLManager.ExitBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TDLLManager.FormShow(Sender: TObject);
begin
  Notebook1.PageIndex := 0;
  with DLLList do
  begin
    Cells[0,0] := ' Name    ';
    Cells[1,0] := ' Handle ';
    Cells[2,0] := ' Usage ';
    Cells[3,0] := ' Path';
    ColWidths[0] := Canvas.TextWidth('WWWWWW');
    ColWidths[1] := Canvas.TextWidth('WWWW');
    ColWidths[2] := Canvas.TextWidth('WWWW');
    ColWidths[3] := Width - ColWidths[0] - ColWidths[1] - ColWidths[2] -
                    GetSystemMetrics(SM_CXVSCROLL) - 5;
  end;
  SortCheck(4);
  DLLS1.Checked := TRUE;
  ListModules;
end;

procedure TDLLManager.byName1Click(Sender: TObject);
begin
  DLLList.SortColumn := 0;
  DLLList.SortGrid;
  SortCheck(0);
end;

procedure TDLLManager.byUseCount1Click(Sender: TObject);
begin
  DLLList.SortColumn := 2;
  DLLList.SortGrid;
  SortCheck(2);
end;

procedure TDLLManager.byHandle1Click(Sender: TObject);
begin
  DLLList.SortColumn := 1;
  DLLList.SortGrid;
  SortCheck(1);
end;

procedure TDLLManager.byLoadPath1Click(Sender: TObject);
begin
  DLLList.SortColumn := 3;
  DLLList.SortGrid;
  SortCheck(4);
end;

procedure TDLLManager.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TDLLManager.DLLs1Click(Sender: TObject);
begin
  (Sender as TMenuItem).Checked := not (Sender as TMenuItem).Checked;
  Refresh2Click(Sender);
end;

procedure TDLLManager.UnloadDLL1Click(Sender: TObject);

var
   DLLPath : string;
   DLLHandle : string;
   HexHandle : THandle;
   RetCode : integer;

begin
  DLLPath := DLLList.Cells[3,DLLList.Row];
  RetCode := mrYes;
  if Pos('WINDOWS',UpperCase(DLLPath)) > 0 then
  begin
    RetCode := MessageDlg('Module is a possible Windows component.  Continue?',
                          mtWarning,[mbYes,mbNo],0);
  end;
  if (StrToInt(DLLList.Cells[2,DLLList.Row]) > 5) and (RetCode = mrYes) then
  begin
    RetCode := MessageDlg('Multiple applications are using this module.  Continue?',
                          mtWarning,[mbYes,mbNo],0);
  end;
  if RetCode = mrYes then
  begin
    DLLhandle := DLLList.Cells[1,DLLList.Row];
    DLLHandle := '$' + DLLHandle;
    HexHandle := THandle(StrToInt(DLLHandle));
    repeat
      FreeLibrary(HexHandle); MessageBeep(MB_OK);
    until GetModuleUsage(HexHandle) = 0;
    Refresh2Click(Sender);
  end;
end;

procedure TDLLManager.Refresh2Click(Sender: TObject);
begin
  ListModules;
  if not byLoadOrder1.Checked then DLLList.SortGrid;
end;

procedure TDLLManager.LoadDLL1Click(Sender: TObject);

var
   ModName : array[0..255] of char;
   RetCode : integer;

begin
  if OpenDialog1.Execute then
  begin
    StrPCopy(ModName,OpenDialog1.FileName);
    RetCode := LoadLibrary(ModName);
    if RetCode < 32 then
    begin
      case RetCode of
        2 : ShowMessage('File not found.');
      else
        ShowMessage('Error loading file: ' + IntToStr(RetCode));
      end;
    end;
    Refresh2Click(Sender);
  end;
end;

procedure TDLLManager.Save1Click(Sender: TObject);

var
   LFile : textfile;
   i : integer;

begin
  if SaveDialog1.Execute then
  begin
    AssignFile(LFile,SaveDialog1.FileName); rewrite(LFile);
    Writeln(LFile,'DLL Manager Log: ' + FormatDateTime('dd mmm, yyyy  hh:mm',Now));
    Writeln(LFile,'DLLS loaded:');
    for i := 1 to DLLList.RowCount - 1 do
    with DLLList do
    begin
      if length(Cells[0,i]) > 0 then
      begin
        writeln(LFile,#9 + Cells[3,i]);
      end;
    end;
    CloseFile(LFile);
  end;
end;

procedure TDLLManager.Compare1Click(Sender: TObject);

var
   CurList,OldList : TStringList;
   DFile : textfile;
   S : string;
   i,c : integer;

begin
  if Pos('Compare',Compare1.Caption) > 0 then
  begin
    if OpenDialog2.Execute then
    begin
      Compare1.Caption := '&Live View';
      Sort1.Enabled := FALSE;
      Include1.Enabled := FALSE;
      Management1.Enabled := FALSE;
      OldList := TStringList.Create;
      try
        Screen.Cursor := crHourGlass;
        AssignFile(DFile,OpenDialog2.FileName); reset(DFile);
        while not EOF(DFile) do
        begin
          readln(DFile,S);
          if S[1] = #9 then OldList.Add(Copy(S,2,length(S)));
        end;
        CloseFile(DFile);
      finally
        Screen.Cursor := crDefault;
      end;
      CurList := TStringList.Create;
      for i := 1 to DLLList.RowCount - 1 do
      with DLLList do
      begin
        if length(Cells[0,i]) > 0 then CurList.Add(Cells[3,i]);
      end;
    end;
    Notebook1.PageIndex := 1;
    with CompareGrid do
    begin
      Cells[0,0] := OpenDialog2.FileName;
      Cells[1,0] := 'Currently loaded modules';
      C := 1;
      for i := 0 to OldList.Count - 1 do
      begin
        if CurList.IndexOf(OldList[i]) < 0 then
        begin
          Cells[0,c] := OldList[i];
          inc(c);
        end;
      end;
      C := 1;
      for i := 0 to CurList.Count - 1 do
      begin
        if OldList.IndexOf(CurList[i]) < 0 then
        begin
          Cells[1,c] := CurList[i];
          inc(c);
        end;
      end;
    end;
  end
  else
  begin
    Sort1.Enabled := TRUE;
    Include1.Enabled := TRUE;
    Management1.Enabled := TRUE;
    Notebook1.PageIndex := 0;
    Compare1.Caption := '&Compare';
  end;
end;

procedure TDLLManager.Contents1Click(Sender: TObject);
begin
  Application.HelpContext(0);
end;

procedure TDLLManager.About1Click(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

end.
