unit Creator;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Menus, StdCtrls, Buttons, Mask, FileCtrl,
  DChoose,DCheck,FCheck,ICheck,Saving;

type
  TPrincipale = class(TForm)
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    Label1: TLabel;
    Label2: TLabel;
    ProjectTitle: TEdit;
    ProjectSubTit: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    NbrFiles: TEdit;
    NbrIcons: TEdit;
    btFilesAdd: TBitBtn;
    btIconsAdd: TBitBtn;
    Label5: TLabel;
    Label6: TLabel;
    ProjectSize: TEdit;
    ProjectDisk: TEdit;
    btFilesSub: TBitBtn;
    btIconsSub: TBitBtn;
    btFilesChk: TBitBtn;
    btIconsChk: TBitBtn;
    History: TMemo;
    Bevel6: TBevel;
    Label8: TLabel;
    Label7: TLabel;
    Bevel7: TBevel;
    Label9: TLabel;
    NbrApps: TEdit;
    btAppsAdd: TBitBtn;
    btAppsSub: TBitBtn;
    btAppsChk: TBitBtn;
    Bevel8: TBevel;
    Label10: TLabel;
    TitGroupName: TEdit;
    Label11: TLabel;
    TitGroupFile: TEdit;
    Bevel9: TBevel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    ProjectYear: TMaskEdit;
    ProjectVersion: TEdit;
    ProjectSourceDrv: TDriveComboBox;
    ProjectTargetDrv: TDriveComboBox;
    ProjectTargetDir: TDirectoryListBox;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Bevel10: TBevel;
    Bevel5: TBevel;
    btStop: TBitBtn;
    ProjectAuthor: TEdit;
    btOpen: TBitBtn;
    btSave: TBitBtn;
    btGenerate: TBitBtn;
    btNew: TBitBtn;
    OpenDialog: TOpenDialog;
    ChooseDialog: TOpenDialog;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Bevel11: TBevel;
    Project_Pack: TCheckBox;
    procedure btStopClick(Sender: TObject);
    procedure btOpenClick(Sender: TObject);
    procedure btNewClick(Sender: TObject);
    procedure btSaveClick(Sender: TObject);
    procedure btGenerateClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
    procedure btFilesChkClick(Sender: TObject);
    procedure btFilesSubClick(Sender: TObject);
    procedure btFilesAddClick(Sender: TObject);
    procedure btIconsAddClick(Sender: TObject);
    procedure btIconsSubClick(Sender: TObject);
    procedure btIconsChkClick(Sender: TObject);
    procedure btAppsAddClick(Sender: TObject);
    procedure btAppsSubClick(Sender: TObject);
    procedure btAppsChkClick(Sender: TObject);
    procedure Modification(Sender: TObject);
  private
    { Private-dclarations }
    procedure DisplayHistory (Tmp : string);
    procedure SaveProject;
    procedure LoadProject;
    function  CheckInformation : integer;
    procedure ClearAll;
    procedure DisplayInformation;
    procedure GetInformation;
    function  Generate : integer;
  public
    { Public-dclarations }
  end;

var Principale: TPrincipale;

implementation

uses decla,disque;

{$R *.DFM}

(* display history lines *)
procedure TPrincipale.DisplayHistory (Tmp : string);
begin
 History.Lines.add (Tmp);
end;

(* check all information *)
function TPrincipale.CheckInformation : integer;
var tmp : integer;
    bcl : integer;
    bc1 : integer;
    bc2 : integer;
    nom : string;
    fnd : boolean;
begin
 tmp := 0;
 if Nbr_Apps > 0 then
 begin
  for bcl := 1 to Nbr_Apps do
  begin
   nom := ProjectApps [Bcl].Documen.Path + '\' +
          ProjectApps [Bcl].Documen.Name;
   fnd := false;
   (* check files *)
   if Nbr_Files > 0 then
   begin
    for Bc1 := 1 to Nbr_Files do
    begin
     if Nom = ProjectFile [Bc1].Fichier.Path + '\' +
              ProjectFile [Bc1].Fichier.Name then
      Fnd := true;
    end;
   end;
   (* check icons *)
   if (Nbr_Icons > 0) and (fnd = false) then
   begin
    for Bc2 := 1 to Nbr_Icons do
    begin
     if Nom = ProjectIcon [Bc2].Fichier.Path + '\' +
              ProjectIcon [Bc2].Fichier.Name then
      Fnd := true;
    end;
   end;
   (* no found so error *)
   if Fnd = false then Tmp := Bcl;
  end;
 end;
 CheckInformation := Tmp;
end;

(* display all information *)
procedure TPrincipale.DisplayInformation;
begin
 if Nbr_Size = 0 then
  Nbr_Disk := 0
 else
  Nbr_Disk := (Nbr_Size div max_Flop) + 1;
 ProjectTitle.Text   := ProjectName;
 ProjectSubTit.Text  := ProjectSNam;
 ProjectSize.Text    := IntToStr (Nbr_Size);
 ProjectDisk.Text    := IntToStr (Nbr_Disk);
 ProjectYear.Text    := ProjectAnne;
 ProjectVersion.Text := ProjectVers;
 ProjectAuthor.Text  := ProjectAuth;
 TitGroupName.Text   := ProjectNGrp;
 TitGroupFile.Text   := ProjectFGrp;
 NbrFiles.Text       := IntToStr (Nbr_Files);
 NbrIcons.Text       := IntToStr (Nbr_Icons);
 NbrApps.Text        := IntToStr (Nbr_Apps);
 ProjectSourceDrv.Drive := ProjectSour;
 ProjectTargetDrv.Drive := ProjectTarg;
 ProjectTargetDir.Directory := ProjectTarg + ':' + ProjectDire;
 if ProjectPack = 1 then Project_Pack.State := cbChecked
                    else Project_Pack.State := cbUnChecked;
 (* update buttons *)
 btFilesSub.Enabled := Nbr_Files > 0;
 btIconsSub.Enabled := Nbr_Icons > 0;
 btAppsSub.Enabled  := Nbr_Apps  > 0;
 btFilesChk.Enabled := Nbr_Files > 0;
 btIconsChk.Enabled := Nbr_Icons > 0;
 btAppsChk.Enabled  := Nbr_Apps  > 0;
 btFilesAdd.Enabled := Nbr_Files < Max_File;
 btIconsAdd.Enabled := Nbr_Icons < Max_Icon;
 btAppsAdd.Enabled  := Nbr_Apps  < Max_Apps;
 if ProjName <> '' then Principale.Caption := HTitle + ' (' + ProjName + ')'
                   else Principale.Caption := HTitle + ' (Untitled)'
end;

(* get all screen informations *)
procedure TPrincipale.GetInformation;
var Bcl : integer;
begin
 if LoadInfo = true then Exit;
 ProjectName := ProjectTitle.Text;
 ProjectSNam := ProjectSubTit.Text;
 ProjectAnne := ProjectYear.Text;
 ProjectVers := ProjectVersion.Text;
 ProjectAuth := ProjectAuthor.Text;
 ProjectNGrp := TitGroupName.Text;
 ProjectFGrp := TitGroupFile.Text;
 if Project_Pack.State = cbChecked then ProjectPack := 1
                                   else ProjectPack := 0;
 ProjectSour := upcase (ProjectSourceDrv.Drive);
 ProjectTarg := upcase (ProjectTargetDrv.Drive);
 ProjectDire := ProjectTargetDir.Directory;
 Delete (ProjectDire,1,2);
 for Bcl := 1 to Length (ProjectDire) do
  ProjectDire [Bcl] := upcase (ProjectDire [Bcl]);
end;

(* generate Script file *)
function TPrincipale.Generate : integer;
var Tmp : integer;
    Fch : System.Text;
    Lgn : string;
    Lg1 : string;
    Bcl : integer;
    Cur : integer;
    Rem : longint;
    Tm1 : integer;

    (* write in INS file *)
    function Ecrit (Ligne : string) : integer;
    var Tmp : integer;
    begin
     {$I-}; writeln (Fch,Ligne); {$I+};
     Tmp := Ioresult;
     Ecrit := Tmp;
    end;

begin
 (* install script file *)
 GetInformation;
 Tmp := 0; Cur := 1; Rem := 0;
 System.assign (Fch,'SETUP.INS');
 {$I-}; rewrite (Fch); {$I+};
 if ioresult <> 0 then
  Tmp := 1
 else
 begin
  (* header *)
  Ecrit ('; ****************************************');
  Ecrit ('; *                                      *');
  Ecrit ('; * Setup by Creator for Setup & Unsetup *');
  Ecrit ('; * ------------------------------------ *');
  Ecrit ('; *                                      *');
  Ecrit ('; * (c)1996 by Jerome BERTRAND in Delphi *');
  Ecrit ('; *                                      *');
  Ecrit ('; ****************************************');
  Ecrit ('');
  Ecrit ('; %1 = Application directory');
  Ecrit ('; %W = Windows Directory');
  Ecrit ('; %S = Windows System Directory');
  Ecrit ('');
  (* information *)
  if Ecrit (par_Inf) = 0 then
  begin
   Ecrit ('TITLE='     + ProjectName);
   Ecrit ('SUBTITLE='  + ProjectSNam);
   Ecrit ('VERSION='   + ProjectVers);
   Ecrit ('AUTHOR='    + ProjectAuth);
   Ecrit ('COPYRIGHT=' + ProjectAnne);
   Ecrit ('');
  end;
  (* disks *)
  if Ecrit (par_Dsk) = 0 then
  begin
   str (Nbr_Disk:2,Lgn);
   while pos (' ',Lgn) <> 0 do delete (Lgn,pos (' ',Lgn),1);
   Ecrit ('DSK=' + Lgn);
   str (Nbr_SizI:10,Lgn);
   while pos (' ',Lgn) <> 0 do delete (Lgn,pos (' ',Lgn),1);
   Ecrit ('SPC=' + Lgn);
   Ecrit ('');
  end;
  (* origin *)
  if Ecrit (par_Src) = 0 then
  begin
   Ecrit ('ODSK=' + upcase (ProjectSour));
   Ecrit ('OPAT=' + '\');
   Ecrit ('');
  end;
  (* destination *)
  if Ecrit (par_Trg) = 0 then
  begin
   Ecrit ('DDSK=' + upcase (ProjectTarg));
   Ecrit ('DPAT=' + ProjectDire);
   Ecrit ('');
  end;
  (* group *)
  if Ecrit (par_Grp) = 0 then
  begin
   if (ProjectNGrp = '') and (ProjectFGrp = '') then
   begin
    Ecrit ('NUM=0');
    Ecrit ('');
   end
   else
   begin
    Ecrit ('NUM=1');
    Ecrit ('1=' + ProjectNGrp + ',' + ProjectFGrp);
    Ecrit ('');
   end;
  end;
  (* icons *)
  if Ecrit (par_Ico) = 0 then
  begin
   str (Nbr_Icons:2,Lgn);
   while pos (' ',Lgn) <> 0 do delete (Lgn,Pos (' ',Lgn),1);
   Ecrit ('NUM=' + Lgn);
   if Nbr_Icons > 0 then
   begin
    for Bcl := 1 to Nbr_Icons do
    begin
     if ProjectIcon [Bcl].Compres = 1 then
      Inc (Rem,ProjectIcon [Bcl].Fichier.SizC)
     else
      Inc (Rem,ProjectIcon [Bcl].Fichier.Size);
     if Rem > Max_Flop then
     begin
      Inc (Cur);
      If ProjectIcon [Bcl].Compres = 1 then
       Rem := ProjectIcon [Bcl].Fichier.SizC
      else
       Rem := ProjectIcon [Bcl].Fichier.Size;
     end;
     str (Bcl,Lgn); While pos (' ',Lgn) <> 0 do Delete (Lgn,pos (' ',Lgn),1);
     str (Cur,Lg1); While pos (' ',Lg1) <> 0 do Delete (Lg1,pos (' ',Lg1),1);
     if ProjectIcon [Bcl].Compres = 1 then
     begin
      With ProjectIcon [Bcl] do
      begin
       Ecrit (Lgn + '=' + Lg1 + ','
                        + Fichier.Name + ','
                        + Fichier.Path + ','
                        + Descrip.Icon + ',_');
      end;
     end
     else
     begin
      with ProjectIcon [Bcl] do
      begin
       Ecrit (Lgn + '=' + Lg1 + ','
                        + Fichier.Name + ','
                        + Fichier.Path + ','
                        + Descrip.Icon + ',#');
      end;
     end;
    end;
   end;
   Ecrit ('');
  end;
  (* files *)
  if Ecrit (par_Fil) = 0 then
  begin
   Tm1 := 0;
   if Nbr_Files > 0 then
   begin
    for Bcl := 1 to Nbr_Files do
     If ProjectFile [Bcl].CopyFil = 1 then Inc (Tm1);
   end;
   str (Tm1:2,Lgn);
   while pos (' ',Lgn) <> 0 do delete (Lgn,Pos (' ',Lgn),1);
   Ecrit ('NUM=' + Lgn);
   if Nbr_Files > 0 then
   begin
    Tm1 := 0;
    for Bcl := 1 to Nbr_Files do
    begin
     if ProjectFile [Bcl].CopyFil = 1 then
     begin
      Inc (Tm1);
      if ProjectFile [Bcl].Compres = 1 then
       Inc (Rem,ProjectFile [Bcl].Fichier.SizC)
      else
       Inc (Rem,ProjectFile [Bcl].Fichier.Size);
      if Rem > Max_Flop then
      begin
       Inc (Cur);
       if ProjectFile [Bcl].Compres = 1 then
        Rem := ProjectFile [Bcl].Fichier.SizC
       else
        Rem := ProjectFile [Bcl].Fichier.Size;
      end;
      str (Tm1,Lgn); While pos (' ',Lgn) <> 0 do Delete (Lgn,pos (' ',Lgn),1);
      str (Cur,Lg1); While pos (' ',Lg1) <> 0 do Delete (Lg1,pos (' ',Lg1),1);
      if ProjectFile [Bcl].Compres = 1 then
      begin
       With ProjectFile [Bcl] do
       begin
        Ecrit (Lgn + '=' + Lg1 + ','
                         + Fichier.Name + ','
                         + Fichier.Path + ',_');
       end;
      end
      else
      begin
       With ProjectFile [Bcl] do
       begin
        Ecrit (Lgn + '=' + Lg1 + ','
                         + Fichier.Name + ','
                         + Fichier.Path + ',#');
       end;
      end;
     end;
    end;
   end;
   Ecrit ('');
  end;
  (* run *)
  if Ecrit (par_Run) = 0 then
  begin
   str (Nbr_Apps:2,Lgn);
   while pos (' ',Lgn) <> 0 do delete (Lgn,Pos (' ',Lgn),1);
   Ecrit ('NUM=' + Lgn);
   if Nbr_Apps > 0 then
   begin
    for Bcl := 1 to Nbr_Apps do
    begin
     str (Bcl,Lgn); While pos (' ',Lgn) <> 0 do Delete (Lgn,pos (' ',Lgn),1);
     With ProjectApps [Bcl] do
     begin
      Ecrit (Lgn + '=' + Executa.Name + ','
                       + Executa.Path + ','
                       + Documen.Name + ','
                       + Documen.Path);
     end;
    end;
   end;
   (* footer *)
   Ecrit ('');
   Ecrit ('; * End of INS File for Setup *');
   Ecrit ('');
  end;
  System.Close (Fch);
 end;
 (* packing list file *)
 System.Assign (Fch,ProjectTarg + ':' + ProjectDire + '\PACKING.LST');
 {$I-}; Rewrite (Fch); {$I+};
 if ioresult <> 0 then
  Tmp := 2
 else
 begin
  writeln (Fch);
  writeln (Fch,ProjectName + ' v ' + ProjectVers);
  writeln (Fch,ProjectSNam);
  writeln (Fch,'(c)' + ProjectAnne + ' by ' + ProjectAuth);
  writeln (Fch);
  Writeln (Fch,'Size':10,'   ','File Name':12,'   ','Path to file');
  if Nbr_Icons > 0 then
  begin
   For Bcl := 1 to Nbr_Icons do
   begin
    With ProjectIcon [Bcl] do
    begin
     Lgn := Fichier.Name;
     While length (Lgn) < 12 do Insert (' ',Lgn,pos ('.',Lgn));
     if Fichier.Path [1] = '%' then
     begin
      Case Fichier.Path [2] of
       '1' : Lgn := Lgn + '   ' + ProjectTarg + ':' + ProjectDire + '\';
       'W' : Lgn := Lgn + '   ' + WinDir + '\';
       'S' : Lgn := Lgn + '   ' + SysDir + '\';
      end;
     end
     else
      Lgn := Lgn + '   ' + Fichier.Path;
     if Compres = 1 then
      writeln (Fch,Fichier.SizC:10,'   ',Lgn)
     else
      writeln (Fch,Fichier.Size:10,'   ',Lgn);
    end;
   end;
  end;
  if Nbr_Files > 0 then
  begin
   For Bcl := 1 to Nbr_Files do
   begin
    With ProjectFile [Bcl] do
    begin
     if CopyFil = 1 then
     begin
      Lgn := Fichier.Name;
      While length (Lgn) < 12 do Insert (' ',Lgn,pos ('.',Lgn));
      if Fichier.Path [1] = '%' then
      begin
       Case Fichier.Path [2] of
        '1' : Lgn := Lgn + '   ' + ProjectTarg + ':' + ProjectDire + '\';
        'W' : Lgn := Lgn + '   ' + WinDir + '\';
        'S' : Lgn := Lgn + '   ' + SysDir + '\';
       end;
      end
      else
       Lgn := Lgn + '   ' + Fichier.Path;
      if Compres = 1 then
       writeln (Fch,Fichier.SizC:10,'   ',Lgn)
      else
       writeln (Fch,Fichier.Size:10,'   ',Lgn);
     end;
    end;
   end;
  end;
  System.Close (Fch);
 end;
 Generate := Tmp;
end;

(* save project *)
procedure TPrincipale.SaveProject;
var Fch : System.Text;
    Bcl : integer;
begin
 GetInformation;
 System.Assign (Fch,ProjName + '.PRJ');
 System.Rewrite (Fch);
 (* general informations *)
 writeln (Fch,ProjectName);
 writeln (Fch,ProjectSNam);
 writeln (Fch,ProjectVers);
 writeln (Fch,ProjectAuth);
 writeln (Fch,ProjectAnne);
 writeln (Fch,Nbr_Disk);
 writeln (Fch,Nbr_Size);
 writeln (Fch,Nbr_SizI);
 writeln (Fch,ProjectNGrp);
 writeln (Fch,ProjectFGrp);
 writeln (Fch,ProjectPack);
 writeln (Fch,ProjectSour);
 writeln (Fch,ProjectTarg);
 writeln (Fch,ProjectDire);
 (* files *)
 writeln (Fch,Nbr_Files);
 for Bcl := 1 to Nbr_Files do
 begin
  With ProjectFile [Bcl] do
  begin
   writeln (Fch,Fichier.Name);
   writeln (Fch,Fichier.Path);
   writeln (Fch,Fichier.Size);
   writeln (Fch,Fichier.SizC);
   writeln (Fch,Descrip.Icon);
   writeln (Fch,Compres);
   writeln (Fch,CopyFil);
  end;
 end;
 (* icons *)
 writeln (Fch,Nbr_Icons);
 for Bcl := 1 to Nbr_Icons do
 begin
  With ProjectIcon [Bcl] do
  begin
   writeln (Fch,Fichier.Name);
   writeln (Fch,Fichier.Path);
   writeln (Fch,Fichier.Size);
   writeln (Fch,Fichier.SizC);
   writeln (Fch,Descrip.Icon);
   writeln (Fch,Compres);
  end;
 end;
 (* documents *)
 writeln (Fch,Nbr_Apps);
 for Bcl := 1 to Nbr_Apps do
 begin
  With ProjectApps [Bcl] do
  begin
   writeln (Fch,Executa.Name);
   writeln (Fch,Executa.Path);
   writeln (Fch,Executa.Size);
   writeln (Fch,Documen.Name);
   writeln (Fch,Documen.Path);
   writeln (Fch,Documen.Size);
   writeln (Fch,Descrip.Icon);
  end;
 end;
 System.Close (Fch);
end;

(* load project *)
procedure TPrincipale.LoadProject;
var Fch : System.Text;
    Bcl : integer;
begin
 System.Assign (Fch,ProjName + '.PRJ');
 System.Reset (Fch);
 (* general informations *)
 readln (Fch,ProjectName);
 readln (Fch,ProjectSNam);
 readln (Fch,ProjectVers);
 readln (Fch,ProjectAuth);
 readln (Fch,ProjectAnne);
 readln (Fch,Nbr_Disk);
 readln (Fch,Nbr_Size);
 readln (Fch,Nbr_SizI);
 readln (Fch,ProjectNGrp);
 readln (Fch,ProjectFGrp);
 readln (Fch,ProjectPack);
 readln (Fch,ProjectSour);
 readln (Fch,ProjectTarg);
 readln (Fch,ProjectDire);
 (* files *)
 readln (Fch,Nbr_Files);
 for Bcl := 1 to Nbr_Files do
 begin
  With ProjectFile [Bcl] do
  begin
   readln (Fch,Fichier.Name);
   readln (Fch,Fichier.Path);
   readln (Fch,Fichier.Size);
   readln (Fch,Fichier.SizC);
   readln (Fch,Descrip.Icon);
   readln (Fch,Compres);
   readln (Fch,CopyFil);
  end;
 end;
 (* icons *)
 readln (Fch,Nbr_Icons);
 for Bcl := 1 to Nbr_Icons do
 begin
  With ProjectIcon [Bcl] do
  begin
   readln (Fch,Fichier.Name);
   readln (Fch,Fichier.Path);
   readln (Fch,Fichier.Size);
   readln (Fch,Fichier.SizC);
   readln (Fch,Descrip.Icon);
   readln (Fch,Compres);
  end;
 end;
 (* documents *)
 readln (Fch,Nbr_Apps);
 for Bcl := 1 to Nbr_Apps do
 begin
  With ProjectApps [Bcl] do
  begin
   readln (Fch,Executa.Name);
   readln (Fch,Executa.Path);
   readln (Fch,Executa.Size);
   readln (Fch,Documen.Name);
   readln (Fch,Documen.Path);
   readln (Fch,Documen.Size);
   readln (Fch,Descrip.Icon);
  end;
 end;
 System.Close (Fch);
end;

(* Clear all informations *)
procedure TPrincipale.ClearAll;
var Bcl : integer;
begin
 (* screen *)
 History.Clear;
 DisplayHistory (HTitle);
 DisplayHistory (HAuthor);
 DisplayHistory ('');
 DisplayHistory (HStart);
 ProjectTitle.Text   := '';
 ProjectSubTit.Text  := '';
 ProjectSize.Text    := '0';
 ProjectDisk.Text    := '0';
 ProjectYear.Text    := '';
 ProjectVersion.Text := '';
 ProjectAuthor.Text  := '';
 ProjectSourceDrv.Drive := 'A';
 ProjectTargetDrv.Drive := 'C';
 TitGroupName.Text   := '';
 TitGroupFile.Text   := '';
 NbrFiles.Text       := '0';
 NbrIcons.Text       := '0';
 NbrApps.Text        := '0';
 (* variables *)
 ProjName := '';
 ProjectName := '';
 ProjectSNam := '';
 ProjectNGrp := '';
 ProjectFGrp := '';
 ProjectAuth := '';
 ProjectAnne := '';
 ProjectVers := '';
 ProjectSour := 'A';
 ProjectTarg := 'C';
 ProjectDire := '';
 for Bcl := 1 to max_file do
 begin
  With ProjectFile [Bcl] do
  begin
   Fichier.Name := '';
   Fichier.Path := '';
   Descrip.Icon := '';
  end;
 end;
 for Bcl := 1 to max_icon do
 begin
  With ProjectIcon [Bcl] do
  begin
   Fichier.Name := '';
   Fichier.Path := '';
   Descrip.Icon := '';
  end;
 end;
 for Bcl := 1 to max_apps do
 begin
  With ProjectApps [Bcl] do
  begin
   Executa.Name := '';
   Executa.Path := '';
   Documen.Name := '';
   Documen.Path := '';
   Descrip.Icon := '';
  end;
 end;
 (* others *)
 Nbr_Files           := 0;
 Nbr_Icons           := 0;
 Nbr_Apps            := 0;
 Nbr_Disk            := 0;
 Nbr_Size            := 0;
 LoadInfo := false;
 Modificatio := false;
end;

(* quit application *)
procedure TPrincipale.btStopClick(Sender: TObject);
begin
 if Modificatio = true then
 begin
  if MessageDlg ('Do you want to save current project ?',
                 mtConfirmation,[mbYes,mbNo],0) = mrYes then
  begin
   if ProjName =  '' then Save.ShowModal;
   if ProjName <> '' then SaveProject;
  end;
 end;
 if MessageDlg ('Do you really want to quit application',
                mtConfirmation,[mbYes,mbNo],0) = mrYes then
  Close;
end;

(* open project *)
procedure TPrincipale.btOpenClick(Sender: TObject);
begin
 if Modificatio = True then
 begin
  if ProjName =  '' then Save.ShowModal;
  if ProjName <> '' then SaveProject;
 end;
 if OpenDialog.Execute then
 begin
  ClearAll;
  ProjName := OpenDialog.FileName;
  Delete (ProjName,pos ('.',ProjName),4);
  DisplayHistory ('Opening project ' + ProjName);
  LoadProject;
  LoadInfo := true;
  DisplayInformation;
  LoadInfo := False;
  Modificatio := false;
 end;
end;

(* new project *)
procedure TPrincipale.btNewClick(Sender: TObject);
begin
 if Modificatio = true then
 begin
  if MessageDlg ('Do you want to save project before create new file',
                 mtConfirmation,[mbYes,mbNo],0) = mrYes then
  begin
   if ProjName =  '' then Save.ShowModal;
   if ProjName <> '' then SaveProject;
  end;
 end;
 ClearAll;
 DisplayInformation;
 Modificatio := false;
 DisplayHistory ('New file activated');
end;

(* save project *)
procedure TPrincipale.btSaveClick(Sender: TObject);
begin
 if ProjName =  '' then Save.ShowModal;
 if ProjName <> '' then SaveProject;
 DisplayHistory ('Saving project ' + ProjName);
end;

(* generate button *)
procedure TPrincipale.btGenerateClick(Sender: TObject);
var Tmp : integer;
begin
 If ProjName = '' then
 begin
  MessageDlg ('You must have a project name before generating script file',
              mtinformation,[mbok],0);
  exit;
 end;
 Tmp := CheckInformation;
 if Tmp = 0 then
 begin
  if MessageDlg ('Do you really want to generate install script file ?',
                 mtConfirmation,[mbYes,mbNo],0) = mrYes then
  begin
   DisplayHistory ('Generation of install script');
   Generate;
  end;
 end
 else
  MessageDlg ('Document ' + ProjectApps [Tmp].Documen.Name + ' is missing on' +
              ' icons list or files list for copy',mtError,[mbOk],0);
end;

(* initialisation of application *)
procedure TPrincipale.Initialise(Sender: TObject);
begin
 ClearAll;
 DisplayInformation;
 Modificatio := false;
end;

(* File Add button *)
procedure TPrincipale.btFilesAddClick(Sender: TObject);
var Tmp : integer;
    Sis : longint;
    SiC : longint;
    Nam : string [12];
    Pat : string [79];
    Com : string [79];
begin
 DisplayHistory ('Add a new file');
 ChooseDialog.InitialDir := ProjectTarg + ':' + ProjectDire;
 If ChooseDialog.Execute then
 begin
  Com := ChooseDialog.FileName;
  Com [length (Com)] := '_';
  SiC := SizeFile (Com);
  Pat := ChooseDialog.FileName;
  while pos ('\',Pat) <> 0 do Delete (Pat,1,pos ('\',Pat));
  Nam := Pat;
  Pat := copy (ChooseDialog.FileName,3,
               Length (ChooseDialog.FileName) - Length (Nam) - 3);
  Sis := SizeFile (ChooseDialog.FileName);
  if (Nbr_Files + 1) < max_file then
  begin
   Inc (Nbr_Files);
   With ProjectFile [Nbr_Files] do
   begin
    Fichier.Name := Nam;
    if Pat = ProjectDire then Fichier.Path := '%1'
                         else Fichier.Path := Pat;
    Fichier.Size := Sis;
    Descrip.Icon := '';
    CopyFil := 1;
    Inc (Nbr_SizI,Sis);
    if SiC > 0 then
    begin
     Compres := 1;
     Fichier.SizC := SiC;
     Inc (Nbr_Size,SiC);
    end
    else
    begin
     Compres :=  0;
     Fichier.SizC := 0;
     Inc (Nbr_Size,Sis);
    end;
   end;
   DisplayInformation;
  end
  else
   MessageDlg ('Maximum of files reach',mtError,[mbok],0);
 end;
end;

(* File sub button *)
procedure TPrincipale.btFilesSubClick(Sender: TObject);
var Tmp : integer;
    Bcl : integer;
begin
 DisplayHistory ('Substract a file');
 Transfert.Siz := 1;
 FileChoose.ShowModal;
 Tmp := Transfert.Res;
 if Tmp <> 0 then
 begin
  if ProjectFile [Tmp].Fichier.SizC > 0 then
   Dec (Nbr_Size,ProjectFile [Tmp].Fichier.SizC)
  else
   Dec (Nbr_Size,ProjectFile [Tmp].Fichier.Size);
  Dec (Nbr_SizI,ProjectFile [Tmp].Fichier.Size);
  if Nbr_Files > 1 then
  begin
   for Bcl := Tmp to (Nbr_Files - 1) do
    ProjectFile [Bcl] := ProjectFile [Bcl + 1];
  end;
  With ProjectFile [Nbr_Files] do
  begin
   Fichier.Name := '';
   Fichier.Path := '';
   Fichier.Size := 0;
   Fichier.SizC := 0;
   Descrip.Icon := '';
   Compres := 0;
   CopyFil := 0;
  end;
  Dec (Nbr_Files);
 end;
 DisplayInformation;
end;

(* File check button *)
procedure TPrincipale.btFilesChkClick(Sender: TObject);
var Tmp : integer;
    Tp1 : integer;
    Tm1 : string [79];
    SiC : longint;
begin
 DisplayHistory ('Modifiy a file');
 GetInformation;
 Transfert.Siz := 1;
 FileChoose.ShowModal;
 Tmp := Transfert.Res;
 if Tmp <> 0 then
 begin
  with Transfert do
  begin
   Res := 1;
   Nom := ProjectFile [Tmp].Fichier.Name;
   Pat := ProjectFile [Tmp].Fichier.Path;
   Siz := ProjectFile [Tmp].Fichier.Size;
   SzC := ProjectFile [Tmp].Fichier.SizC;
   Cmp := ProjectFile [Tmp].Compres;
   Cop := ProjectFile [Tmp].CopyFil;
  end;
  Transfert.Res := 1;
  if CheckF.ShowModal = 1 then
  begin
   With Transfert do
   begin
    ProjectFile [Tmp].Fichier.Name := Nom;
    ProjectFile [Tmp].Fichier.Path := Pat;
    ProjectFile [Tmp].Fichier.Size := Siz;
    ProjectFile [Tmp].Fichier.SizC := SzC;
    ProjectFile [Tmp].Compres := Cmp;
    ProjectFile [Tmp].CopyFil := Cop;
   end;
   (* from compress to no compress *)
   if (ProjectFile [Tmp].Compres = 0) and
      (ProjectFile [Tmp].Fichier.SizC <> 0) then
   begin
    Dec (Nbr_Size,ProjectFile [Tmp].Fichier.SizC);
    Inc (Nbr_Size,ProjectFile [Tmp].Fichier.Size);
    ProjectFile [Tmp].Fichier.SizC := 0;
   end;
   (* from no compress to compress *)
   if (ProjectFile [Tmp].Compres = 1) and
      (ProjectFile [Tmp].Fichier.SizC = 0) then
   begin
    With ProjectFile [Tmp].Fichier do
    begin
     if Path [1] = '%' then
     begin
      Case Path [2] of
       '1' : Tm1 := ProjectDire;
       'W' : Tm1 := WinDir;
       'S' : Tm1 := SysDir;
      end;
     end
     else
      Tm1 := Path;
     Tm1 := ProjectTarg + ':' + Tm1 + '\' + Name;
     Tm1 [length (Tm1)] := '_';
     SizC := SizeFile (Tm1);
     if SizC > 0 then
     begin
      Dec (Nbr_Size,Size);
      Inc (Nbr_Size,SizC);
     end
     else
     begin
      SizC := 0;
      ProjectFile [Tmp].Compres := 0;
     end;
    end;
   end;
  end;
 end;
 DisplayInformation;
end;

(* Icon Add button *)
procedure TPrincipale.btIconsAddClick(Sender: TObject);
var Tmp : integer;
    Sis : longint;
    SiC : longint;
    Nam : string [12];
    Pat : string [79];
    Com : string [79];
begin
 DisplayHistory ('Add a new icon');
 ChooseDialog.InitialDir := ProjectTarg + ':' + ProjectDire;
 If ChooseDialog.Execute then
 begin
  Com := ChooseDialog.FileName;
  Com [length (Com)] := '_';
  SiC := SizeFile (Com);
  Pat := ChooseDialog.FileName;
  while pos ('\',Pat) <> 0 do Delete (Pat,1,pos ('\',Pat));
  Nam := Pat;
  Pat := copy (ChooseDialog.FileName,3,
               Length (ChooseDialog.FileName) - Length (Nam) - 3);
  Sis := SizeFile (ChooseDialog.FileName);
  if (Nbr_Icons + 1) < max_icon then
  begin
   Inc (Nbr_Icons);
   With ProjectIcon [Nbr_Icons] do
   begin
    Fichier.Name := Nam;
    if Pat = ProjectDire then Fichier.Path := '%1'
                         else Fichier.Path := Pat;
    Fichier.Size := Sis;
    Descrip.Icon := ChooseDialog.FileName;
    Inc (Nbr_SizI,Sis);
    if SiC > 0 then
    begin
     Compres := 1;
     Fichier.SizC := SiC;
     Inc (Nbr_Size,SiC);
    end
    else
    begin
     Compres :=  0;
     Fichier.SizC := 0;
     Inc (Nbr_Size,Sis);
    end;
   end;
   DisplayInformation;
  end
  else
   MessageDlg ('Maximum of icons reach',mtError,[mbok],0);
 end;
end;

(* Icon Sub button *)
procedure TPrincipale.btIconsSubClick(Sender: TObject);
var Tmp : integer;
    Bcl : integer;
begin
 DisplayHistory ('Substract an icon');
 Transfert.Siz := 2;
 FileChoose.ShowModal;
 Tmp := Transfert.Res;
 if Tmp <> 0 then
 begin
  if ProjectIcon [Tmp].Fichier.SizC > 0 then
   Dec (Nbr_Size,ProjectIcon [Tmp].Fichier.SizC)
  else
   Dec (Nbr_Size,ProjectIcon [Tmp].Fichier.Size);
  Dec (Nbr_SizI,ProjectIcon [Tmp].Fichier.Size);
  if Nbr_Icons > 1 then
  begin
   for Bcl := Tmp to (Nbr_Files - 1) do
    ProjectIcon [Bcl] := ProjectIcon [Bcl + 1];
  end;
  With ProjectIcon [Nbr_Icons] do
  begin
   Fichier.Name := '';
   Fichier.Path := '';
   Fichier.Size := 0;
   Fichier.SizC := 0;
   Descrip.Icon := '';
   Compres := 0;
  end;
  Dec (Nbr_Icons);
 end;
 DisplayInformation;
end;

(* Icon Check button *)
procedure TPrincipale.btIconsChkClick(Sender: TObject);
var Tmp : integer;
    Tp1 : integer;
    Tm1 : string [79];
    SiC : longint;
begin
 DisplayHistory ('Modifiy an icon');
 GetInformation;
 Transfert.Siz := 2;
 FileChoose.ShowModal;
 Tmp := Transfert.Res;
 if Tmp <> 0 then
 begin
  with Transfert do
  begin
   Res := 1;
   Nom := ProjectIcon [Tmp].Fichier.Name;
   Pat := ProjectIcon [Tmp].Fichier.Path;
   Siz := ProjectIcon [Tmp].Fichier.Size;
   SzC := ProjectIcon [Tmp].Fichier.SizC;
   Ico := ProjectIcon [Tmp].Descrip.Icon;
   Cmp := ProjectIcon [Tmp].Compres;
  end;
  Transfert.Res := 1;
  if CheckI.ShowModal = 1 then
  begin
   With Transfert do
   begin
    ProjectIcon [Tmp].Fichier.Name := Nom;
    ProjectIcon [Tmp].Fichier.Path := Pat;
    ProjectIcon [Tmp].Fichier.Size := Siz;
    ProjectIcon [Tmp].Fichier.SizC := SzC;
    ProjectIcon [Tmp].Compres := Cmp;
    ProjectIcon [Tmp].Descrip.Icon := Ico;
   end;
   (* from compress to no compress *)
   if (ProjectIcon [Tmp].Compres = 0) and
      (ProjectIcon [Tmp].Fichier.SizC <> 0) then
   begin
    Dec (Nbr_Size,ProjectIcon [Tmp].Fichier.SizC);
    Inc (Nbr_Size,ProjectIcon [Tmp].Fichier.Size);
    ProjectIcon [Tmp].Fichier.SizC := 0;
   end;
   (* from no compress to compress *)
   if (ProjectIcon [Tmp].Compres = 1) and
      (ProjectIcon [Tmp].Fichier.SizC = 0) then
   begin
    With ProjectIcon [Tmp].Fichier do
    begin
     if Path [1] = '%' then
     begin
      Case Path [2] of
       '1' : Tm1 := ProjectDire;
       'W' : Tm1 := WinDir;
       'S' : Tm1 := SysDir;
      end;
     end
     else
      Tm1 := Path;
     Tm1 := ProjectTarg + ':' + Tm1 + '\' + Name;
     Tm1 [length (Tm1)] := '_';
     SizC := SizeFile (Tm1);
     if SizC > 0 then
     begin
      Dec (Nbr_Size,Size);
      Inc (Nbr_Size,SizC);
     end
     else
     begin
      SizC := 0;
      ProjectIcon [Tmp].Compres := 0;
     end;
    end;
   end;
  end;
 end;
 DisplayInformation;
end;

(* Document Add button *)
procedure TPrincipale.btAppsAddClick(Sender: TObject);
var Tmp : integer;
    Nam : string [12];
    Pat : string [79];
begin
 DisplayHistory ('Add a new document');
 ChooseDialog.InitialDir := ProjectTarg + ':' + ProjectDire;
 If ChooseDialog.Execute then
 begin
  Pat := ChooseDialog.FileName;
  while pos ('\',Pat) <> 0 do Delete (Pat,1,pos ('\',Pat));
  Nam := Pat;
  Pat := copy (ChooseDialog.FileName,3,
               Length (ChooseDialog.FileName) - Length (Nam) - 3);
  if (Nbr_Apps + 1) < max_apps then
  begin
   Inc (Nbr_Apps);
   With ProjectApps [Nbr_Apps] do
   begin
    Executa.Name := Exe_Note;
    Executa.Path := '%W';
    Executa.Size := 0;
    Documen.Name := Nam;
    if Pat = ProjectDire then Documen.Path := '%1'
                         else Documen.Path := Pat;
    Documen.Size := 0;
    Descrip.Icon := '';
   end;
   DisplayInformation;
  end
  else
   MessageDlg ('Maximum of document reach',mtError,[mbok],0);
 end;
end;

(* Document Sub button *)
procedure TPrincipale.btAppsSubClick(Sender: TObject);
var Tmp : integer;
    Bcl : integer;
begin
 DisplayHistory ('Substract a document');
 Transfert.Siz := 3;
 FileChoose.ShowModal;
 Tmp := Transfert.Res;
 if Tmp <> 0 then
 begin
  if Nbr_Apps > 1 then
  begin
   for Bcl := Tmp to (Nbr_Apps - 1) do
    ProjectApps [Bcl] := ProjectApps [Bcl + 1];
  end;
  With ProjectApps [Nbr_Apps] do
  begin
   Executa.Name := '';
   Executa.Path := '';
   Executa.Size := 0;
   Documen.Name := '';
   Documen.Path := '';
   Documen.Size := 0;
   Descrip.Icon := '';
  end;
  Dec (Nbr_Apps);
 end;
 DisplayInformation;
end;

(* Document Check Button *)
procedure TPrincipale.btAppsChkClick(Sender: TObject);
var Tmp : integer;
    Tp1 : integer;
begin
 DisplayHistory ('Modify a document');
 GetInformation;
 Transfert.Siz := 3;
 FileChoose.ShowModal;
 Tmp := Transfert.Res;
 if Tmp <> 0 then
 begin
  with Transfert do
  begin
   Res := 3;
   Nom := ProjectApps [Tmp].Documen.Name;
   Pat := ProjectApps [Tmp].Documen.Path;
   Siz := 0;
   Ico := ProjectApps [Tmp].Descrip.Icon;
   if ProjectApps [Tmp].Executa.Name = Exe_Note then Exe := 1
   else
   begin
    if ProjectApps [Tmp].Executa.Name = Exe_Writ then Exe := 2
    else
    begin
     if ProjectApps [Tmp].Executa.Name = Exe_Rebo then Exe := 3;
    end;
   end;
  end;
  if CheckD.ShowModal = 1 then
  begin
   With Transfert do
   begin
    ProjectApps [Tmp].Documen.Name := Nom;
    ProjectApps [Tmp].Documen.Path := Pat;
    ProjectApps [Tmp].Documen.Size := 0;
    ProjectApps [Tmp].descrip.Icon := Ico;
    Case Exe of
     1 : ProjectApps [Tmp].Executa.Name := Exe_Note;
     2 : ProjectApps [Tmp].Executa.Name := Exe_Writ;
     3 : ProjectApps [Tmp].Executa.Name := Exe_Rebo;
    end;
    ProjectApps [Tmp].executa.Path := '%W';
    ProjectApps [Tmp].Executa.Size := 0;
   end;
  end;
 end;
end;

(* modifications *)
procedure TPrincipale.Modification(Sender: TObject);
begin
 Modificatio := True;
 GetInformation;
end;

end.
