unit Dcheck;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls,SysUtils,Dialogs;

type
  TCheckD = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    TitName: TLabel;
    DialName: TEdit;
    TitPath: TLabel;
    DialPath: TEdit;
    DialDire: TComboBox;
    TitSize: TLabel;
    DialSize: TEdit;
    Label1: TLabel;
    Bevel2: TBevel;
    Exe_Apps: TComboBox;
    Label2: TLabel;
    procedure CancelBtnClick(Sender: TObject);
    procedure Initialse(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure Affiche(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  CheckD: TCheckD;

implementation

uses decla,disque;

{$R *.DFM}

(* initialisation *)
procedure TCheckD.Initialse(Sender: TObject);
var Tmp : string;
begin
 Exe_Apps.Visible := True;
 Exe_Apps.Enabled := True;
 Exe_Apps.Clear;
 Exe_Apps.Items.Add (Exe_Note);
 Exe_Apps.Items.Add (Exe_Writ);
 Exe_Apps.Items.Add (Exe_Rebo);
 Exe_Apps.ItemIndex := Transfert.Exe - 1;
 DialDire.Clear;
 DialDire.Items.Add (Tit_App);
 DialDire.Items.Add (Tit_Win);
 DialDire.Items.Add (Tit_Sys);
 DialDire.Items.Add (Tit_Oth);
 if Transfert.Pat = '%1' then
 begin
  DialPath.Text := ProjectDire;
  DialDire.ItemIndex := 0;
  Transfert.Typ := 1;
 end
 else
 begin
  if Transfert.Pat = '%W' then
  begin
   Tmp := Windir; Delete (Tmp,1,2);
   DialPath.Text := Tmp;
   DialDire.ItemIndex := 1;
   Transfert.Typ := 2;
  end
  else
  begin
   if Transfert.Pat = '%S' then
   begin
    Tmp := Sysdir; Delete (Tmp,1,2);
    DialPath.Text := Tmp;
    DialDire.ItemIndex := 2;
    Transfert.Typ := 3;
   end
   else
   begin
    DialPath.Text := Transfert.Pat;
    DialDire.ItemIndex := 3;
    Transfert.Typ := 4;
   end;
  end;
 end;
 DialName.Text := Transfert.Nom;
 DialSize.Text := IntToStr (Transfert.Siz);
 Case Transfert.Typ of
  1 : DialDire.Text := Tit_App;
  2 : DialDire.Text := Tit_Win;
  3 : DialDire.Text := Tit_Sys;
  4 : DialDire.Text := Tit_Oth;
 end;
end;

(* button Cancel *)
procedure TCheckD.CancelBtnClick(Sender: TObject);
begin
 ModalResult := 2;
end;

(* button ok *)
procedure TCheckD.OKBtnClick(Sender: TObject);
var Err : integer;
begin
 if Exe_Apps.ItemIndex = -1 then
 begin
  ModalResult := 0;
  MessageDlg ('You must specify an application for document',
              mtInformation,[mbok],0);
 end
 else
 begin
  Transfert.Exe := Exe_Apps.ItemIndex  + 1;
  Transfert.Nom := DialName.Text;
  val (DialSize.Text,Transfert.Siz,Err);
  Transfert.Typ := DialDire.ItemIndex + 1;
  Case Transfert.Typ of
   1 : Transfert.Pat := '%1';
   2 : Transfert.Pat := '%W';
   3 : Transfert.Pat := '%S';
   4 : Transfert.Pat := DialPath.Text;
  end;
  ModalResult := 1;
 end;
end;

(* change directory *)
procedure TCheckD.Affiche(Sender: TObject);
var Tmp : string;
begin
 Case DialDire.ItemIndex of
  0 : begin
       DialPath.Text := ProjectDire;
       Transfert.Typ := 1;
      end;
  1 : begin
       Tmp := WinDir; Delete (Tmp,1,2);
       DialPath.Text := Tmp;
       Transfert.Typ := 2;
      end;
  2 : begin
       Tmp := SysDir; Delete (Tmp,1,2);
       DialPath.Text := Tmp;
       Transfert.Typ := 3;
      end;
  3 : begin
       DialPath.Text := Transfert.Pat;
       Transfert.Typ := 4;
      end;
 end;
end;

end.
