unit Dchoose;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls;

type
  TFileChoose = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Liste: TListBox;
    Label1: TLabel;
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure Initialise(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FileChoose: TFileChoose;

implementation

uses Decla;

{$R *.DFM}

(* cancel button *)
procedure TFileChoose.CancelBtnClick(Sender: TObject);
begin
 Transfert.Res := 0;
 Close;
end;

(* OK button *)
procedure TFileChoose.OKBtnClick(Sender: TObject);
begin
 if Liste.ItemIndex <> -1 then
 begin
  Transfert.Res := Liste.ItemIndex + 1;
  Close;
 end;
end;

(* initialise windows *)
procedure TFileChoose.Initialise(Sender: TObject);
var Bcl : integer;
begin
 Liste.Clear;
 Case Transfert.Siz of
  1 : begin
       if Nbr_Files > 0 then
       begin
        for Bcl := 1 to Nbr_Files do
        begin
         With ProjectFile [Bcl] do
          Liste.Items.Add (Fichier.Name);
        end;
       end;
       FileChoose.Caption := 'Choose a file';
      end;
  2 : begin
       if Nbr_Icons > 0 then
       begin
        for Bcl := 1 to Nbr_Icons do
        begin
         With ProjectIcon [Bcl] do
          Liste.Items.Add (Fichier.Name);
        end;
       end;
       FileChoose.Caption := 'Choose an icon';
      end;
  3 : begin
       if Nbr_Apps > 0 then
       begin
        for Bcl := 1 to Nbr_Apps do
        begin
         With ProjectApps [Bcl] do
          Liste.Items.Add (Documen.Name);
        end;
       end;
       FileChoose.Caption := 'Choose a document';
      end;
  end;
end;

end.
