(***********************)
(* managment of dialog *)
(***********************)
unit Routines;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, FileCtrl, DdeMan,ShellApi,
  Gauges,IniFiles;

type
  TDialogue = class(TForm)
    DestDrive: TDriveComboBox;
    TitDrive: TLabel;
    TitPath: TLabel;
    Chemin : TEdit;
    Bevel2 : TBevel;
    btInst : TBitBtn;
    btStop : TBitBtn;
    Bevel3 : TBevel;
    WhatUp : TMemo;
    DDEClient: TDdeClientConv;
    Label1: TLabel;
    Bevel1: TBevel;
    Gauge: TGauge;
    InstByte: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel4: TBevel;
    HardDisk: TLabel;
    procedure btInstClick(Sender: TObject);
    procedure btStopClick(Sender: TObject);
    procedure Initialisation(Sender: TObject);
    procedure ChangeDsk(Sender: TObject);
  private
    { Private-dclarations }
    function  UnInstall (Number : integer;StrLine : string) : integer;
    function  PickShell : string;
    function  CreationGroupe (FileName,GroupName : string) : integer;
    function  CreationIcone (FileName,IconName : string) : integer;
    function  ProcCopyFiles : integer;
    function  ProcCopyIcons : integer;
    function  ProcCreateGroupIcon : integer;
    procedure ProcLauchApp;
  public
    { Public-dclarations }
  end;

var Dialogue: TDialogue;

implementation

uses Decla,Lecture,Disque,UInfo,UFond;

{$R *.DFM}

(****************************)
(* record of uninstall file *)
(****************************)
function TDialogue.UnInstall (Number : integer;StrLine : string) : integer;
var Tmp : integer;
    Fch : System.Text;
begin
 Tmp := 0;
 System.Assign (Fch,VPath [2].LettDriv + ':' + VPath [2].PathDriv + '\' +
                    Fch_UnIns + 'INS');
 {$I-}; Append (Fch); {$I+};
 if IoResult = 0 then
 begin
  Writeln (Fch,Number,',',StrLine);
  System.Close (Fch);
 end
 else
 begin
  {$I-}; Rewrite (Fch); {$I+};
  if IoResult = 0 then
  begin
   Writeln (Fch,Number,',',StrLine);
   System.Close (Fch);
  end
  else
   Tmp := 1;
 end;
 UnInstall := Tmp;
end;

(***********************************)
(* pick up current shell of system *)
(***********************************)
function TDialogue.PickShell : string;
var SystemIni: TIniFile;
    ShellSyst : string;
begin
 ShellSyst := '';
 SystemIni := TIniFile.Create('System.ini');
 with SystemIni do
 begin
  ShellSyst := ReadString('Boot', 'Shell', 'ERROR');
 end;
 SystemIni.Free;
 PickShell := ShellSyst;
end;

(********************)
(* create one group *)
(********************)
function TDialogue.CreationGroupe (FileName,GroupName : string) : integer;
var Tmp : integer;
    Macro : string;
    Cmd   : array [0 .. 255] of Char;
    lgn   : string;
begin
 Tmp := 0;
 if GroupName = '' then
  Tmp := 1
 else
 begin
  Lgn := GroupName + ',' + FileName;
  Macro := Format('[CreateGroup(%s)]', [Lgn]) + #13#10;
  StrPCopy (Cmd, Macro);
  DDEClient.ConnectMode := DDEAutomatic;
  if DDEClient.SetLink('PROGMAN','PROGMAN') = true then
  begin
   if not DDEClient.ExecuteMacro(Cmd, False) then
    Tmp := 2;
   DDEClient.CloseLink;
  end
  else
   Tmp := 3;
 end;
 CreationGroupe := Tmp;
end;

(*******************)
(* create one icon *)
(*******************)
function TDialogue.CreationIcone (FileName,IconName : string) : integer;
var Tmp : integer;
    Macro : string;
    Cmd   : array [0 .. 255] of Char;
    lgn   : string;
begin
 Tmp := 0; 
 if FileName = '' then
  Tmp := 1
 else
 begin
  Lgn := FileName + ',' + '"' + IconName + '",';
  Macro := Format('[AddItem(%s,%d)]', [Lgn,0]) + #13#10;
  StrPCopy (Cmd, Macro);
  DDEClient.ConnectMode := DDEAutomatic;
  if DDEClient.SetLink('PROGMAN','PROGMAN') = true then
  begin
   if not DDEClient.ExecuteMacro(Cmd, False) then
    Tmp := 2;
   DDEClient.CloseLink;
  end
  else
   Tmp := 3;
 end;
 CreationIcone := Tmp;
end;

(**************)
(* copy files *)
(**************)
function TDialogue.ProcCopyFiles : integer;
var Bcl : integer;
    FrF : string;
    ToF : string;
    Tmp : integer;
    Tp1 : integer;
    Com : string;
begin
 Tmp := 0;
 if Number_Files > 0 then
 begin
  for Bcl := 1 to Number_Files do
  begin
   if Tmp = 0 then
   begin
    (* check disk *)
    repeat
     if CheckDsk (VPath [1].LettDriv + ':' + VPath [1].PathDriv,
                  VFiles [Bcl].DiskNumb) = 1 then
     begin
      Tp1 := MessageDlg ('Please insert disk #' +
                         IntToStr (VFiles [Bcl].DiskNumb),
                         mtInformation,[mbOk,mbCancel],0);
      if Tp1 = mrCancel then begin Tmp := 2; Tp1 := 2; end
                        else Tp1 := 0;
     end
     else
      Tp1 := 1;
    until Tp1 <> 0;
    if Tp1 = 1 then
    (* copy file *)
    begin
     (* set path,source and target *)
     if VFiles [Bcl].FilePath = '%1' then
      VFiles [Bcl].FilePath := VPath [2].LettDriv + ':' + VPath [2].PathDriv;
     FrF := VPath [1].LettDriv + ':' + VPath [1].PathDriv +
            VFiles [Bcl].FileName;
     ToF := VFiles [Bcl].FilePath + '\' + VFiles [Bcl].FileName;
     WhatUp.Lines.Add ('Copy from ' + FrF + ' to ' + ToF);
     Screen.Cursor := crHourGlass;
     if CopyFile (FrF,ToF,VFiles [Bcl].Compress,3) <> 0 then
     (* problem during copy *)
      Tmp := 1
     else
      UnInstall (1,ToF);
     Gauge.Progress := Gauge.Progress + 1;
     Screen.Cursor := crDefault;
    end
    else
    (* wrong disk in drive *)
     Tmp := 3;
   end;
  end;
 end;
 ProcCopyFiles := Tmp;
end;

(********************)
(* copy icons files *)
(********************)
function TDialogue.ProcCopyIcons : integer;
var Bcl : integer;
    FrF : string;
    ToF : string;
    Tmp : integer;
    Tp1 : integer;
begin
 Tmp := 0;
 if Number_Icons > 0 then
 begin
  for Bcl := 1 to Number_Icons do
  begin
   repeat
    if CheckDsk (VPath [1].LettDriv + ':' + VPath [1].PathDriv,
                 VIcons [Bcl].DiskNumb) = 1 then
    begin
     Tp1 := MessageDlg ('Please insert disk #' +
                        IntToStr (VFiles [Bcl].DiskNumb),
                        mtInformation,[mbOk,mbCancel],0);
     if Tp1 = mrCancel then Tp1 := 2
                       else Tp1 := 0;
    end
    else
     Tp1 := 1;
   until Tp1 <> 0;
   if Tp1 = 1 then
   begin
    (* set path,source and target *)
    if VIcons [Bcl].FilePath = '%1' then
     VIcons [Bcl].FilePath := VPath [2].LettDriv + ':' + VPath [2].PathDriv;
    FrF := VPath [1].LettDriv + ':' + VPath [1].PathDriv +
           VIcons [Bcl].FileName;
    ToF := VIcons [Bcl].FilePath + '\' + VIcons [Bcl].FileName;
    WhatUp.Lines.Add ('Copy from ' + FrF + ' to ' + ToF);
    Screen.Cursor := crHourGlass;
    if CopyFile (FrF,ToF,VIcons [Bcl].Compress,3) <> 0 then
    (* problem during copy *)
     Tmp := 1
    else
     UnInstall (1,ToF);
    Gauge.Progress := Gauge.Progress + 1;
    Screen.Cursor := crDefault;
   end
   else
   (* wrong disk in drive *)
    Tmp := 3;
  end;
 end;
 ProcCopyIcons := Tmp;
end;

(*************************)
(* create group and icon *)
(*************************)
function TDialogue.ProcCreateGroupIcon : integer;
var Bcl : integer;
    Ico : string;
    Tmp : integer;
    Tp1 : integer;
begin
 Tmp := 0;
 (* create group *)
 if Number_Group > 0 then
 begin
  for Bcl := 1 to Number_Group do
  begin
   WhatUp.Lines.Add ('Create group ' + VGroup [Bcl].GroupName);
   Tp1 := CreationGroupe (VGroup [Bcl].GroupFile,VGroup [Bcl].GroupName);
   Case Tp1 of
    1 : WhatUp.Lines.Add ('Group name is needed');
    2 : WhatUp.Lines.Add ('Problem(s) with Program Manager');
    3 : WhatUp.Lines.Add ('Unable to lauch Program Manager');
   else
    UnInstall (2,VGroup [Bcl].GroupName);
   end;
   if Tp1 <> 0 then Tmp := 4;
  end;
 end;
 (* create icons *)
 if Tmp = 0 then
 begin
  if Number_Icons > 0 then
  begin
   for Bcl := 1 to Number_Icons do
   begin
    Ico := VIcons [Bcl].FilePath + '\' + VIcons [Bcl].FileName;
    WhatUp.Lines.Add ('Create icon ' + VIcons [Bcl].IconName);
    Tp1 := CreationIcone (Ico,VIcons [Bcl].IconName);
    Case Tp1 of
     1 : WhatUp.Lines.Add ('File name is needed');
     2 : WhatUp.Lines.Add ('Problem(s) with Program Manager');
     3 : WhatUp.Lines.Add ('Unable to lauch Program Manager');
    end;
    if Tp1 <> 0 then Tmp := 5;
   end;
  end;
 end;
 ProcCreateGroupIcon := Tmp;
end;

(*********************)
(* lauch application *)
(*********************)
procedure TDialogue.ProcLauchApp;
var Bcl : integer;
    App : string;
begin
 if Number_Run > 0 then
 begin
  for Bcl := 1 to Number_Run do
  begin
   if VRun [Bcl].FilePath = '%1' then
    VRun [Bcl].FilePath := VPath [2].LettDriv + ':' + VPath [2].PathDriv;
   if VRun [Bcl].DocsPath = '%1' then
    VRun [Bcl].DocsPath := VPath [2].LettDriv + ':' + VPath [2].PathDriv;
   App := VRun [Bcl].DocsPath + '\' + VRun [Bcl].DocsName;
   StartApp (VRun [Bcl].FileName,App,VRun [Bcl].FilePath);
  end;
 end;
end;

(******************)
(* install button *)
(******************)
procedure TDialogue.btInstClick(Sender: TObject);
var Bcl : integer;
    FrF : string;
    ToF : string;
    Tmp : integer;
    Tp1 : integer;
begin
 WhatUp.Lines.Add ('Installation of ' + Title + ' starting');
 Error := 0;
 (* set new user path *)
 VPath [2].LettDriv := DestDrive.Drive;
 VPath [2].PathDriv := Chemin.Text;
 (* desactivate all exept cancel button *)
 TitDrive.Enabled := false;
 DestDrive.Enabled := false;
 TitPath.Enabled := false;
 Chemin.Enabled := false;
 btInst.Enabled := false;
 WhatUp.Enabled := false;
 if Disk_Space >= DiskFree (ord (DestDrive.Drive) - 64) then Error := 2;
 (* installation script *)
 if Error = 0 then
 begin
  if CreateDirectory (VPath [2].LettDriv + ':' + VPath [2].PathDriv) = 1 then
   WhatUp.Lines.Add ('Unable to create the directory')
  else
   UnInstall (0,VPath [2].LettDriv + ':' + VPath [2].PathDriv);
  if Error = 0 then Error := ProcCopyFiles;
  if Error = 0 then Error := ProcCopyIcons;
  ProcCreateGroupIcon;
 end;
 (* conclusion *)
 if Error = 0 then
 begin
  WhatUp.Lines.Add ('Installation of ' + Title + ' successfull');
  btStop.Enabled := false;
  Info.ShowModal;
  ProcLauchApp;
  Fond.Close;
 end
 else
 begin
  WhatUp.Lines.add ('Installation of ' + Title + ' unsuccessfull');
  Case Error of
   1 : WhatUp.Lines.add ('because problem when copying file(s)');
   2 : WhatUp.Lines.add ('because not enought drive space');
   3 : WhatUp.Lines.add ('because wrong disk in drive');
   4 : WhatUp.Lines.add ('because unable to create group(s)');
   5 : WhatUp.Lines.add ('because unable to create icon(s)');
   6 : WhatUp.Lines.add ('because install file is corrupt');
  end;
  btInst.Enabled := true;
 end;
end;

(* update Hard Disk information *)
procedure TDialogue.ChangeDsk(Sender: TObject);
var Tmp : Longint;
    Tm1 : string;
begin
 Tmp := DiskFree (ord (DestDrive.Drive) - 64);
 Str ((Tmp / One_Meg):8:3,Tm1);
 HardDisk.Caption := Tm1;
end;

(*****************)
(* cancel button *)
(*****************)
procedure TDialogue.btStopClick(Sender: TObject);
begin
 if btInst.Enabled = false then
  WhatUp.Lines.Add ('Installation cancelled by user');
 Fond.Close;
end;

(* dialog initialisation *)
procedure TDialogue.Initialisation(Sender: TObject);
var erreur : integer;
    lerror : string;
    Bcl : LongInt;
    Icr : integer;
    Rec : TRect;
    Tmp : string;
    Tm1 : longint;
begin
 (* variables iniialisation *)
 WhatUp.Clear;
 Chemin.Text := '';
 btInst.Enabled := false;
 Screen.Cursor := crHourGlass;
 (* read install file *)
 LError := '';
 Erreur := ReadInsFile;
 case Erreur of
  01 : LError := 'Unable to find install file (.INS)';
  02 : LError := 'Unable to open install file';
  03 : LError := 'Unable to read one line of install file';
  04 : LError := 'Wrong paragraph name';
  05 : LError := 'Wrong line because = sign is needed';
  06 : LError := 'Wrong line because Unable to find paragraph';
  07 : LError := 'Wrong line in Mauvaise ligne dans le paragraphe INFORMATION';
  08 : LError := 'Wrong line in DISKS paragraph';
  09 : LError := 'Wrong line in ORIGIN paragraph';
  10 : LError := 'Wrong line in DESTINATION paragraph';
  11 : LError := 'Wrong line in GROUP paragraph';
  12 : LError := 'Wrong line in ICONS paragraph';
  13 : LError := 'Wrong line in FILES paragraph';
  14 : LError := 'Wrong line in RUN paragraph';
  15 : LError := 'NUM parameter is wrong';
  16 : LError := 'Number before = is wrong';
  17 : LError := 'Wrong parameter in GROUP line';
  18 : LError := 'Wrong parameter in ICONS line';
  19 : LError := 'Wrong parameter in FILES line';
  20 : LError := 'Wrong parameter in RUN line';
  21 : LError := 'Wrong parameter in DSK line';
 end;
 Screen.Cursor := crDefault;
 if LError <> '' then
 (* install file is wrong *)
  MessageDlg (LError,mtError,[mbok],0)
 else
 begin
  btInst.Enabled := true;
  Chemin.Text := VPath [2].PathDriv;
  DestDrive.Drive := VPath [2].LettDriv;
  Tm1 := DiskFree (ord (DestDrive.Drive) - 64);
  Str ((Tm1 / One_Meg):8:3,Tmp);
  HardDisk.Caption := Tmp + ' MB';
  Str ((Disk_Space / One_Meg):8:3,Tmp);
  InstByte.Caption := Tmp + ' MB';
  WhatUp.Lines.Add (Title + ' v ' + Version);
  WhatUp.Lines.Add (SubTitle);
  WhatUp.Lines.Add ('(c)' + Copyright + ' by ' + Author);
  WhatUp.Lines.Add ('');
  Gauge.MinValue := 0;
  Gauge.MaxValue := Number_Icons + Number_Files;
  Gauge.Progress := 0;
  Gauge.Font.Color := clBlack;
  Error := 0;
  Fond.Ecrit;
 end;
end;

end.

