(********************************)
(* global declaration for setup *)
(********************************)
unit Decla;

interface

const Max_Group = 01;
      Max_Files = 50;
      Max_Icons = 50;
      Max_Run   = 10;
      Max_Path  = 02;
      Max_Unin  = 50;
      Fch_UnIns = 'UNSETUP.';
      Fch_Ins   = 'SETUP.';

      (* vecteur des groupes *)
Type TVect_Group = record
                    GroupName : string [30];    (* Nom du groupe      *)
                    GroupFile : string [80];    (* Fichier de groupe  *)
                   end;
     (* vecteur des icones a creer *)
     TVect_Icons = record
                    DiskNumb : integer;         (* numero de disquette*)
                    FileName : string [12];     (* nom du fichier     *)
                    FilePath : string [80];     (* access au fichier  *)
                    IconName : string [30];     (* nom de l'icone     *)
                   end;
     (* vecteur des fichier a copier *)
     TVect_Files = record
                    DiskNumb : integer;         (* numero de disquette*)
                    FileName : string [12];     (* nom du fichier     *)
                    FilePath : string [80];     (* chemin destination *)
                   end;
     (* vecteurs des fichier a lancer *)
     TVect_Run =   record
                    FileName : string [12];     (* fichier a lancer   *)
                    FilePath : string [80];     (* chemin d'access    *)
                    DocsName : string [12];     (* document associe   *)
                    DocsPath : string [80];     (* chemin document    *)
                   end;
     (* vecteur des disques *)
     TVect_Path =  record
                    LettDriv : char;            (* la lettre lecteur  *)
                    PathDriv : string [80];     (* chemin lecteur     *)
                   end;
     (* vecteur pour la deinstallation *)
     TVect_Unins = record
                    TypeCase : integer;         (* 0:Dir 1:File 2:Grp *)
                    FullName : string [80];     (* Directory + Name   *)
                   end;

var VGroup : array [1 .. max_group] of TVect_Group;   (* les groupes    *)
    VIcons : array [1 .. max_icons] of TVect_Icons;   (* les icones     *)
    VFiles : array [1 .. max_files] of TVect_Files;   (* les fichiers   *)
    VRun   : array [1 .. max_run]   of TVect_Run;     (* les lancements *)
    VPath  : array [1 .. max_path]  of TVect_Path;    (* origine/desti. *)
    VUnins : array [1 .. max_Unin] of TVect_Unins;    (* desinstallation*)
    Title,SubTitle,Version,Author,Copyright : string; (* informations   *)
    Disk_Number  : integer;                           (* nbr de dsk < 2 *)
    Number_Group : integer;                           (* nbr de groupes *)
    Number_Icons : integer;                           (* nbr d'icones   *)
    Number_Files : integer;                           (* nbr de fichiers*)
    Number_Run   : integer;                           (* nbr de lance.  *)
    Error        : integer;                           (* <>0 err append *)
    UnSetupPath  : string;                            (* path to access *)

implementation

end.

