//----------------------------------------------------------------------------
// Miscellaneous internal definitions:
//----------------------------------------------------------------------------

enum
{
   m_initialize      = 0,
   m_show            = 1,
   m_hide            = 2,
   m_pos_and_buttons = 3
};

enum { mouse_int        = 0x0033 };
enum { existence_number = 0xFFFF };

//----------------------------------------------------------------------------
// Available to the user:
//----------------------------------------------------------------------------

#define            BUTTON_1  1
#define            BUTTON_2  2
#define            BUTTON_3  4

//----------------------------------------------------------------------------
// CLASS  mouse_t
//----------------------------------------------------------------------------

class              mouse_t
{
public:

   boolean         exists;
   int             x;
   int             y;
   int             buttons;  // Contains the bit fields named above;
                             // A one means the button is pressed.

   //-------------------------------------------------------------------------
   // FUNCTION  mouse_t::update
   //-------------------------------------------------------------------------

   inline void     update
   (
      void
   )
   {
      union REGS   regs;

      if ( ! exists )  return;

      regs.w.ax        = m_pos_and_buttons;

      int386 ( mouse_int, & regs, & regs );

      buttons = regs.w.bx;
      x       = regs.w.cx / 2;
      y       = regs.w.dx;
   }

   //-------------------------------------------------------------------------
   // FUNCTION  mouse_t::init
   //-------------------------------------------------------------------------

   inline void     init
   (
      void
   )
   {
      union REGS   regs;

      regs.w.ax = m_initialize;

      int386 ( mouse_int, & regs, & regs );

      if ( regs.w.ax == existence_number )
      {
         exists = true;

         update ();
      }
      else
      {
         exists = false;
      }
   }
};

//----------------------------------------------------------------------------
// The mouse object.
//----------------------------------------------------------------------------

extern mouse_t     mouse;
