/******************* ( Animation Construction Kit 3D ) ***********************/
/*			     Global Data				     */
/* CopyRight (c) 1993	   Author: Lary Myers				     */
/*****************************************************************************/
#include <stdio.h>
#include "ack3d.h"
#include "ackeng.h"

/*****************************************************************************
    The four variables below are used by ACKRAY and ACKVIEW and are somewhat
misleading. They are held over from older versions of the engine where the
accuracy of the ray-casting routine was still being determined. What happens
is that LastX1 was a long and iLastX use to be an integer. It was later
determined that they both needed to be longs to give better accuracy. The xRay
routine use to set LastY1 to the Y value of an intersection and iLastX to the
X value of the intersection with a wall. The yRay routine would set LastX1 and
iLastY to the wall intersection.
******************************************************************************/
	long	    LastX1;
	long	    LastY1;
	long	    iLastX;
	long	    iLastY;

	int	    MaxDistance;    /* Max dist achieved on last ray-cast */

	int	    ErrorCode;	    /* Global error set by various routines */

	int	    xMapPosn;	    /* Map posn of intersect by xRay routine */
	int	    yMapPosn;	    /* map pons of intersect by yRay routine */

	UINT  far   *Grid;	    /* Contains the wall map array */
	UINT  far   *ObjGrid;	    /* Holds object array when map read in */

	UCHAR far   *BitmapXferPtr; /* Used by XMS to hold real buffer ptr */
	int	    UseXMS;
	XARRAY	    xArray[MAX_XARRAY]; /* Holds current bitmaps in real mem */

	SPECIALCODE SpecialCodes[MAX_UPDOWN+1]; /* Special map codes */

	int	    TotalSpecial;

	int	    DistanceTable[MAX_DISTANCE+1];  /* Used in ray calc's */
	long  far   *AdjustTable;		/* Used in object calc's */

	WALLARRAY   Walls[VIEW_WIDTH];	    /* Walls in current POV */

	int	    xSecretmPos;	/* Secret door currently opening */
	int	    xSecretmPos1;
	int	    xSecretColumn;

	int	    ySecretmPos;	/* Secret door currently opening */
	int	    ySecretmPos1;
	int	    ySecretColumn;

	int	    TotalSecret;
	int	    ViewColumn;

	long far    *SinTable;
	long far    *CosTable;

	long far    *LongTanTable;
	long far    *LongInvTanTable;
	long far    *InvCosTable;
	long far    *InvSinTable;
	long far    *LongCosTable;
	long far    *ViewCosTable;

	long far    *xNextTable;    /* Pre-calc'd amount of next X posn */
	long far    *yNextTable;    /* Pre-calc'd amount of next Y posn */

	int	    LastMapPosn;    /* Set for the calling application */
	int	    LastObjectHit;  /* Set for the calling application */
	int	    TotalObjects;

/* The following object variables are used when objects are found in the */
/* current POV. They are built for later display of the objects.	 */
	UCHAR	    ObjNumber[MAX_OBJECTS+1];
	long	    ObjRelDist[MAX_OBJECTS+1];
	long	    ObjDeltaX[MAX_OBJECTS+1];
	long	    ObjDeltaY[MAX_OBJECTS+1];


	UCHAR	    LightMap[GRID_MAX]; /* Not currently used */
	UCHAR	    WorkPalette[768];	/* Used for light shading */

