#include "ray.h"
#include "globals.h"
#include "rayfile.h"
#include "bspmove.h"
#include "blockbsp.h"
#include "maxmins.h"

typedef struct BSP_BLOCK {
   long base_x, base_y, size_x, size_y;
   USHORT x_block_count, y_block_count;
   PLONG * blocks;
   } bsp_block;

BOOL block_bsp_loaded=FALSE;
bsp_block block_bsp;

/*
   Generate_BSP_Block
   Calculates the block_bsp data structure, used to speed up sprite calculations
   Notes: Requires that a world is loaded to run
*/

void Generate_BSP_Block()
{
   // Tell rest of program we do now have a bsp block

   block_bsp_loaded = TRUE;

   long min_x, min_y, max_x, max_y, range_x, range_y;

   Get_Map_Max_Mins(min_x, min_y, max_x, max_y);

   // Get block range

   range_x=max_x-min_x;
   range_y=max_y-min_y;

   // Save info on block table

   block_bsp.base_x=min_x;
   block_bsp.base_y=min_y;

   block_bsp.size_x=range_x;
   block_bsp.size_y=range_y;

   block_bsp.x_block_count=range_x >> BLOCK_BSP_SHIFT;
   block_bsp.y_block_count=range_y >> BLOCK_BSP_SHIFT;

   // loop through blocks in block table, saving smallest node in each block

   short cur_block_x, cur_block_y, x1, x2, y1, y2;
   PLONG cur_run;

   block_bsp.blocks=(PLONG *)NewPtr(sizeof(PLONG) * block_bsp.x_block_count);
   for (cur_block_x=0; cur_block_x<block_bsp.x_block_count; cur_block_x++) {
      x1=block_bsp.base_x+(cur_block_x<<BLOCK_BSP_SHIFT);
      x2=x1+BLOCK_BSP_SIZE;
      block_bsp.blocks[cur_block_x]=(PLONG)NewPtr(sizeof(LONG) * block_bsp.y_block_count);
      cur_run=block_bsp.blocks[cur_block_x];
      for (cur_block_y=0; cur_block_y< block_bsp.y_block_count; cur_block_y++) {
         y1=block_bsp.base_y+(cur_block_y<<BLOCK_BSP_SHIFT);
         y2=y1+BLOCK_BSP_SIZE;
         cur_run[cur_block_y]=Box_Smallest_Node(x1,x2,y1,y2);
      } /* endfor */
   } /* endfor */

}

void Clear_BSP_Block()
{
   if (!block_bsp_loaded) {
      return;
   } /* endif */
   for (short cur_block_x=0; cur_block_x< block_bsp.x_block_count; cur_block_x++) {
      DelPtr( block_bsp.blocks[cur_block_x]);
   } /* endfor */
   DelPtr( block_bsp.blocks);
   block_bsp_loaded=FALSE;
}

BOOL Block_BSP_Is_Loaded() {
   return block_bsp_loaded;
}

long Block_BSP_X_Start() {
   return block_bsp.base_x;
}

long Block_BSP_Y_Start() {
   return block_bsp.base_y;
}

USHORT Block_BSP_Max_X() {
   return block_bsp.x_block_count;
}

USHORT Block_BSP_Max_Y() {
   return block_bsp.y_block_count;
}

long Get_Block_Node(USHORT block_x, USHORT block_y)
{
   PLONG cur_run=block_bsp.blocks[block_x];
   return cur_run[block_y];
}

long Get_Closest_Node(long x, long y) {

long starting_node_index;

if (Block_BSP_Is_Loaded()) {

   long block_bsp_x, block_bsp_y;

   block_bsp_x=((x>>SHIFT) - Block_BSP_X_Start()) >> BLOCK_BSP_SHIFT;
   block_bsp_y=((y>>SHIFT) - Block_BSP_Y_Start()) >> BLOCK_BSP_SHIFT;

   // Is the sprite in a block for which we have a starting index?

   if ( (block_bsp_x>=0) && (block_bsp_x<Block_BSP_Max_X())
      && (block_bsp_y>=0) && (block_bsp_y<Block_BSP_Max_Y()) )

      starting_node_index=Get_Block_Node(block_bsp_x, block_bsp_y);

   else starting_node_index=bsp_start_node;

} else starting_node_index=bsp_start_node;

return starting_node_index;
}
