#include "assert.h"
#include "ray.h"
#include "globals.h"
#include "message.h"
#include "damage.h"
#include "visuals.h"
#include "sprinter.h"

void Give_Damage(pobject the_obj, short amount) {
   if (the_obj->stats.current_health>0) {
      the_obj->stats.current_health-=amount;
      if (the_obj==the_player) {
        Visuals_Message(HURT_MESSAGE, (pdata)amount);
      }
      if (the_obj->stats.current_health<=0) {
         if (the_obj==the_player) {
           Create_Object(the_player->x, the_player->y,
             the_player->z, the_player->angle, EXPLOSION_TYPE,
             the_player->owner, the_player->team);
           Visuals_Message(VIS_DIE_MSG, NULL);
         } else Send_Specific_Message(NULL, the_obj, DIE_MESSAGE, NULL);
      }
   }
}

