#include "ray.h"
#include "globals.h"
#include "rayspr.h"
#include "sprfunc.h"
#include "defobj.h"
#include "rayfile.h"
#include "collisio.h"
#include "message.h"
#include "objcol.h"
#include "sfvars.h"
#include "sprtypes.h"
#include "sprswtch.h"

typedef struct DEF_OBJ_EXTRA * pdef_obj_extra;
typedef struct DEF_OBJ_EXTRA {
  long turn_speed;
  long dz;
  long change_time;
  } def_obj_extra;

void Def_Obj_Update(pobject cur_obj, long update_num);
void Def_Obj_Update_Z(pobject cur_obj, psector new_sec);
void Def_Obj_Load_Extra(pobject cur_obj, long offset);
ULONG Default_Message(pobject send_obj, pobject receive_obj, ULONG message, pdata extra_data);

void Init_Def_Obj(func_index index)
{
update_funcs[index]=Def_Obj_Update;
update_z_funcs[index]=Def_Obj_Update_Z;
load_extra_funcs[index]=Def_Obj_Load_Extra;
message_funcs[index]=Default_Message;
}

void Def_Obj_Update(pobject cur_obj, long update_num)
{
pdef_obj_extra cur_extra=(pdef_obj_extra)cur_obj->extra_data;
if (!(cur_extra->change_time & update_num)) {
  cur_extra->dz*=-1;
  }
cur_obj->z+=cur_extra->dz;
cur_obj->angle=Get_Angle_Sum(cur_obj->angle, cur_extra->turn_speed);
}

void Def_Obj_Update_Z(pobject cur_obj, psector new_sec)
{
}

void Def_Obj_Load_Extra(pobject cur_obj, long offset)
{

pdef_obj_extra new_extra;
new_extra=(pdef_obj_extra)NewPtr(sizeof(def_obj_extra));

if (offset!=BAD_LOAD_OFFSET) {
   F_Seek(offset);
   F_Get_Long(new_extra->turn_speed);
   F_Get_Long(new_extra->dz);
   F_Get_Long(new_extra->change_time);
} else {
   new_extra->turn_speed=0;
   new_extra->dz=0;
   new_extra->change_time=0;
}

cur_obj->extra_data=(pdata)new_extra;
}

ULONG Default_Message(pobject send_obj, pobject receive_obj, ULONG message, pdata extra_data) {
   switch (message) {
   case WALL_COLLISION:
      return Do_Slide_Wall(receive_obj, (pwall_collision_info)extra_data);
   case HIT_OBJ:
      Slide_Obj(receive_obj, (pobj_collision)extra_data);
      return NORMAL_MESSAGE;
   case DIE_MESSAGE:
      Switch_Object_Types(receive_obj, Obj_Type_List+EXPLOSION_TYPE);
      return NORMAL_MESSAGE;
   default: 
     return NORMAL_MESSAGE;
   } /* endswitch */
}
