/********************************************************************
 FILENAME: DOOM.H
 AUTHOR  : JAKE HILL
 DATE    : 12/1/94

 Copyright (c) 1994 by Jake Hill:
 If you use any part of this code in your own project, please credit
 me in your documentation and source code.  Thanks.
********************************************************************/

#ifndef DOOM_H
#define DOOM_H

#define DM_ANGLE_360 65536

#define DM_THING_ANG_CONV (ANGLE_360 << SHIFT / 360)
#define PLAYER_START 0x0001
#define DM_DEF_TEX 1

typedef struct
        {
           short x;
           short y;
        } dm_vertex;

typedef struct
        {
           short from, to;
           short flags, special, tag;
           short side[2];
        } dm_line;

typedef struct
        {
           short tm_xoffset, tm_yoffset;
           char upper_tx[8];
           char lower_tx[8];
           char main_tx[8];
           short sector;
        } dm_side;

typedef struct
        {
           short floor_ht;
           short ceiling_ht;
           char  floor_tx[8];
           char  ceiling_tx[8];
           short light;
           short type;
           short trigger;
        } dm_sector;

typedef struct
        {
           short from, to;
           unsigned short angle;
           short line;
           short line_side;
           short line_offset;
        } dm_seg;

typedef struct
        {
           short num_segs;
           short first_seg;
        } dm_ssector;

typedef struct
        {
           short x, y;
           short dx, dy;
           short ry2,ry1,rx1,rx2;
           short ly2,ly1,lx1,lx2;
           unsigned short right,left;
        } dm_node;

typedef struct
        {
           short x, y;
           unsigned short angle;
           short thing_type;
           short attributes;
        } dm_thing;

typedef struct
        {
           short x_origin, y_origin;
           short columns, rows;
           short *blockpointers;
        } dm_blockmap_header;

typedef short blockmap;

#endif
