#include "ray.h"
#include "globals.h"
#include "voxel.h"
#include "waves.h"
#include <mem.h>

#define WATER_LEVEL 48

typedef struct VOX_WAVE_INFO * pvox_wave_info;

typedef struct VOX_WAVE_INFO {
  short y;
  short start_x, length;
  PUCHAR alt_array, color_array;
  } vox_wave_info;

inline BOOL Is_Water(short x, short y)
{
  if (alt_array[(y<<ALT_Y_SHIFT)+x]<WATER_LEVEL) {
    return TRUE;
  } else {
    return FALSE;
  }
}

inline long Go_To_End(short & x, short y)
{
long length=0;
while ((x<ALT_WIDTH)&&(Is_Water(x,y))) {
   x++;
   length++;
   }
return length;
}

pvox_wave_info waves;
long number_of_waves;

void Do_Waves() {

PUCHAR alt_base, col_base; 
long base_ptr;
UCHAR alt_temp, col_temp;

pvox_wave_info cur_wave;

for (short wave_index=0; wave_index<number_of_waves; wave_index++) {
  cur_wave=waves+wave_index;
  base_ptr=(cur_wave->y<<ALT_Y_SHIFT)+cur_wave->start_x;
  alt_base=cur_wave->alt_array+base_ptr;
  col_base=cur_wave->color_array+base_ptr;
  alt_temp=*(alt_base+(cur_wave->length-1));
  col_temp=*(col_base+(cur_wave->length-1));
  memmove(alt_base+1,alt_base,cur_wave->length-1); 
  memmove(col_base+1,col_base,cur_wave->length-1);
  *(alt_base)=alt_temp;
  *(col_base)=col_temp;
  }

}

void Close_Waves() {
  if (waves!=NULL)
     DelPtr(waves);
  }

void Setup_Waves() {
long temp_length;
short save_x;
short cur_x, cur_y;
short wave_index;
pvox_wave_info cur_wave;
short sec_index;

number_of_waves=0;
for (sec_index=0; sec_index<Number_Of_Sectors; sec_index++) {
   if (Sector_List[sec_index].flags & VOXEL_SECTOR) {
      alt_array=(PUCHAR)Sector_List[sec_index].extra_data;
      color_array=alt_array+ALT_TO_COL_DIFF;
      for (cur_y=0; cur_y<ALT_HEIGHT; cur_y++) {
         cur_x=0;
         while (cur_x<ALT_WIDTH) {
            if (Is_Water(cur_x, cur_y)) {
               temp_length=Go_To_End(cur_x, cur_y);
               if (temp_length>1)
                  number_of_waves++;
            }
            cur_x++;
         }
      }
   }
}

if (number_of_waves==0) {
   waves=NULL;
   return;
}

waves=(pvox_wave_info)NewPtr(number_of_waves*sizeof(vox_wave_info));

wave_index=0;
for (sec_index=0; sec_index<Number_Of_Sectors; sec_index++) {
   if (Sector_List[sec_index].flags & VOXEL_SECTOR) {
      alt_array=(PUCHAR)Sector_List[sec_index].extra_data;
      color_array=alt_array+ALT_TO_COL_DIFF;
      for (cur_y=0; cur_y<ALT_HEIGHT; cur_y++) {
         cur_x=0;
         while (cur_x<ALT_WIDTH) {
         if (Is_Water(cur_x, cur_y)) {
            save_x=cur_x;
            temp_length=Go_To_End(cur_x, cur_y);
            if (temp_length>1) {
               cur_wave=waves+wave_index;
               cur_wave->y=cur_y;
               cur_wave->start_x=save_x;
               cur_wave->length=temp_length;
               cur_wave->alt_array=alt_array;
               cur_wave->color_array=color_array;
               wave_index++;
            }
         }
         cur_x++;
         }
      }
   }
}
}
