#include "ray.h"
#include "globals.h"
#include "rayspr.h"
#include "sprfunc.h"
#include "sfvars.h"
#include "sound.h"

long explo_sound_id;

void Explosion_Create(pobject explo_obj, long extra_data_offset);
void Explosion_Update(pobject explo_obj, long update_num);

void Init_Explosion(func_index index) {
   explo_sound_id=Load_Sound("explo.wav");
   update_funcs[index]=Explosion_Update;
   load_extra_funcs[index]=Explosion_Create;
}

void Explosion_Create(pobject explo_obj, long extra_data_offset)
{
   PSHORT new_counter=(PSHORT)NewPtr(sizeof(SHORT));
   *(new_counter)=0;
   explo_obj->extra_data=(pdata)new_counter;
   Play_Sound(explo_sound_id);
}

void Explosion_Update(pobject explo_obj, long update_num)
{
   PSHORT cur_time=(PSHORT)explo_obj->extra_data;
   if (++(*cur_time)>=explo_obj->type->stats.base_speed) {
      (*cur_time)=0;
       if (++explo_obj->cur_frame==
          wall[explo_obj->type->frames[0]].num_image) {
             Kill_Object(explo_obj);
       }
   }
}

