#include "ray.h"
#include "globals.h"
#include "rgobject.h"
#include "rayfile.h"
#include "texconst.h"
#include "utils.h"

void FlipBMP(Ptr data, unsigned short width, unsigned short height);
void Flip_Vert_BMP(PUCHAR source_image, USHORT width, USHORT height);    

void F_Get_Wall_Textures()
{
   if (wall_tex_loaded)
      F_Clear_WT();
   wall_tex_loaded=TRUE;
   short dir_index=F_Find_Dir("WALLTEXS");
   if (dir_index==-1)
      return;
   F_Seek(directory[dir_index].start);
   short num_straight_tex;
   F_Get_Short(num_straight_tex);
   char filename[13];       
   RCastGobject texturetemp(num_straight_tex);
   texturetemp.Hold();
   short next_image_num;
   short counter, counter2;

   // in order that we can use animated maps, we first
   // read the textures linearly, into one resource.
   // we then read a list of animation arrangments
   // so that multiple animations can be arranged from the same textures

   Number_Of_Textures=directory[dir_index].length+1;

   wall=(wall_entry *)NewPtr((Number_Of_Textures) * sizeof(wall_entry));

   wall[0].num_image=num_straight_tex;
   wall[0].images=(Byte **)NewPtr(num_straight_tex * sizeof(Byte *));
   wall[0].width=0;
   wall[0].height=0;
   wall[0].shift=0;

   for (counter=0; counter < num_straight_tex; counter++) {
      F_Get_String_NT(filename, F_NAME_LENGTH);
      texturetemp.assigninfile(filename);
      texturetemp.load(counter);
      FlipBMP(texturetemp.Image(counter), texturetemp.Width(), texturetemp.Height());
      wall[0].images[counter]=texturetemp.Image(counter);
   } /* endfor */

   for (counter=1; counter < Number_Of_Textures; counter++) {
      wall[counter].cur_image=0;
      wall[counter].anim_sum=0;
      F_Get_Short(wall[counter].num_image);
      F_Get_Long(wall[counter].anim_speed);
      F_Get_Short(wall[counter].width);
      F_Get_Short(wall[counter].height);
      wall[counter].shift=Check2Shift(wall[counter].height);
      wall[counter].images=(Byte **)NewPtr(wall[counter].num_image * sizeof(Byte *));
      for (counter2=0; counter2 < wall[counter].num_image; counter2++) {
         F_Get_Short(next_image_num);
         wall[counter].images[counter2]=wall[0].images[next_image_num];
      } /* endfor */
   } /* endfor */

}

void FlipBMP(Ptr data, unsigned short width, unsigned short height)
{
Ptr tempptr=NewPtr(sizeof(char)*width*height);
for (int i=0; i<height; i++) {
   for (int j=0; j<width; j++) {
      tempptr[j*height+i]=data[i*width+j];
   } /* endfor */
}
memcpy(data,tempptr,(sizeof(char)*width*height));
DelPtr( tempptr);
}

void F_Clear_WT()
{

   short counter1;

   for (counter1=0; counter1 < wall[0].num_image; counter1++) {
      delete wall[0].images[counter1];
   }

   for (counter1=0; counter1 < Number_Of_Textures; counter1++) {
      if (wall[counter1].images!=NULL)
        DelPtr( wall[counter1].images);
   } /* endfor */

   DelPtr( wall);

}

    
void F_Get_Floor_Textures()
{
   if (floor_tex_loaded)
      F_Clear_FT();
   floor_tex_loaded=TRUE;
   short dir_index=F_Find_Dir("FLOORTEX");
   if (dir_index==-1)
      return;
   F_Seek(directory[dir_index].start);
   short num_straight_tex;
   F_Get_Short(num_straight_tex);
   char filename[13];       
   RCastGobject texturetemp(num_straight_tex);
   texturetemp.Hold();
   short next_image_num;
   short counter, counter2;
   short tex_list_num;

   // in order that we can use animated maps, we first
   // read the textures linearly, into one resource.
   // we then read a list of animation arrangments
   // so that multiple animations can be arranged from the same textures

   Number_Of_FTs=directory[dir_index].length+2;

   tex_list_num=Number_Of_FTs-1;

   floortex=(wall_entry *)NewPtr((Number_Of_FTs) * sizeof(wall_entry));

   floortex[tex_list_num].num_image=num_straight_tex;
   floortex[tex_list_num].images=(Byte **)NewPtr(num_straight_tex * sizeof(Byte *));

   for (counter=0; counter < num_straight_tex; counter++) {
      F_Get_String_NT(filename, 13);
      texturetemp.assigninfile(filename);
      texturetemp.load(counter);
      Flip_Vert_BMP(texturetemp.Image(counter), texturetemp.Width(), texturetemp.Height());
      floortex[tex_list_num].images[counter]=texturetemp.Image(counter);
   } /* endfor */

   for (counter=0; counter < (Number_Of_FTs-2); counter++) {
      floortex[counter].cur_image=0;
      floortex[counter].anim_sum=0;
      F_Get_Short(floortex[counter].num_image);
      F_Get_Long(floortex[counter].anim_speed);
      floortex[counter].width=FLOOR_WIDTH;
      floortex[counter].height=FLOOR_HEIGHT;
      floortex[counter].shift=FLOOR_SHIFT;
      floortex[counter].images=(Byte **)NewPtr(floortex[counter].num_image * sizeof(Byte *));
      for (counter2=0; counter2 < floortex[counter].num_image; counter2++) {
         F_Get_Short(next_image_num);
         floortex[counter].images[counter2]=floortex[tex_list_num].images[next_image_num];
      } /* endfor */
   } /* endfor */

   F_Get_Sky();

}

void Flip_Vert_BMP(PUCHAR source_image, USHORT width, USHORT height)
{
USHORT rev_y, norm_y, x;
PUCHAR dest_image;

if ((dest_image=NewPtr(width*height*sizeof(UCHAR)))==NULL)
  return;

rev_y=height-1;
for (norm_y=0; norm_y<height; norm_y++) {
  for (x=0; x<width; x++) {
    dest_image[norm_y*width+x]=source_image[rev_y*width+x];
  }
  rev_y--;
}

memcpy(source_image, dest_image, width * height * sizeof(UCHAR));
DelPtr( dest_image);
}

void F_Clear_FT()
{

   short counter1;

   for (counter1=0; counter1 < floortex[Number_Of_FTs-1].num_image; counter1++) {
      delete floortex[Number_Of_FTs-1].images[counter1];
   }

   F_Clear_Sky();

   for (counter1=0; counter1< (Number_Of_FTs); counter1++) {
      if (floortex[counter1].images!=NULL)
      DelPtr( floortex[counter1].images);
   } /* endfor */

   DelPtr( floortex);

}

void F_Get_Sky()
{
   short dir_index=F_Find_Dir("SKYTEX  ");
   if (dir_index==-1)
      return;
   F_Seek(directory[dir_index].start);

   sky_texture=&floortex[Number_Of_FTs-2];

   sky_texture->cur_image=0;
   sky_texture->anim_sum=0;
 
   F_Get_Short(sky_texture->num_image);
   F_Get_Long(sky_texture->anim_speed);
   sky_texture->width=SKY_WIDTH;
   sky_texture->height=SKY_HEIGHT;
   sky_texture->shift=SKY_SHIFT;

   char filename[13];
   RCastGobject sky_temp(sky_texture->num_image);
   sky_temp.Hold();
   sky_texture->images=(Byte **)NewPtr(sky_texture->num_image * sizeof(Byte *));
   for (short cur_tex=0; cur_tex<sky_texture->num_image; cur_tex++) {
      F_Get_String_NT(filename, 13);
      sky_temp.assigninfile(filename);
      sky_temp.load(cur_tex);
      FlipBMP(sky_temp.Image(cur_tex), sky_temp.Width(), sky_temp.Height());
      sky_texture->images[cur_tex]=sky_temp.Image(cur_tex);
   }
}

void F_Clear_Sky()
{
   for (short cur_tex=0; cur_tex<sky_texture->num_image; cur_tex++)
      delete sky_texture->images[cur_tex];

}


