#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include "cmdlib.h"

#ifndef __IDBSP__
#define __IDBSP__

#include "storage.h"

#include <math.h>
#include <limits.h>
#include <float.h>
/*#include "cmdlib.h" */
#include "doomdata.h"
#include "wadfile.h"
/* #include "doomdata.h" */

/*
#define SHORT(x)        NXSwapLittleShortToHost((short)x)
#define LONG(x)         NXSwapLittleLongToHost((long)x)
*/

/*
#define SHORT(x) LittleShort((short)x)
#define LONG(x)  LittleLong((long)x)
*/
/*
#define SHORT(x) BigShort((short)x)
#define LONG(x) BigLong((long)x)
*/
/*
#define SHORT(x) (short)(x)
#define LONG(x) (long)(x)
*/

#define PI   3.141592657

#define         MAXVERTEX               8192
#define         MAXTOUCHSECS    16
#define         MAXSECTORS              2048
#define         MAXSUBSECTORS   2048

typedef struct
        {
        float x;
        float y;
        } NXPoint;

typedef struct
        {
        float width;
        float height;
        } NXSize;

typedef struct
        {
        NXPoint origin;
        NXSize size;
        } NXRect;

/*
===============================================================================

                                                        map file types

===============================================================================
*/

typedef struct
{
        int                     floorheight, ceilingheight;
        char            floorflat[9], ceilingflat[9];
        int                     lightlevel;
        int                     special, tag;
} sectordef_t;

typedef struct
{
        int                     firstrow;
        int                     firstcollumn;
        char            toptexture[9];
        char            bottomtexture[9];
        char            midtexture[9];
        sectordef_t     sectordef;                      /* on the viewers side */
        int                     sector;                         /* only used when saving doom map */
} worldside_t;

typedef struct
{
        NXPoint         p1, p2;
        int                     special, tag;
        int                     flags;
        worldside_t     side[2];
} worldline_t;

#define ML_BLOCKMOVE    1
#define ML_TWOSIDED             4       /* backside will not be present at all if not two sided */

typedef struct
{
        NXPoint         origin;
        int                     angle;
        int                     type;
        int                     options;
        int                     area;
} worldthing_t;

/*
===============================================================================

                                                        internal types

===============================================================================
*/

typedef struct
{
        NXPoint pt;
        float   dx,dy;
}divline_t;

typedef struct bspstruct_s
{
/*      id                                              lines_i;                // if non NULL, the node is */
        STORAGE *lines_i;
        STORAGE *cutbox_i;
        divline_t                               divline;                /* terminal and has no children */
        float                                   bbox[4];
        struct  bspstruct_s             *side[2];
} bspnode_t;


typedef struct
{
        NXPoint         p1, p2;
        int                     linedef, side, offset;
        boolean         grouped;                                /* internal error check */
} line_t;


/*
===============================================================================

                                                                idbsp

===============================================================================
*/

/*
===============================================================================

                                                                doomload

===============================================================================
*/

extern  STORAGE *linestore_i;

/*
===============================================================================

                                                                drawing

===============================================================================
*/

extern  float   scale;
extern  NXRect          worldbounds;

/*
===============================================================================

                                                                buildbsp

===============================================================================
*/

extern  int             cuts;                   /* number of new lines generated by BSP process */
extern  bspnode_t       *startnode;

void BuildBSP (void);
void    DivlineFromWorldline (divline_t *d, line_t *w);
int     PointOnSide (NXPoint *p, divline_t *l);
void ExecuteSplit(STORAGE *lines_i, line_t *spliton, STORAGE *frontlist_i,
STORAGE *backlist_i);
void SplitCutBoxes(STORAGE *cutbox_i, line_t *spliton, STORAGE *frontlist_i,
STORAGE *backlist_i);


/*
===============================================================================

                                                        savebsp

===============================================================================
*/

void Make_Line_List();
void Generate_BSP();
void ConvBSP (void);

#endif
