#include "ray.h"
#include "globals.h"
#include "sfvars.h"
#include "sprfunc.h"
#include "sprtypes.h"
#include "inventor.h"
#include "rayspr.h"

void Inventory_Update(pobject cur_object, long update_num);
void Inventory_Render(pobject cur_sprite);

void Init_Inventory(func_index index) {
   update_funcs[index]=Inventory_Update;
   render_funcs[index]=Inventory_Render;
}

void Create_Inventory_Object(pobject new_object, pobject owner) {
   pinventory_data new_data=(pinventory_data)NewPtr(sizeof(inventory_data));

   new_data->old_type=new_object->type;
   new_data->old_extra_data=new_object->extra_data;
   new_object->owner=owner;
   new_object->extra_data=new_data;
   new_object->type=Obj_Type_List+INVENTORY_TYPE;

}

void Inventory_Update(pobject cur_object, long update_num) {
   cur_object->x=cur_object->owner->x;
   cur_object->y=cur_object->owner->y;
   cur_object->z=cur_object->owner->z;
   cur_object->angle=cur_object->owner->angle;
}

void Inventory_Render(pobject cur_sprite) {
}


