
#include "ray.h"
#include "globals.h"
#include "rayspr.h"
#include "message.h"

void Request_Object_Messages(pobject send_obj, pobject receive_obj) {
   if ((send_obj==NULL)||(receive_obj==NULL))
      return;

   pobject_node new_send_node, new_receive_node;

   new_send_node=(pobject_node)NewPtr(sizeof(object_node));
   new_receive_node=(pobject_node)NewPtr(sizeof(object_node));
   new_send_node->data=receive_obj;
   new_receive_node->data=send_obj;
   OL_Push_Node(new_send_node, send_obj->send_objects);
   OL_Push_Node(new_receive_node, send_obj->receive_objects);

}

void Release_Object_Messages(pobject send_obj, pobject receive_obj) {
   if ((send_obj==NULL)||(receive_obj==NULL))
      return;

   pobject_node cur_node;

   cur_node=send_obj->send_objects;
   while (!OL_Empty_Node(cur_node)) {
      if (cur_node->data==receive_obj) {
         break;
      }
      cur_node=OL_Next_Node(cur_node);
   } /* endwhile */

   if (!OL_Empty_Node(cur_node)) {
      OL_Delete_Node(cur_node, send_obj->send_objects);
   }

   cur_node=receive_obj->receive_objects;
   while (!OL_Empty_Node(cur_node)) {
      if (cur_node->data==send_obj) {
         break;
      }
      cur_node=OL_Next_Node(cur_node);
   } /* endwhile */

   if (!OL_Empty_Node(cur_node)) {
      OL_Delete_Node(cur_node, receive_obj->receive_objects);
   }

}

void Send_Auto_Message(pobject send_obj, ULONG message, pdata extra_data) {
  if (send_obj==NULL)
      return;
  
  pobject_node cur_node;

  cur_node=send_obj->send_objects;
  while (!OL_Empty_Node(cur_node)) {
     // send the message to the object (structure derefrencing & function pointer 'o rama)
     (*cur_node->data->type->Message_Func)(send_obj, cur_node->data, message, extra_data);

     cur_node=OL_Next_Node(cur_node);
  } /* endwhile */

}

ULONG Send_Specific_Message(pobject send_obj, pobject receive_obj, ULONG message,
   pdata extra_data) {
   if (receive_obj==NULL)
      return ERROR_MESSAGE;

   return (*receive_obj->type->Message_Func)(send_obj, receive_obj, message, extra_data);
}

