/*
Mouse.cpp
DOS mouse routines
The include os.h is a file I include so the file only exists if you're running under DOS
This means it can be included in a non-Dos project file without screwing up the compile
*/

#include "os.h"
#ifdef OS_DOS
#include <i86.h>
#include "mouse.h"

extern union REGS regs;
extern struct SREGS sregs;

const int mousediv=2;

short initmouse(){
  regs.w.ax=0x0;
  int386(0x33,&regs,&regs);
  return regs.w.ax;
  }

void showmouse(){
  regs.w.ax=0x1;
  int386(0x33,&regs,&regs);
  }

void hidemouse(){
  regs.w.ax=0x2;
  int386(0x33,&regs,&regs);
  }

short mbpos(short & x, short & y)
  {
  regs.w.ax=0x3;
  int386(0x33,&regs,&regs);
  x=(short)regs.w.cx/mousediv;
  y=(short)regs.w.dx;
  return (regs.w.bx);
  }

void mbrel(short & x, short & y)
{
regs.w.ax=0xb;
int386(0x33,&regs,&regs);
x=(short)regs.w.cx;
y=(short)regs.w.dx;
}

void micktopix(short int horiz, short int vert)
{
regs.w.cx=horiz;
regs.w.dx=vert;
regs.w.ax=0x0f;
int386(0x33,&regs,&regs);
}

void xlimit(short int min, short int max)
{
regs.w.cx=min;
regs.w.dx=max;
regs.w.ax=0x7;
int386(0x33,&regs,&regs);
}

void ylimit(short int min, short int max)
{
regs.w.cx=min;
regs.w.dx=max;
regs.w.ax=0x8;
int386(0x33,&regs,&regs);
}
#endif
