#include "ray.h"
#include "globals.h"
#include "fixed.h"
#include "blockmap.h"
#include "objcol.h"
#include "abs.h"
#include "sign.h"
#include "rayspr.h"

MYFIXED Dis_Percent(MYFIXED obj_x, MYFIXED obj_y, MYFIXED ms_x, MYFIXED ms_y,
   MYFIXED delta_x, MYFIXED delta_y, MYFIXED move_len_sq) {

MYFIXED pos_on_line;

pos_on_line=fixeddiv(
   fixedmult(obj_x-ms_x, delta_x)+fixedmult(obj_y-ms_y, delta_y),
   move_len_sq);

pos_on_line=fixedsqrtHP(ABS(pos_on_line))*SIGN(pos_on_line);  
return pos_on_line;
}

MYFIXED Obj_Dis(MYFIXED obj_x, MYFIXED obj_y, MYFIXED mf_x, MYFIXED mf_y,
   MYFIXED delta_x, MYFIXED delta_y, MYFIXED move_len) {

MYFIXED dis_result;

dis_result=fixeddiv(
   fixedmult(obj_x-mf_x, -delta_y)-fixedmult(obj_y-mf_y, -delta_x),
   move_len);

return dis_result;
}

void Stop_Obj(pobject move_obj, pobj_collision the_collision) {

the_collision->delta_x=fixedmult(the_collision->dis_percent, 
   the_collision->delta_x);
the_collision->delta_y=fixedmult(the_collision->dis_percent, 
   the_collision->delta_y);

}

void Slide_Obj(pobject move_obj, pobj_collision the_collision) {

MYFIXED intersect_x, intersect_y;
intersect_x=fixedmult(the_collision->dis_percent, the_collision->delta_x);
intersect_y=fixedmult(the_collision->dis_percent, the_collision->delta_y);

MYFIXED delta_y=the_collision->delta_y;
the_collision->delta_y=intersect_y+SIGN(the_collision->dist_from_move)*fixedmult(
   REBOUND_PERCENT, -the_collision->delta_x);
the_collision->delta_x=intersect_x+SIGN(the_collision->dist_from_move)*fixedmult(
   REBOUND_PERCENT, delta_y);

}

BOOL Intersect_Z(pobject obj_1, pobject obj_2) {
if (obj_1->z >= obj_2->z + obj_2->type->height)
   return FALSE;
if (obj_2->z >= obj_1->z + obj_1->type->height)
   return FALSE;

return TRUE;
}

void Find_Closest_Obj_In_List(pobj_collision the_collision,
 pobject_node search_list) {   
if (search_list==NULL)
   return;

pobject_node cur_node;
pobject cur_obj;

MYFIXED dis_percent, dis_from_move, obj_block_percent;

cur_node=search_list;
while (!OL_Empty_Node(cur_node)) {
    cur_obj=cur_node->data;
    // do they even intersect height wise?
    if (Intersect_Z(cur_obj, the_collision->move_obj)) {
    
    // find at what point on move the objects intersect
    dis_percent=Dis_Percent(cur_obj->x, cur_obj->y,
       the_collision->move_obj->x,
       the_collision->move_obj->y,
       the_collision->delta_x,
       the_collision->delta_y, 
       the_collision->move_len_sq);
    obj_block_percent=fixeddiv(cur_obj->type->block_width,
       the_collision->move_len);
    dis_percent-=obj_block_percent;
    
    if (dis_percent>(-obj_block_percent) && dis_percent < ONE) {
    
    dis_from_move = Obj_Dis(cur_obj->x, cur_obj->y, 
       the_collision->dest_x,
       the_collision->dest_y,
       the_collision->delta_x,
       the_collision->delta_y, 
       the_collision->move_len);
       if (ABS(dis_from_move)<
          (the_collision->move_obj->type->obj_width+cur_obj->type->obj_width)) {
          if ( dis_percent < the_collision->dis_percent )
          {
          the_collision->found_collision=TRUE;
          the_collision->col_obj=cur_obj;
          the_collision->dist_from_move=dis_from_move;
          the_collision->dis_percent=dis_percent;
          }
       }
    } 
    }
    cur_node=OL_Next_Node(cur_node);
  }
}

void Check_Obj_Collision(pobj_collision the_collision) {
the_collision->dest_x=the_collision->move_obj->x+the_collision->delta_x;
the_collision->dest_y=the_collision->move_obj->y+the_collision->delta_y;
the_collision->move_len_sq=
  fixedsqr(the_collision->delta_x)+fixedsqr(the_collision->delta_y);
the_collision->move_len=
  fixedsqrtHP(the_collision->move_len_sq);
the_collision->found_collision=FALSE;
the_collision->dis_percent=MAXMYFIXED;

if (the_collision->move_len_sq==0)
   return;

USHORT block_x, block_y;
MYFIXED dest_x, dest_y;
dest_x=the_collision->dest_x;
dest_y=the_collision->dest_y;
block_x=Block_X(dest_x);
block_y=Block_Y(dest_y);

Find_Closest_Obj_In_List(the_collision, *Get_Block_Obj_List(block_x, block_y));
Find_Closest_Obj_In_List(the_collision, *Get_Block_Obj_List(block_x, block_y+1));
Find_Closest_Obj_In_List(the_collision, *Get_Block_Obj_List(block_x, block_y-1));
Find_Closest_Obj_In_List(the_collision, *Get_Block_Obj_List(block_x+1, block_y));
Find_Closest_Obj_In_List(the_collision, *Get_Block_Obj_List(block_x-1, block_y));
Find_Closest_Obj_In_List(the_collision, *Get_Block_Obj_List(block_x+1, block_y-1));
Find_Closest_Obj_In_List(the_collision, *Get_Block_Obj_List(block_x+1, block_y+1));
Find_Closest_Obj_In_List(the_collision, *Get_Block_Obj_List(block_x-1, block_y-1));
Find_Closest_Obj_In_List(the_collision, *Get_Block_Obj_List(block_x-1, block_y+1));

}
