#ifndef _PALETTE_
#define _PALETTE_
#include "os.h"

#define BLACK_COLOR 0
#define PALETTE_COLORS 256
#define MAX_PAL_ENTRIES 256
#define PAL_ENTRY_SIZE 3

typedef UCHAR pal_component;
typedef PUCHAR palette_ptr;

void Init_Palette();
void Load_Palette(palette_ptr new_palette, short start_pos, short num_entries);
void Get_Palette(palette_ptr receive_palette, short start_pos, short num_entries);
void Activate_Palette(BOOL active);
BOOL Update_Palette();
void Close_Palette();

pal_component Get_Palette_Red_Val(short color_index) ;
pal_component Get_Palette_Green_Val(short color_index);
pal_component Get_Palette_Blue_Val(short color_index);

#endif
