#ifndef _RAY_
#define _RAY_
/*********************

You can copy or use this file all you like and You will not,
repeat, not be castrated.


Copyright Matt Howard1995


*********************/

#include "os.h"
#include <stdarg.h>
#include <stddef.h>

typedef long MYFIXED;
typedef unsigned char * Ptr;
typedef unsigned char Byte;
typedef struct OBJECT_TYPE * pobject_type;
typedef struct OBJECT_NODE * pobject_node;
typedef struct OBJECT * pobject;
typedef struct VECTOR2 * pvector2;
typedef struct SECTOR * psector;
typedef struct SSECTOR * pssector;
typedef struct SIDEDEF * psidedef;
typedef short ptexture;
typedef struct LINEDEF * plinedef;
typedef struct RECTANGLE * prectl;
typedef struct SEG * pseg;
typedef long angle_type;
typedef void * pdata;
typedef SHORT render_type;
typedef void (* update_func)(pobject cur_obj, long update_num);
typedef void (* update_z_func)(pobject cur_obj, psector new_sec);
typedef void (* load_extra_func)(pobject cur_obj, long offset);
typedef void (* render_func)(pobject cur_sprite);
typedef void (* render_data_loader)(pobject_type cur_type, long offset);
typedef ULONG (* message_func)(pobject send_obj, pobject receive_obj,
		  ULONG message, pdata extra_data);
typedef update_func * pupdate_func;
typedef load_extra_func * pload_extra_func;
typedef update_z_func * pupdate_z_func;
typedef render_func * prender_func;
typedef render_data_loader * prender_data_loader;
typedef message_func * pmessage_func;
typedef struct OBJ_STATS * pstats;
typedef struct CUR_STATS * pcur_stats;

typedef struct RECTANGLE {
	long left, right, top, bottom;
} rectangle;

typedef struct OBJ_STATS {
	short total_health;
	short base_speed;
	long sight_dis;
	pdata other_stats;
} obj_stats;

typedef struct OBJECT_TYPE {
		  obj_stats stats;
		  ULONG obj_class;
	ptexture * frames;
		  BOOL * rev_frames;
	USHORT angle_num;
	angle_type half_angle;
	USHORT width, height;
	USHORT wh_ratio, wshift, hshift;
		  USHORT eye_height, stepping_height;
		  MYFIXED block_width, obj_width;
	update_z_func Update_Z;
	load_extra_func Load_Extra;
	update_func Update;
		  render_func Render_Func;
		  render_data_loader Render_Data_Loader;
		  message_func Message_Func;
		  pdata render_data;
		  pdata extra_data;
	/*
	more attributes here
	*/
} object_type;

typedef struct OBJECT_NODE {
	pobject_node front, back;
	pobject data;
} object_node;

typedef struct CUR_STATS {
	short current_health;
	MYFIXED current_speed;
	} cur_stats;

typedef struct OBJECT {
cur_stats stats;
long    x,y,z;
long tx, ty;
USHORT team;
pobject owner;
PUSHORT texture_indexes;
psector cur_sec;
pssector cur_ss;
pobject_node ss_node, global_node, send_objects, receive_objects, block_node;
USHORT block_x, block_y;
pobject_type type;
USHORT cur_frame;
long angle;
/*
  more attributes here
*/
pdata extra_data;
} object;

typedef short tex_mark;

typedef struct VECTOR2 {
	LONG x, y;
	} vector2;

typedef struct SIDEDEF {
	USHORT attributes;
	SHORT x_offset, y_offset;
	ptexture texture_normal, texture_low, texture_high;
	psector sec;
	} sidedef;

typedef struct LINEDEF {
	short v[2];
	psidedef s[2];
	USHORT tag;
	USHORT tag_type;
	USHORT attributes;
		  MYFIXED distance;
	} linedef;

typedef struct SECTOR {
	USHORT tag;
	SHORT floor_height, ceil_height;
	ptexture floor_tex, ceil_tex;
	UCHAR light;
		  USHORT flags;
		  pdata extra_data;
	} sector;

typedef struct SEG {
	short v[2];
	LONG angle;
	plinedef ld;
	BOOL left_sidedef;
	LONG linedef_offset;
	} seg;

typedef struct SSECTOR {
	SHORT seg_start;
	SHORT seg_end;
	USHORT num_objects;
	pobject_node objects;
		  USHORT flags;
		  pdata   extra_data;
	
} ssector;

typedef struct BSP_NODE {
	long x1, x2, y1, y2;
	rectangle left_bound, right_bound;
	USHORT left_child, right_child;
} bsp_node;

typedef struct WALL_ENTRY {
	short num_image, cur_image;
	long anim_speed, anim_sum;
		  short width, height;
		  Byte shift;
	Byte ** images;
} wall_entry;

void    initRay();
void    closeRay();
void Render_Screen(long x, long y, long z, long view_angle);
void Render_Init();
void Render_Close();
void SwitchRenderMode();
render_type GetRenderMode();
void Map_Scale_Increase();
void Map_Scale_Decrease();
void SetRenderMode(render_type mode);
void Build_Tables(void);
void Build_Height_Table(void);
void Build_Vertical_Distance_Table();
void setWindowDimensions(short height);
void setWindowFOV(short vertangle);
void setupNewScreen();
void View_Angle_Up();
void View_Angle_Down();
void Set_View_Angle(angle_type angle);
angle_type Get_Vert_View_Angle();
void Setup_Anim_Tex();
void Animate_Textures(long update_num);

void F_Init();
void F_Scan_Load(char * filename);
void F_Spec_Load(short num_elements, char * filename, ... );
void F_Doom_Load(char * filename);
void F_Shutdown();

#define TEXTURE_NULL -1

#define MODE_3D 0
#define MODE_2D 1


#define STEP_LENGTH 15       // number of units player moves foward or backward

#define OVERBOARD       52  // the closest a player can get to a wall

#define WORLD_ROWS    64     // number of rows in the game world
#define WORLD_COLUMNS 64     // number of columns in the game world

#define CELL_X_SIZE   64     // size of a cell in the gamw world
#define CELL_Y_SIZE   64


#define CELL_X_SIZE_FP   6   // log base 2 of 64 (used for quick division)
#define CELL_Y_SIZE_FP   6

#define WORLD_X_SIZE  (WORLD_COLUMNS * CELL_X_SIZE)
#define WORLD_Y_SIZE  (WORLD_ROWS    * CELL_Y_SIZE)
#define ANGLE_0     0
#define ANGLE_1     5
#define ANGLE_2     10
#define ANGLE_3     16
#define ANGLE_4     20
#define ANGLE_5     25
#define ANGLE_6     32
#define ANGLE_12    60
#define ANGLE_15    80
#define ANGLE_30    160
#define ANGLE_45    240
#define ANGLE_60    320
#define ANGLE_90    480
#define ANGLE_135   720
#define ANGLE_180   960
#define ANGLE_225   1200
#define ANGLE_270   1440
#define ANGLE_315   1680
#define ANGLE_330   1760
#define ANGLE_360   1920     // note: the circle has been broken up into 1920
				  // sub-arcs
#define INTERSECTION_FOUND      1
#define WEIRD2RAD       (6.283185307/1920)
#define MAX_SCALE             500  // maximum size and wall "sliver" can be 201

#define MAX_WINDOW_HEIGHT 480 // don't let window height beyond this
#define MIN_WINDOW_HEIGHT 20 // and done let the height fall below this
#define MAX_VERT_FOV ANGLE_90
#define MIN_VERT_FOV ANGLE_15

#define MAX_LIGHT 0xf
#define MAX_SECTOR_LIGHT 0xff
#define SEC_LIGHT_MASK 0x0f
#define SEC_LTSPEED_MASK 0xf0
#define SEC_LTSPEED_SHIFT 4

#define SLIVER_SHIFT 20
#define SLIVER_ONE 1048576

#define X_TRANS_SHIFT 6

#define SHIFT 14
#define SHIFTLESS 13
#define DOUBLE_SHIFT    18
#define ONE     16384
#define CELL_SIZE_SHIFT_FP      20      //CELL_X_SIZE_FP+SHIFT
#define OTHERSHIFT              4
#define OONE                    16

#define MAXDIS 5793

#define W_TEX_SHIFT 0

#define Z_MOVE_MAX 8
#define Z_ANGLE_DELTA ANGLE_15
#define Z_ANGLE_INC ANGLE_15

#define F_NAME_LENGTH 100
#define BOOL_NAME_LENGTH 6
#define MAX(a,b) ( (a) > (b) ? (a) : (b) )
#define MIN(a,b) ( (a) < (b) ? (a) : (b) )

#define VOXEL_SSECTOR   1
#define VOXEL_SECTOR 1
#define TWO_SIDED_SD 4

#ifdef __cplusplus

#include "memutil.h"

inline long Get_Angle_Difference(long angle1, long angle2)
{
	 long temp_angle=angle1-angle2;
	 if (temp_angle<0) {
			temp_angle+=ANGLE_360;
	 }
	 return temp_angle;
}

inline long Get_Angle_Sum(long angle1, long angle2)
{
	 long temp_angle=angle1+angle2;
	 if (temp_angle>=ANGLE_360)
			temp_angle-=ANGLE_360;
	 return temp_angle;
}

#ifdef OS_DOS
inline BOOL operator ! (BOOL the_bool)
{
  return ((the_bool==TRUE) ? FALSE : TRUE);
}
#endif

#endif
// End of IBM stuff

#endif
