#include "ray.h"
#include "globals.h"

extern void Build_Middle_Table();
void Build_Angle_Tables();
void Make_Legal_View_Angle(angle_type & angle);
BOOL Is_Legal_View_Angle(angle_type angle);
 
void View_Angle_Up()
{
if ( ! Is_Legal_View_Angle(VERTICAL_VIEW_ANGLE)) {
   Make_Legal_View_Angle(VERTICAL_VIEW_ANGLE);
   return;
}

VERTICAL_VIEW_ANGLE=Get_Angle_Sum(VERTICAL_VIEW_ANGLE, ANGLE_2);

Build_Angle_Tables();
}

void View_Angle_Down()
{

if ( ! Is_Legal_View_Angle(VERTICAL_VIEW_ANGLE)) {
   Make_Legal_View_Angle(VERTICAL_VIEW_ANGLE);
   return;
}

VERTICAL_VIEW_ANGLE=Get_Angle_Difference(VERTICAL_VIEW_ANGLE, ANGLE_2);

Build_Angle_Tables();
}

void Set_View_Angle(angle_type new_view_angle)
{

if ( ! Is_Legal_View_Angle(new_view_angle))
   return;

VERTICAL_VIEW_ANGLE=new_view_angle;

Build_Angle_Tables();
}

angle_type Get_Vert_View_Angle()
{
return VERTICAL_VIEW_ANGLE;
}

void Build_Angle_Tables()
{
Build_Vertical_Distance_Table();
Build_Middle_Table();
}

BOOL Is_Legal_View_Angle(angle_type angle)
{
return ( ((angle < ANGLE_30) || (angle > ANGLE_330)) ? TRUE : FALSE);
}

void Make_Legal_View_Angle(angle_type & angle)
{
if (angle < ANGLE_180)
   angle=ANGLE_30 - ANGLE_1;
else angle=ANGLE_330 + ANGLE_1;
}


