#include "ray.h"
#include "blockbsp.h"
#include "sprinter.h"
#include "sprfunc.h"
#include "sprutils.h"

pobject_type Obj_Type_List;
USHORT Number_Of_OTs;
pobject_node g_object_list;
BOOL updating=FALSE;

void Init_Objects() {
   g_object_list=NULL;
   Init_Spr_Funcs();
}

void Close_Objects() {
   Clear_Objects();
   Close_Spr_Funcs();
   Clear_BSP_Block();
}

void Update_Objects(long update_num) {
   updating=TRUE;
   pobject_node cur_obj_node, next_obj_node;
   pobject cur_object;

   cur_obj_node=g_object_list;
   while ( !(OL_Empty_Node(cur_obj_node)) ) {
     cur_object=cur_obj_node->data;
     next_obj_node=OL_Next_Node(cur_obj_node);
     (cur_object->type->Update)(cur_object, update_num);
     cur_obj_node=next_obj_node;
     }
   updating=FALSE;
}
