#include "ray.h"
#include "asm.h"
#include "globals.h"
#include "voxinter.h"
#include "scrconf.h"
#include <stddef.h>

void setWindowDimensions(short height)
{
// Routine to set the height of the window

   // check our height bounds to make sure they are legal
   if ((height > Get_Phys_Screen_Height())|| (height <=MIN_WINDOW_HEIGHT))
      return;

   WINDOW_HEIGHT=height;
   WINDOW_MIDDLE=height >> 1; // half the height

   // setup the new window
   setupNewScreen();
}

void setupNewScreen() // do all calulations having to do with a change in the view window
{
   clearBuff();
   VERTICAL_SCALE=(64*(WINDOW_HEIGHT>>1)<<SHIFT)
                /tan_table[VERTICAL_VIEW_RANGE>>1]; // Set the right scale factor

   if (tex_mark_table!=NULL)
      DelPtr(tex_mark_table);
   tex_mark_table=(tex_mark * )NewPtr((WINDOW_HEIGHT)*sizeof(tex_mark));

   Build_Vertical_Distance_Table();
   Build_Height_Table();
   V_Recalc_Alts();
}

void setWindowFOV(short vertangle)
{
//Routine to set the vertical FOV

// check our angle bounds to make sure they are legal
if ((vertangle>MAX_VERT_FOV) || (vertangle<=MIN_VERT_FOV))
   return;
VERTICAL_VIEW_RANGE=vertangle;

// setup the new window
setupNewScreen();
}

