#include "os.h"
#ifdef OS_DOS

#include <i86.h>
#include "screen.h"

struct SREGS sregs;
union REGS regs;
unsigned char * screen=(unsigned char *)0xa0000;

void setgmode(short int mode)
{

regs.w.ax=mode;
regs.h.ah=0;      
int386(0x10,&regs,&regs);
}

void setpalette(unsigned char * palptr)
{
regs.w.bx=0;
regs.w.cx=0x100;
regs.h.ah=0x10;
regs.h.al=0x12;
regs.x.edx=(long)palptr;
segread(&sregs);
int386x(0x10,&regs,&regs,&sregs);
}

void getpalette(unsigned char * palptr)
{
regs.w.bx=0;
regs.w.cx=0x100;
regs.h.ah=0x10;
regs.h.al=0x17;
regs.x.edx=(long)palptr;
segread(&sregs);
int386x(0x10,&regs,&regs,&sregs);
}

#endif
