#include "ray.h"
#include "globals.h"
#include "rayrend.h"
#include "scrconf.h"

MYFIXED * slope_table;

void Init_Slope_Table() {
  slope_table=(MYFIXED *)NewPtr((Get_Phys_Screen_Width()+1) * sizeof(MYFIXED));
  Recalc_Slope_Table();
}

void Recalc_Slope_Table() {
angle_type start_angle, end_angle;
MYFIXED slope_start, slope_end, slope_sum, slope_increment;

start_angle=Get_Angle_Sum(0, HORIZ_VIEW_RANGE/2);
end_angle=Get_Angle_Difference(0, HORIZ_VIEW_RANGE/2);

slope_start=tan_table[start_angle];
slope_end=tan_table[end_angle];

slope_sum=slope_start;
slope_increment=(slope_end-slope_start)/(WINDOW_WIDTH+1);

for (short cur_ray=0; cur_ray<(WINDOW_WIDTH+1); cur_ray++) {
  slope_table[cur_ray]=slope_sum;
  slope_sum+=slope_increment;
}

}

MYFIXED Get_Slope(short ray) {
  return slope_table[ray];
}

void Clear_Slope_Table() {
if (slope_table!=NULL) {
   DelPtr(slope_table);
   slope_table=NULL;
} /* endif */
}

