#include "ray.h"
#include "asm.h"
#include "rayrend.h"
#include "globals.h"
#include "rayspr.h"
#include "sprrend.h"
#include "mymem.h"
#include "prevarr.h"
#include "rayvb.h"
#include "voxel.h"
#include "mem.h"

#define NO_ENTRIES_IN_TABLE     0

#define VOX_SPRITES_PER_Y       5


pobject_node next_drawable_node;

pobject**       vox_sprite_table;
Byte*            vox_sprite_count;

void    Init_Vox_Sprite_Table() {
   short x;
 
   vox_sprite_table=(pobject**)NewPtr(DIST_MAX*DIST_SCALER*sizeof(pobject*));
   for(x=0;x!=(DIST_MAX*DIST_SCALER);x++) {
      vox_sprite_table[x]=(pobject*)NewPtr(VOX_SPRITES_PER_Y*sizeof(pobject));
      }

   vox_sprite_count=(Byte *)NewPtr(DIST_MAX*DIST_SCALER*sizeof(Byte));
}

void Setup_Vox_Sprite_Rend(pobject_node object_list, short start_line, short end_line) {
   pobject_node cur_object_node=object_list;
   long sprite_y;
   BOOL found_valid_y;
   Translate_Object_Vectors(object_list);
   
   memset(vox_sprite_count, NO_ENTRIES_IN_TABLE ,
        (end_line) * DIST_SCALER * sizeof(Byte));
   while(!OL_Empty_Node(cur_object_node)) {
     sprite_y=Sprite_Y(cur_object_node)>>SHIFT;
     if (cur_object_node->data->type->Render_Func==Draw_Flat_Sprite) {
        sprite_y=1;
     }
     if (sprite_y>0) {
        found_valid_y=FALSE;
        while (sprite_y<(end_line*DIST_SCALER)) {
           if (vox_sprite_count[sprite_y]<VOX_SPRITES_PER_Y) {
              found_valid_y=TRUE;
              break;
           } /* endif */
           sprite_y++;
        }
        if (found_valid_y)
           vox_sprite_table[sprite_y][vox_sprite_count[sprite_y]++]=cur_object_node->data;
     }
     cur_object_node=OL_Next_Node(cur_object_node);
     }              
}

void Do_Vox_Sprite_Line(long y) {
   short absolute_y;
   short cur_object;

   for(absolute_y=y; absolute_y!=(y+DIST_SCALER);absolute_y++) {
      for(cur_object=0;cur_object!=vox_sprite_count[absolute_y];cur_object++) {
         (*vox_sprite_table[absolute_y][cur_object]->type->Render_Func)(vox_sprite_table[absolute_y][cur_object]);
         }
      }

}

void Render_Vox_Sprites() {
  if (wall_run_count>0) {
     Render_Sliver_asm();
  } /* endif */
}
