#include "ray.h"
#include "globals.h"
#include "voxtype.h"

#define TOTAL_VOX_MEM (65536*2)
#define ALT_TO_COL_DIFF (65536)
#define ALT_ARR_SIZE (65536)
#define COL_ARR_SIZE (65536)
#define COLOR_DIFF_COUNT 512
#define DIST_MIN 2
#define DIST_MAX 100
#define ALT_MAX 256
#define G_TABLE_ADJUST 256
#define LIGHT_INCR 1
#define VOX_FP_SHIFT 16
#define LIGHT_FP_SHIFT 8
#define HEIGHT_CHANGE_SHIFT 16
#define MAX_INT_LIGHT_DIFF 31
#define MIN_INT_LIGHT_DIFF (-31)
#define ALT_WIDTH_AND 0xff
#define ALT_HEIGHT_AND 0xff
#define ALT_WIDTH 0x100
#define ALT_HEIGHT 0x100
#define ALT_Y_SHIFT 8
#define VOXEL_SPEED_SCALE 10                                     
#define HCP_SIZE 8
#define MAX_TABLED_HC_INTP 64

extern "C" long DIST_SCALER; // scales points in voxel 
        //map to greater distance
extern "C" long HEIGHT_SCALER; // scales points in voxel linearly

extern "C" long v_horiz_length; // length of a voxel row

extern "C" PT_ALT alt_array; // the altitudes
extern "C" PVOX_COLOR color_array; // the colors

extern "C" PUCHAR prev_vox_colors;  // to arrays for keeping track of last row in asm loop
extern "C" PSHORT prev_vox_heights;

extern "C" PSHORT * alt_scaler; // used to get vox height values w/o division
extern "C" PSHORT cur_scaler; // sent to assembly loop since distance is constant for loop

extern "C" MYFIXED y_inc; // speed at which to mov across map in x
extern "C" MYFIXED x_inc; // speed at which to mov across map in y
extern "C" MYFIXED x_loc; // FP x location in map
extern "C" MYFIXED y_loc; // FP y location in map

extern "C" PSHORT g_table; // table to get gauraud shading values w/o division
extern "C" PULONG y_jumps; // table to get y locations on screen w/o mulitplications
extern "C" PUCHAR vox_buff; // table for offsetted buffer to draw in
extern "C" SHORT starting_y; // saves start at altitude 256
extern "C" PLONG h_table; // table to get line interpolations w/o division
extern "C" PVOID vox_change_table;
extern "C" PUCHAR v_light_table;
void Render_Voxel_Screen(long x, long y, long z, long view_angle);
void Setup_Voxel_Tables();
void Init_Voxel(PCHAR vox_file_name);
extern "C" Draw_Vox_Row();
extern "C" Draw_Vox_Row_Fast(); // same as above but faster w/o shading
extern "C" Draw_Vox_Row_Smooth(); // same as others, but creates smooth terrain w/ interpolation
void Close_Voxel();
void V_Set_Dist_Scale(long new_scaler);
void V_Dist_Scale_Inc();
void V_Dist_Scale_Dec();
void V_Recalc_Alts();
void V_Recalc_Screen();
void V_Recalc_Length();
SHORT Get_Voxel_Alt(long x, long y);

