; ///////////////////////////////////////////////////////////////////////////
; Voxrowf.asm - The inner loop of a program to draw voxel terrain
; Er um, this code is copyright @1994 Matt Howard, and stuff.
; But why copyright a program? It's just an instrument of the imperialist
; capatalist regime. In a true socialist society, we'd all share our code.
; And someone would tape Bill Gates mouth shut. Harmony would prevail.
; But anyway... here's the code...
; Note: Same as voxrow.asm but no shading
; /////////////////////////////////////////////////////////////////////////

.CODE
.386

X_LOC_BOUNDER equ 00ffffffh
Y_LOC_BOUNDER equ 0ff000000h
VOX_FP_SHIFT equ 10h
LIGHT_FP_SHIFT equ 08h
ALT_TO_COL_DIFF equ 0ffffh
G_TABLE_SHIFT equ 9
G_TABLE_ADJUST equ 100h
LIGHT_AND equ 0f0h
COLOR_AND equ 0fh

EXTRN "C", x_inc:DWORD; speed at which to go across map in x
EXTRN "C", y_inc:DWORD; speed at which to go across map in y
EXTRN "C", x_loc:DWORD; fixed-point x loc in map
EXTRN "C", y_loc:DWORD; fixed-point y loc in map
EXTRN "C", vox_buff:DWORD; buffer in which to draw
EXTRN "C", starting_y:WORD; highest value to starting drawing at
EXTRN "C", cur_scaler:DWORD ; array holds data to scale altitudes to screen
EXTRN "C", alt_array:DWORD ; grid of altitudes
EXTRN "C", prev_vox_colors:DWORD ; array to save last trace colors
EXTRN "C", prev_vox_heights:DWORD ; array to save last trace heights
EXTRN "C", g_table:DWORD ; scaler to get gauraud interpolation w/o division
EXTRN "C", y_jumps:DWORD ; scaler to get y line offset w/o multiplication
EXTRN "C", WINDOW_HEIGHT:WORD ; height of view window
EXTRN "C", v_horiz_length:DWORD ; length horizontally of current vox run
EXTRN "C", PHYS_SCREEN_WIDTH:DWORD ; height of physical screen
EXTRN "C", v_light_table:DWORD ; table of values to change light

PUBLIC Draw_Vox_Row_Fast_

Draw_Vox_Row_Fast_ PROC NEAR C

   pushad

   mov esi, v_horiz_length
   dec esi

   mov ebp, x_loc
   mov ebx, y_loc
VOX_OUT_LOOP:

      xor ecx, ecx
      xor eax, eax

      ; get x,y location of next pixel
      mov edi, ebx
      and edi, Y_LOC_BOUNDER
      and ebp, X_LOC_BOUNDER
      add edi, ebp
      shr edi, VOX_FP_SHIFT

      ; get altitude
      mov edx, alt_array
      add edx, edi
      mov cl, [edx]

      ; get color
      ; Note: altitude & color array are next to each other
      ; in memory for speed
      add edx, ALT_TO_COL_DIFF
      mov al, [edx]

      ; get lighted value
      mov edx, v_light_table;
      mov al, [edx+eax];

      xor edi, edi

      ; scale altitude
      mov edx, cur_scaler
      ; note: ecx added twice since it is word
      add edx,ecx
      add edx,ecx
      mov cx, [edx]

      ; add base value and clip against screen for final value
      add cx, starting_y
 
      ; too high
      jns not_too_high
      mov cx, 0

not_too_high:

      ; get previous y
      mov edx, prev_vox_heights ; point to last line info
      ; note: esi added twice for since it is word
      add edx, esi
      add edx, esi
      mov di, [edx]

      sub di, cx
      jbe NO_DRAW

         mov [edx], cx ; save current value for next round, this seems
                     ; out of place, but helps speed

         ; get screen starting pos
         mov edx, y_jumps
         shl ecx, 2
         add edx, ecx
         mov ecx, [edx]
         add ecx, esi
         add ecx, vox_buff

VOX_IN_LOOP:

            ; get the color val and throw it on that screen
            mov [ecx], al

            ; update light val and screen pos
            add ecx, PHYS_SCREEN_WIDTH

            ; and loop
            dec edi
            jnz VOX_IN_LOOP

NO_DRAW:
  
      ; update positions in map
      mov eax, y_inc
      add ebx, eax
      mov eax, x_inc
      add ebp, eax

      ; and loop
      dec esi
      jns VOX_OUT_LOOP

   popad
   ret

Draw_Vox_Row_Fast_ ENDP

END

