#include "ray.h"
#include "globals.h"
#ifdef OS_WINDOWS
#include "winfuncs.h"
#include "scrcntl.h"
#include "gamerun.h"
#include "palette.h"
#include "raybuff.h"
#include "winvars.h"
#include "keyboard.h"
#include "loadwor.h"
#include <iostream.h>

BOOL active_app, initialized_app;
char    szAppName[]="BloodBath Prototype!";
char    szAppBaseWindowTitle[]="BloodBath";
 OPENFILENAME ofn;
 char szFileName[MAXFILENAME];
 char szFileTitle[MAXFILENAME];
 char szFilterSpec [128] =                       /* file type filters */
             "World Files (*.DAT)\0*.DAT\0Doom Files(*.WAD)\0*.WAD\0All Files (*.*)\0*.*\0";

HINSTANCE hInstApp;
HWND      hwndApp;
/*----------------------------------------------------------------------------*\
|                                                                              |
|   f u n c t i o n   d e f i n i t i o n s                                    |
|                                                                              |
\*----------------------------------------------------------------------------*/

LONG FAR PASCAL Win_Window_Proc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);
LONG AppCommand (HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam);

void Win_Close(void);
BOOL Win_Idle(void);

/*----------------------------------------------------------------------------*\
|   AppAbout( hDlg, uiMessage, wParam, lParam )                                |
|                                                                              |
|   Description:                                                               |
|       This function handles messages belonging to the "About" dialog box.    |
|       The only message that it looks for is WM_COMMAND, indicating the use   |
|       has pressed the "OK" button.  When this happens, it takes down         |
|       the dialog box.                                                        |
|                                                                              |
|   Arguments:                                                                 |
|       hDlg            window handle of about dialog window                   |
|       uiMessage       message number                                         |
|       wParam          message-dependent                                      |
|       lParam          message-dependent                                      |
|                                                                              |
|   Returns:                                                                   |
|       TRUE if message has been processed, else FALSE                         |
|                                                                              |
\*----------------------------------------------------------------------------*/
BOOL FAR PASCAL  AppAbout(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
    switch (msg)
    {
        case WM_COMMAND:
            if (LOWORD(wParam) == IDOK)
            {
                EndDialog(hwnd,TRUE);
            }
            break;

        case WM_INITDIALOG:
            return TRUE;
    }
    return FALSE;
}

/*----------------------------------------------------------------------------*\
|   Win_Init( hInst, hPrev)                                                     |
|                                                                              |
|   Description:                                                               |
|       This is called when the application is first loaded into               |
|       memory.  It performs all initialization that doesn't need to be done   |
|       once per instance.                                                     |
|                                                                              |
|   Arguments:                                                                 |
|       hInstance       instance handle of current instance                    |
|       hPrev           instance handle of previous instance                   |
|                                                                              |
|   Returns:                                                                   |
|       TRUE if successful, FALSE if not                                       |
|                                                                              |
\*----------------------------------------------------------------------------*/
BOOL Win_Init(HINSTANCE hInst,HINSTANCE hPrev,int sw,LPSTR szCmdLine)
{
    WNDCLASS cls;

    /* Save instance handle for DialogBoxs */
    hInstApp = hInst;

    if (!hPrev)
    {
        /*
         *  Register a class for the main application window
         */
        cls.hCursor        = LoadCursor(NULL,IDC_ARROW);
        cls.hIcon          = LoadIcon(hInst,"AppIcon");
        cls.lpszMenuName   = "AppMenu";
        cls.lpszClassName  = szAppName;
        cls.hbrBackground  = (HBRUSH)(COLOR_WINDOW + 1);
        cls.hInstance      = hInst;
        cls.style          = CS_BYTEALIGNCLIENT | CS_VREDRAW | CS_HREDRAW | CS_DBLCLKS;
        cls.lpfnWndProc    = (WNDPROC)Win_Window_Proc;
        cls.cbWndExtra     = 0;
        cls.cbClsExtra     = 0;

        if (!RegisterClass(&cls))
            return FALSE;
    }

   long nBitmapW = 320;                 //default size (window client size to use).
   long nBitmapH = 200;

        //work backwards from client size to desired window size.  doesn't have
        //to be super accurate, approximate will do.

        int windx, windy;

        windx = windy = GetSystemMetrics(SM_CXFRAME)*2;
        windx += nBitmapW;      
        windy += nBitmapH + GetSystemMetrics(SM_CYCAPTION) - 1;
        windy += GetSystemMetrics(SM_CYMENU);

   hwndApp = CreateWindow (szAppName,    // Class name
                           szAppName,              // Caption
                           WS_OVERLAPPEDWINDOW,    // Style bits
                           CW_USEDEFAULT, 0,       // Position
                                     windx,windy,                   // Size
                           (HWND)NULL,             // Parent window (no parent)
                           (HMENU)NULL,            // use class menu
                           hInst,                  // handle to window instance
                           (LPSTR)NULL             // no params to pass on
                           );
    ShowWindow(hwndApp,sw);

    HMENU Menu = GetMenu(hwndApp);
    CheckMenuItem(Menu,ID_STUFF_1X,MF_CHECKED);

    initialized_app=FALSE;
    return TRUE;
}

void Win_Close() {

   if (initialized_app)
      Global_Close();
   }

/*----------------------------------------------------------------------------*\
|   WinMain( hInst, hPrev, lpszCmdLine, cmdShow )                              |
|                                                                              |
|   Description:                                                               |
|       The main procedure for the App.  After initializing, it just goes      |
|       into a message-processing loop until it gets a WM_QUIT message         |
|       (meaning the app was closed).                                          |
|                                                                              |
|   Arguments:                                                                 |
|       hInst           instance handle of this instance of the app            |
|       hPrev           instance handle of previous instance, NULL if first    |
|       szCmdLine       ->null-terminated command line                         |
|       cmdShow         specifies how the window is initially displayed        |
|                                                                              |
|   Returns:                                                                   |
|       The exit code as specified in the WM_QUIT message.                     |
|                                                                              |
\*----------------------------------------------------------------------------*/
int PASCAL WinMain(HINSTANCE hInst, HINSTANCE hPrev, LPSTR szCmdLine, int sw)
{
    MSG     msg;

    /* Call initialization procedure */
    if (!Win_Init(hInst,hPrev,sw,szCmdLine))
                        return FALSE;

    /*
     * Polling messages from event queue
     */
    for (;;)
    {
        if (PeekMessage(&msg, NULL, 0, 0,PM_REMOVE))
        {
            if (msg.message == WM_QUIT)
                break;

            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
        else
                 {
            if (Win_Idle())
                WaitMessage();
        }
    } 

    Win_Close();
    return msg.wParam;
}

////////////////////////////////////////////////////////////////////////////
// Win_Copy_Buff. Copys buffer to screen
//
void Win_Copy_Buff(void)
{
        HDC hdc = GetDC(hwndApp);
        Set_Screen_Window(hdc);
        //don't bother to realize the palette, because we've got Activate_Palette().
        copyBuff();
        ReleaseDC(hwndApp, hdc);
}

BOOL Win_Idle()
{
   if (active_app) {
        // we are the foreground app.
        Do_Main_Cycle();
        return FALSE;
    }
    else
    {
       return TRUE;
        // we are background, so do nothing!
    }
}

/////////////////////////////////////////////////////////////////////////////
// AppSetCaption().  Sets the window caption to the specified string,
// appended to the BloodBath base caption.
//
void AppSetCaption(char *szCaption)
{
        char szWindowTitle[MAXFILENAME];

        lstrcpy(szWindowTitle, szAppBaseWindowTitle);
        lstrcat(szWindowTitle, " - ");
        lstrcat(szWindowTitle, szCaption);
        SetWindowText(hwndApp, szWindowTitle);
}

/////////////////////////////////////////////////////////////////////////////
// Win_Window_Proc( hwnd, uiMessage, wParam, lParam )
//
// The window proc for the app's main (tiled) window.  This processes all
// of the parent window's messages.
//
LONG FAR PASCAL  Win_Window_Proc(HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
    PAINTSTRUCT ps;
    HDC hdc;
    BOOL f;

    switch (msg)
    {
    case WM_CREATE:
                        //let WM_SIZE do all the work.
              break;

   case WM_ACTIVATEAPP:
                    active_app = (BOOL)wParam;
                   hdc=GetDC(hwnd);
                   Set_Screen_Window(hdc);
                     // *** Remap the system colors and deal with the palette
                    Activate_Palette(active_app);
                   ReleaseDC(hwnd, hdc);
      break;
   case WM_SIZE:                        

                if (!initialized_app) {
                   Init_Screen(LOWORD(lParam), HIWORD(lParam));
                   Global_Initialize();
                   initialized_app=TRUE;
                } else {
                   Change_Screen(LOWORD(lParam), HIWORD(lParam));
                }
      break;
   case WM_KEYDOWN:
      Process_Key(wParam);
      break;
   case WM_KEYUP:
      Process_Key(wParam+128);
      break;
   case WM_LBUTTONDOWN:
      break;
   case WM_RBUTTONDOWN:
      break;
   case WM_MOUSEMOVE:
      break;
   case WM_COMMAND:
      return AppCommand(hwnd,msg,wParam,lParam);
   case WM_DESTROY:
      PostQuitMessage(0);
      break;
   case WM_CLOSE:
      break;
   case WM_PALETTECHANGED:
       if ((HWND)wParam == hwnd)
                 break;
      // fall through to WM_QUERYNEWPALETTE
   case WM_QUERYNEWPALETTE:
      hdc=GetDC(hwnd);
      Set_Screen_Window(hdc);
     f = Update_Palette();
      ReleaseDC(hwnd, hdc);
      if (f)
         InvalidateRect(hwnd,NULL,TRUE); 
      return f;
   case WM_PAINT:
        hdc = BeginPaint(hwnd,&ps);
        Set_Screen_Window(hdc);
        Update_Palette();
        copyBuff();
        EndPaint(hwnd,&ps);
        return 0L;
        }
        return DefWindowProc(hwnd,msg,wParam,lParam);
}


/////////////////////////////////////////////////////////////////////////////
// Handler for File|OpenWorld menu command.  Prompt user, via dialog box, for
// a world-file to open, then re-init Nottingham with this new world.
//
BOOL AppOnFileOpen(void)
{
        //fill in non-variant fields of OPENFILENAME struct.  don't have to do
        //this every time, but I really don't care.
  
   ofn.lStructSize       = sizeof(OPENFILENAME);
   ofn.hwndOwner                = hwndApp;
   ofn.lpstrFilter           = szFilterSpec;
   ofn.lpstrCustomFilter = NULL;
   ofn.nMaxCustFilter     = 0;
   ofn.nFilterIndex          = 1;
   ofn.lpstrFile         = szFileName;
   ofn.nMaxFile         = MAXFILENAME;
   ofn.lpstrInitialDir   = NULL;
   ofn.lpstrFileTitle    = szFileTitle;
   ofn.nMaxFileTitle     = MAXFILENAME;
   ofn.lpstrTitle        = NULL;
   ofn.lpstrDefExt       = "DAT";
   ofn.Flags             = 0;

   if (!GetOpenFileName ((LPOPENFILENAME)&ofn))
      return FALSE;   

        AppSetCaption(szFileTitle);
   Load_World(szFileName);
   return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// AppCommand(hwnd, msg, wParam, lParam )
//
//      handles WM_COMMAND messages for the main window (hwndApp)
// of the parent window's messages.
//
LONG AppCommand (HWND hwnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
    switch(wParam)
    {
        case ID_FILE_ABOUT:
                        DialogBox(hInstApp,"AppAbout",hwnd,(DLGPROC)AppAbout);
            break;

        case ID_FILE_EXIT:
            PostMessage(hwnd,WM_CLOSE,0,0L);
            break;

        case ID_FILE_OPEN:
            AppOnFileOpen();
            break;

                  case ID_STUFF_1X:                     //stretch choices.
                  case ID_STUFF_2X:
                                {
                           HMENU Menu = GetMenu(hwndApp);

                                        // uncheck current selection
                                CheckMenuItem(Menu,ID_STUFF_1X - 1 + Get_Stretch_Factor(),MF_UNCHECKED);

                                // get the stretch factor
                                Set_Stretch_Factor(1 + wParam - ID_STUFF_1X);

                                CheckMenuItem(Menu,wParam,MF_CHECKED);  //check new selection.

                                InvalidateRect(hwnd,NULL,TRUE);                 //force a re-Blit
                                }
                                break;

        }
    return 0L;
}
#endif
