/* TC-09 */
/* This program demonstrates the halftoning capabilities
	of EGA and VGA graphics adapters */

/* ----------------------------------------------------------------------- */
/* INCLUDE FILES */
#include <process.h>
#include <bios.h>
#include <stdio.h>
#include <graphics.h>
#include <math.h>

/* ----------------------------------------------------------------------- */
/* DECLARATIONS */

void keyboard(void);void quit_pgm(void);
void notice(int x,int y);
void coords(void);void graphics_setup(void);
void swatches(void);

float		sx,sy;															/* device-independent display coordinates */
float		x_res,y_res;													/* screen mode dimensions for windowing */

int		C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,		/* color variables */
			C9=9,C10=10,C11=11,C12=12,C13=13,C14=14,C15=15,
			mode_flag=0;

int		COLOR1=0;
float		x1=0,y1=240,x2=0,y2=0,x3=0,y3=0,x4=0,y4=0;
float		x_offset=54,y_offset=40,x_change=54,y_change=50;
int		t1=1,t2=1,t3=1;												/* counters */

char fill_0[]={0,0,0,0,0,0,0,0};										/* 0% fill */
char fill_3[]={0,32,0,0,0,2,0,0};									/* 3% fill */
char fill_6[]={32,0,2,0,128,0,8,0};									/* 6% fill */
char fill_12[]={32,2,128,8,32,2,128,8};							/* 12% fill */
char fill_25[]={68,17,68,17,68,17,68,17};							/* 25% fill */
char fill_37[]={170,68,170,17,170,68,170,17};					/* 37% fill */
char fill_50[]={85,170,85,170,85,170,85,170};					/* 50% fill */
char fill_62[]={85,187,85,238,85,187,85,238};					/* 62% fill */
char fill_75[]={187,238,187,238,187,238,187,238};				/* 75% fill */
char fill_87[]={223,253,127,247,223,253,127,247};				/* 87% fill */
char fill_93[]={255,223,255,223,255,223,255,223};				/* 93% fill */
char fill_100[]={255,255,255,255,255,255,255,255};				/* 100% fill */

/* ----------------------------------------------------------------------- */
/* MAIN ROUTINE */

main(){
graphics_setup();
setcolor(C7);

x1=0;y1=60;
COLOR1=C1;swatches();

x1=0;y1=y1+y_change;
COLOR1=C2;swatches();

x1=0;y1=y1+y_change;
COLOR1=C4;swatches();

x1=0;y1=y1+y_change;
COLOR1=C3;swatches();

x1=0;y1=y1+y_change;
COLOR1=C5;swatches();

x1=0;y1=y1+y_change;
COLOR1=C7;swatches();

sx=0;sy=440;coords();setcolor(C7);notice(sx,sy);
for (t1=1;t2!=2;) keyboard();
quit_pgm();}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: DRAW HALFTONE SWATCHES */

void swatches(void){

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_0,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_3,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_6,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_12,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_25,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_37,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_50,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_62,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_75,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_87,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_93,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

x2=x1+x_offset;y2=y1+y_offset;sx=x1;sy=y1;coords();x3=sx;y3=sy;
sx=x2;sy=y2;coords();x4=sx;y4=sy;
setfillpattern(fill_100,COLOR1);bar(x3,y3,x4,y4);x1=x1+x_change;

return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CHACK THE KEYBOARD BUFFER */
void keyboard(void){
if (bioskey(1)==0) return; else quit_pgm();}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: GRACEFUL EXIT FROM PROGRAM */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: VGA/EGA/MCGA/CGA COMPATIBILITY MODULE */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_mode;
if (graphics_mode==EGAHI) goto EGA_ECD_mode;
if (graphics_mode==EGALO) goto EGA_SCD_mode;
if (graphics_adapter==CGA) goto abort_message;
if (graphics_adapter==MCGA) goto abort_message;
goto abort_message;

VGA_mode:
graphics_adapter=VGA;graphics_mode=VGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=480;mode_flag=1;
		  setcolor(7);moveto(0,472);
		  outtext("Revisions by A. Helder");
        moveto(472,472);
        outtext("Press any key to quit");
		  moveto(184,0);
		  outtext("HALFTONE RENDERING SYSTEM FOR VGA");
        return;

EGA_ECD_mode:
graphics_adapter=EGA;graphics_mode=EGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=350;mode_flag=2;
		  setcolor(7);moveto(0,342);
		  outtext("Revisions by A. Helder");
        moveto(472,342);
        outtext ("Press any key to quit");
		  moveto(152,0);
		  outtext("HALFTONE RENDERING SYSTEM FOR EGA AND VGA");
        return;

EGA_SCD_mode:
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;mode_flag=3;
		  setcolor(7);moveto(0,192);
		  outtext("Revisions by A. Helder");
        moveto(472,192);
        outtext("PRESS ANY KEY TO QUIT");
		  moveto(152,0);
		  outtext("HALFTONE RENDERING SYSTEM FOR EGA AND VGA");
        return;

abort_message:
printf("\n\nUnable to proceed - Requires VGA or EGA adapter");
printf("\nWith appropriate monitor");
exit(0);
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: MAP 640*480 TEMPLATE TO 2D SCREEN */
void coords(void)
{
sx=sx*(x_res/640);sy=sy*(y_res/480);return;
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: COPYRIGHT NOTICE */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(int x, int y){
int a,b,c; int t1=0;

for (t1=0;t1<=6;t1++)
	{
	a=copyright[t1][0];b=copyright[t1][1];
	c=copyright[t1][2];
	setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
	moveto(x,y);lineto(x+15,y);
	setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
	moveto(x+16,y);lineto(x+31,y);
	setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
	moveto(x+32,y);lineto(x+47,y);y++;
	};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}

/* END OF SOURCE CODE */