$INCLUDE: 'C:\FG\FASTGRAF.FI'

      PROGRAM MAIN

      INTEGER MODE, OLD_MODE, STATUS
      CHARACTER*5 STRING
      INTEGER FG_GETMODE, FG_SVGAINIT, FG_TESTMODE

C  Ask for the video mode number

      WRITE(6,*) 'Which video mode?'
      READ(5,*) MODE

C  Make sure the entered value is valid

      CALL FG_INITPM
      IF (MODE .GT. 23) STATUS = FG_SVGAINIT(0)
      IF (MODE .LT. 0 .OR. MODE .GT. 29) THEN
         WRITE(6,1000) MODE
         STOP ' '
      END IF

C  Make sure the requested video mode is available

      IF (FG_TESTMODE(MODE,1) .EQ. 0) THEN
         WRITE(6,1010) MODE
         STOP ' '
      END IF

C  Establish the video mode

      OLD_MODE = FG_GETMODE()
      CALL FG_SETMODE(MODE)

C  Perform mode-specific initializations

C  text modes

      IF (MODE .LE. 3 .OR. MODE .EQ. 7) THEN
         CALL FG_CURSOR(0)

C  CGA color modes

      ELSE IF (MODE .EQ. 4 .OR. MODE .EQ. 5) THEN
         CALL FG_PALETTE(0,0)
         CALL FG_DEFCOLOR(14,3)

C  CGA two-color mode

      ELSE IF (MODE .EQ. 6) THEN
         CALL FG_PALETTE(0,14)
         CALL FG_DEFCOLOR(14,1)

C  Hercules mode

      ELSE IF (MODE .EQ. 11) THEN
         CALL FG_DEFCOLOR(14,1)

C  Hercules low-res mode

      ELSE IF (MODE .EQ. 12) THEN
         CALL FG_DEFCOLOR(14,3)

C  VGA two-color mode

      ELSE IF (MODE .EQ. 17) THEN
         CALL FG_PALETTE(1,14)
         CALL FG_SETRGB(14,63,63,21)
         CALL FG_DEFCOLOR(14,1)
      END IF

C  Display a message that includes the video mode number

      CALL FG_SETCOLOR(14)
      CALL FG_TEXT('I''m running in mode ',20)
      WRITE(STRING,1020) MODE
      CALL FG_TEXT(STRING,3)

C  Wait for a keystroke

      CALL FG_WAITKEY

C  Restore the original video mode and screen attributes

      CALL FG_SETMODE(OLD_MODE)
      CALL FG_RESET

      STOP ' '
1000  FORMAT(I6,' is not a valid video mode number.')
1010  FORMAT(' Mode ',I2,' is not available on this system.')
1020  FORMAT(I2,'.')
      END
