/*
        IFS code display and support for FRACTINT
*/

#include <stdio.h>
#include <graphics.h>
#include <io.h>
#include <dos.h>
#include <string.h>
#include "fdestria.h"
#include "fdesign.h"
#include "fdesplot.h"
#include "fdesfile.h"
#include "fdesmenu.h"
popmenu ifsmenu = {
        3 ,
	"Read a FRACTINT .IFS file", "Write a FRACTINT .IFS file", "Return"
	};

void ifs_menu(void)
{
int i,j;
int select;
int done;
FILE *ifsfile;
char fname[80];
char sbuf[80];
char save,ch;
float a,b,c,d,e,f,p;
int file_error;
int x1,y1,x2,y2;
float top,left,right,bottom;
float scalex,scaley;
float offsetx,offsety;
float xset,yset;
float temp_x,temp_y;

        /* Display IFS codes */
        putmsg_d(10,80,"IFS codes for this screen",BLUE,WHITE);
        for (i=0; i<num_triangles; i++)
        {
		sprintf(sbuf,"%7.4f %7.4f %7.4f %7.4f %9.4f %9.4f %6.4f",
                        IFS[1+7*i],IFS[2+7*i],
                        IFS[3+7*i],IFS[4+7*i],
                        IFS[5+7*i],IFS[6+7*i],
                        IFS[7+7*i]);
                putmsg_d(10,i*14+100,sbuf,BLACK,colors[i%MAXCOLORS_]);
	}
        done = 0;
        do {
                select = popup(100,10,&ifsmenu,LIGHTGREEN,BROWN);
                switch (select)
                {
                        case 1: /* read from .IFS file */
                                if (gscanf(100,100,"Read from what .IFS file: ",
                                        8,"%s",fname))
				{
					file_error = 0;
                                        ifs_name_fix(fname);
					ifsfile = fopen(fname,"rt");
					if (ifsfile == NULL)
					{
						putmsg(10,100,"File not Found",RED,WHITE);
						delay(1000);
						clrmsg();
						break;
					}
                                        num_triangles = 0;
                                        do
                                        {
						if (fgets(sbuf,80,ifsfile) == NULL) continue;
						i = sscanf(sbuf,"%f %f %f %f %f %f %f",
							&a,&b,&c,&d,&e,&f,&p);
                                                if ((i == 7) && (num_triangles == (MAXFUNC-1)))
                                                {
                                                        file_error = 1;
                                                        putmsg(10,100,"Too many IFS codes",RED,WHITE);
                                                        delay(1000);
                                                        clrmsg();
                                                        continue;
                                                }
                                                if (i == 7)
                                                {
                                                        /* calc set point */
                                                        xset = 1.0;
                                                        yset = 1.0;
                                                        for (j=0; j<20; j++)
                                                        {
                                                                temp_x = xset*a + yset*b + e;
                                                                temp_y = xset*c + yset*d + f;
                                                                xset = temp_x;
                                                                yset = temp_y;
                                                        }
                                                        /* adjust min/max values */
                                                        if (num_triangles == 0)
                                                        {
                                                                left = right = xset;
                                                                top = bottom = yset;
                                                        }
                                                        else
                                                        {
                                                                if (xset < left) left = xset;
                                                                if (xset > right) right = xset;
                                                                if (yset < top) top = yset;
                                                                if (yset > bottom) bottom = yset;
                                                        }
                                                        IFS[1+7*num_triangles+0] = a;
                                                        IFS[1+7*num_triangles+1] = b;
                                                        IFS[1+7*num_triangles+2] = c;
                                                        IFS[1+7*num_triangles+3] = d;
                                                        IFS[1+7*num_triangles+4] = e;
                                                        IFS[1+7*num_triangles+5] = f;
                                                        IFS[1+7*num_triangles+6] = p;
                                                        num_triangles++;
                                                }
                                        } while ((!feof(ifsfile)) && (!file_error));
					fclose(ifsfile);
                                        if (num_triangles == 0) file_error = 1;
					if (file_error) default_fractal();
					else
					{
                                                /* setup a default reference triangle */
						triangle0.col[0] = left;
						triangle0.col[1] = right;
						triangle0.col[2] = right;
						triangle0.row[0] = bottom;
						triangle0.row[1] = bottom;
						triangle0.row[2] = top;
                                                for (j=0; j<num_triangles; j++)
                                                {
                                                        for (i=0; i<3; i++)
                                                        {
triangles[j].col[i] = triangle0.col[i]*IFS[1+7*j] + triangle0.row[i]*IFS[2+7*j] + IFS[5+7*j];
triangles[j].row[i] = triangle0.col[i]*IFS[3+7*j] + triangle0.row[i]*IFS[4+7*j] + IFS[6+7*j];
                                                        }
                                                if (transform_affine(&triangles[j]) == 0)
                                                        {
sprintf(sbuf,"IFS code #%d is not Affine",j+1);
putmsg(10,100,sbuf,RED,WHITE);
delay(1000);
clrmsg();
file_error=1;
							}

                                                }
                                                if (file_error) default_fractal();
                                                else {
                                                        sprintf(sbuf,"    %d IFS codes read in   ",num_triangles);
                                                        putmsg(150,150,sbuf,BLUE,WHITE);
                                                        delay(1000);
                                                        clrmsg();
                                                        x1 = 150; x2 = 400;
                                                        y1 = 116; y2 = 350;
                                                        triangles_limits(&left,&top,&right,&bottom);
                                                        scalex = (x2-x1)/(right - left);
                                                        scaley = (y2-y1)/(bottom - top);
                                                        if (scalex > scaley) scalex = scaley;
                                                        else scaley = scalex;
                                                        scaley = -scaley;
                                                        offsetx = -((left+right)/2.0)*scalex + (x2+x1)/2.0;
                                                        offsety = -((bottom+top)/2.0)*scaley + (y2+y1)/2.0;
                                                        IFS_rescale(scalex,offsetx,scaley,offsety,0);
                                                        triangles_use_temp();
                                                }
					}
                                        IFS_changed = 1;
                                }
                                stpcpy(last_file,"No file");
                                file_modified = 0;
                                break;
                        case 2: /* write to .IFS file */
                                if (gscanf(100,100,"Write to what .IFS file: ",
                                                8,"%s",fname))
                                {
                                        ifs_name_fix(fname);

                                        save = 'n';
                                        if (access(fname,0) != 0)
                                        {
                                                save = 'y';
                                        }
                                        else
                                        {
                                                if (gscanf(80,80,"File Exists, replace (Y/N)? ",
                                                       1,"%c",&ch))
                                                {
                                                        if ((ch == 'Y') || (ch == 'y'))
                                                        {
                                                                save = 'y';
                                                        }
                                                }
                                        }
                                        if (save == 'n') break;

                                        ifsfile = fopen(fname,"wt");
                                        /*
                                                compute ifs codes for FRACTINT
                                                screen size
                                        */
                                        plot_type = 5;
                                        plotlimits(3000);
                                        /* output to file */
                                        for (i=0; i<num_triangles; i++)
                                        {
                                                fprintf(ifsfile,"%f %f %f %f %f %f %f\n",
                                                        IFS[1+7*i],IFS[2+7*i],
                                                        IFS[3+7*i],IFS[4+7*i],
                                                        IFS[5+7*i],IFS[6+7*i],
                                                        IFS[7+7*i]);
					}
					fprintf(ifsfile,"\032"); /* ctrl-z */
                                        fclose(ifsfile);
                                        putmsg(100,200,"File saved",BLUE,WHITE);
                                        delay(1000);
                                        clrmsg();
                                }
                                break;
                        case 3:
                                done = 1;
                                break;
                }
	} while (!done);
        cleardevice();
}

