/*   LEAF.H ---     Header file for maple leaf template
     This (and the other header files like it) can be used to define
     the initial fractal template for the SIERP.C and FRACDRAW.C programs
     This is the "geometric genetic code" for a maple leaf.  Note the close
     similarity to the MAPLE tree template.
*/
#define NPOINTS 4    /* Number of points on the "parent" polygon */
#define NTRANS  4    /* Number of transformed "children" */
#define NLEVELS 6    /* Number of levels to draw */
#define COUNT 10000  /* Number of dots to paint */
#define CENTERX 320  /* Center of the screen */
#define CENTERY 350
#define SEEDX 6,20,-6,-12  /* The "parent" polygon */
#define SEEDY -120,120,120,-120

/* The tranformations which define the "children" */
#define MOVEX -1.15,-53,51,-6  /* Displacement */
#define MOVEY 35,7,6,-111
#define SIZEX  0.14,0.62,0.65,0.49 /* Size change */
#define SIZEY  0.51,0.72,0.68,0.51
#define SPINX  6.26,5.47,0.81,6.28 /* Rotation */
#define SPINY  6.26,5.47,0.81,6.28

/* The following color definitions are ignored by the SIERP program
   and used only by FRACDRAW.
   PALETTE defines the 16-color VGA palette
   COLOR intializes a two-dimensional array with color values:
   each column in the array definition below corresponds to one level
   of detail, and each row corresponds to a "part", or transformation.
   Note that the array only needs to be 6 by 3 for the template defined
   above, but more rows are included in case the user inserts additional
   "parts".
*/
#define PALETTE {_BLACK, _RED, _GREEN, _CYAN, \
		 _BLUE, _MAGENTA, _BROWN, _WHITE, \
		 _GRAY, _LIGHTBLUE, _LIGHTGREEN, _LIGHTCYAN, \
		 _LIGHTRED, _LIGHTMAGENTA, _LIGHTYELLOW, _BRIGHTWHITE}

#define COLOR {{6, 6,14,14,10, 2},\
               {6, 6,14,14,10, 2},\
               {6, 6,14,14,10, 2},\
               {6, 6,14,14,10, 2},\
               {6, 6,14,14,10, 2},\
               {6, 6,14,14,10, 2},\
               {6, 6,14,14,10, 2},\
               {6, 6,14,14,10, 2},\
               {6, 6,14,14,10, 2}}
