#include <alloc.h>
#include "arrays.h"

/*--------------------------------------------------------------------*/
/*                                                                    */
/*  void **alloc_2d_array(int nx,int ny,int psize,int size)           */
/*                                                                    */
/*  dynamically allocates a 2 dimensional array, regardless of size,  */
/*  up to the size of the memory available on the heap, declared as a */
/*  pointer to a pointer of a given type.  psize is sizeof(type *),   */
/*  while size is sizeof(type). the array is of size nx by ny, e.g.   */
/*  z[nx][ny]. the method chosen allows very large array declarations */
/*                                                                    */
/*--------------------------------------------------------------------*/

void **alloc_2d_array(int nx,int ny,int psize,int size)

{
   register int i;
   void **P;

   P = (void **) calloc(nx,psize);
   if (!P) return(P);

   for (i=0; i < nx; i++)
     {
       P[i] = (void *) calloc(ny,size);
       if (!P[i]) return((void **)P[i]);
     }

  return(P);

} /* int alloc_2d_array() */