//
//+-----------------------------------------------------------------+
//+ Program TRIGJUL.CPP                                             +
//+ Plots 10 Julia Set-like fractals from trigonometric functions.  +
//+ By F.A.A. Barbuto, February 6th 1994                            +
//+ E-Mail: BJ06@C53000.PETROBRAS.ANRJ.BR (Rio de Janeiro, BRAZIL). +
//+ Needs SVGA256.H and SVGA256.BGI, supports up to five screens.   +
//+ Suggested starting colours: 33, 16, 40, 145.                    +
//+-----------------------------------------------------------------+
//
#include <stdio.h>
#include "svga256.h"
#include <conio.h>
#include <graphics.h>
#include <math.h>
#include <complex.h>

//void far initgraph(int far *,int far *,char far *);

int Vid; // Global variable //

int huge DetectVGA256()
{
  printf("\nWhich video mode would you like to use? \n\n");
  printf(" 0 - 320x200x256\n");
  printf(" 1 - 640x400x256\n");
  printf(" 2 - 640x480x256\n");
  printf(" 3 - 800x600x256\n");
  printf(" 4 - 1024x768x256\n\n>");
  scanf("%d",&Vid);
  if((Vid<0) || (Vid)>4) Vid = 2;
  return Vid;
}

void main()
{
      double Pi=3.1415926535897932, Inv_e=1.0/2.7182818284590452;
      double xmin=-Pi, xmax=Pi, ymin=-Pi, ymax=Pi, fact=1.0;
      double ypy, x, y, yp, p, q, r, deltap, deltaq;
      int istart, maxiter;
      register int npix, npiy, np, nq, npy, k, ipen;
      complex c, z, I=(0.0,1.0);
      int graphdriver=DETECT, graphmode, index;

      clrscr();
      printf("\n                  Select a formulation:   \n\n\n");
      printf(" 1: Pi*cos(z)     2: Pi*sin(z)      3: (1/e + 0.1)*exp(z)\n\n");
      printf(" 4: z*sin(z)      5: 2.96*cos(z)    6: sin(z)*cos(z)\n\n");
      printf(" 7: 2.945*cos(z)  8: 2.935*cos(z)   9: cosh(z)\n\n");
      printf("10: sinh(z)       Default: exp(z)*cos(z) (Arara)");
      printf("\n\n>");
      scanf("%d",&index);
      printf("\n  Number of iterations (maximum=default=16000)? \n\n>");
      scanf("%d",&maxiter);
      printf("\n  Set starting colour (>=0 , <=256)?");
      printf("\n  (suggested: 33, 16, 40, 145)\n\n>");
      scanf("%d",&istart);
      if((maxiter>500) || (maxiter)<=0) maxiter = 500;
      if((istart)<=0 || (istart>256)) istart = 0;
      clrscr();

      installuserdriver("Svga256",DetectVGA256);
      initgraph(&graphdriver, &graphmode, "C:\\BORLANDC\\BGI");

      if (Vid == 0) { npix = 320; npiy = 200;}
      if (Vid == 1) { npix = 640; npiy = 400;}
      if (Vid == 2) { npix = 640; npiy = 480;}
      if (Vid == 3) { npix = 800; npiy = 600;}
      if (Vid == 4) { npix =1024; npiy = 768;}
      if ((Vid>4) || (Vid<0)) { npix = 640; npiy = 480;}

      if(fact>=1.0 || fact <=0.0)
	fact = 1.0;
      else {
	npix = (int)(npix*fact);
	npiy = (int)(npiy*fact);
      }
      ypy = (double)npiy - 0.5;
      deltap = (xmax-xmin)/(npix-1);
      deltaq = (ymax-ymin)/(npiy-1);

      if(ymin==-ymax)
	 npy = npiy/2;
      else
	 npy = npiy;

     cleardevice();
     for (np=0; np<=npix-1; np++) {
       x = xmin + (double)np*deltap;
       for (nq=0; nq<=npy-1; nq++) {
	 y = ymin + (double)nq*deltaq;
	 k  = 0;
	 p = 0.0;
	 q = 0.0;
	 c = complex(p,q);
	 z = complex(x,y);
//
	 do {
	   if    (index == 1) z = Pi*cos(z) + c;
	   else
	      if (index == 2) z = Pi*sin(z) + c;
	   else
	      //Much better than "The Science of Fractal Images" Fig 3.9,
	      //pg. 161, uh?
	      if (index == 3) z = (Inv_e + 0.1)*exp(z) + c;
	   else
	      if (index == 4) z = z*sin(z) + c;
	   else
	      //See a zoom at "The Science of Fractal Images" pg. 119,
	      //Plate 19.
	      if (index == 5) z = 2.96*cos(z) + c;
	   else
	      //This is quite similar to the picture shown in "The Science
	      //of Fractal Images", pg.162, Fig. 3.10a.
	      if (index == 6) z = sin(z)*cos(z) + c;
	   else
	      //See a zoom at "The Science of Fractal Images" pg. 119,
	      //Plate 20.
	      if (index == 7) z = 2.945*cos(z) + c;
	   else
	      //See a zoom at "The Science of Fractal Images" pg. 119,
	      //Plate 21.
	      if (index == 8) z = 2.935*cos(z) + c;
	   else
	      if (index == 9) z = cosh(z) + c;
	   else
	      if (index ==10) z = sinh(z) + c;
	   else
	      //Default: Arara
	      if ((index < 1) || (index > 10))  z = cos(z)*exp(z) + c;

	   r = abs(z);
	   k++;

	   if (r >= maxiter) {
	     ipen = istart + k;
	     if (ymin == -ymax) {
	       putpixel(np,nq,ipen);
	       putpixel(np,npiy-nq-1,ipen);
	     }
	     else
	       putpixel(np,nq,ipen);
	   }

	   if (k == maxiter) {
	     ipen = 33;
	     if (ymin == -ymax) {
	       ypy = double(npiy) - nq - 0.5;
	       putpixel(np,ypy,ipen);
	       putpixel(np,nq,ipen);
	     }
	     else
	       putpixel(np,nq,33);
	   }

	   p = real(z);
	   q = imag(z);
	 } while (r <= maxiter && k<=maxiter);
       }
       if(kbhit()) break;
     }
     getch();
     closegraph();
}
