//
//+--------------------------------------------------------+
//+ Program TRIGON.CPP v. 0.2                              +
//+ Plots some fractals from trigonometric functions       +
//+ (Hmmm... I guess I've already seen this somewhere...)  +
//+ By F.A.A. Barbuto, February 4th 1994                   +
//+ Needs SVGA256.H and SVGA256.BGI, supports five screens +
//+                                                        +
//+ Suggested starting colours: 16, 33, 145.               +
//+--------------------------------------------------------+
//
#include <stdio.h>
#include "svga256.h"
#include <conio.h>
#include <graphics.h>
#include <math.h>
#include <complex.h>

//void far initgraph(int far *,int far *,char far *);

int Vid; // Global variable //

int huge DetectVGA256()
{
  printf("\nWhich video mode would you like to use? \n\n");
  printf(" 0 - 320x200x256\n");
  printf(" 1 - 640x400x256\n");
  printf(" 2 - 640x480x256\n");
  printf(" 3 - 800x600x256\n");
  printf(" 4 - 1024x768x256\n\n>");
  scanf("%d",&Vid);
  if((Vid<0) || (Vid)>4) Vid = 2;
  return Vid;
}

void main()
{
      double Pi=3.14159265357;
      double pmin=-Pi, pmax=Pi, qmin=-Pi, qmax=Pi, fact=1.0;
      double ypy, x, y, yp, p, q, r, deltap, deltaq;
      int istart, maxiter;
      register int npix, npiy, k, np, nq, npy, ipen;
      complex c, z, I=(0.0,1.0);
      int graphdriver=DETECT, graphmode, index;

      clrscr();
      printf("\n                  Select a formulation:   \n\n");
      printf("\n  1 = Pi*cos(z)    2 = Pi*sin(z)   3 = z*|z|*cos(z)\n");
      printf("\n  4 = z*z*sin(z)   5 = z*cos(z)    6 = sin(z)*cos(z)\n\n>");
      scanf("%d",&index);
      printf("\n  Number of iterations (maximum=default=16000)? \n\n>");
      scanf("%d",&maxiter);
      printf("\n  Set starting colour (>=0 , <=256)? \n\n>");
      scanf("%d",&istart);
      if((maxiter>16000) || (maxiter)<=0) maxiter = 16000;
      if((istart)<=0 || (istart>256)) istart = 0;
      clrscr();

      installuserdriver("Svga256",DetectVGA256);
      initgraph(&graphdriver, &graphmode, "C:\\BORLANDC\\BGI");

      if (Vid == 0) { npix = 320; npiy = 200;}
      if (Vid == 1) { npix = 640; npiy = 400;}
      if (Vid == 2) { npix = 640; npiy = 480;}
      if (Vid == 3) { npix = 800; npiy = 600;}
      if (Vid == 4) { npix =1024; npiy = 768;}
      if ((Vid>4) || (Vid<0)) { npix = 640; npiy = 480;}

      if(fact>=1.0 || fact <=0.0)
	fact = 1.0;
      else {
	npix = (int)(npix*fact);
	npiy = (int)(npiy*fact);
      }
      ypy = (double)npiy - 0.5;
      deltap = (pmax-pmin)/(npix-1);
      deltaq = (qmax-qmin)/(npiy-1);

      if(qmin==-qmax)
	 npy = npiy/2;
      else
	 npy = npiy;

     cleardevice();
     for (np=0; np<=npix-1; np++) {
       p = pmin + (double)np*deltap;
       for (nq=0; nq<=npy-1; nq++) {
	 q = qmin + (double)nq*deltaq;
	 k  = 0;
	 x = 0.0;
	 y = 0.0;
	 c = complex(p,q);
	 z = complex(x,y);
//
	 do {
	   if    (index == 1) z = Pi*cos(z) + c;
	   else
	      if (index == 2) z = Pi*sin(z) + c;
	   else
	      if (index == 3) z = z*abs(z)*cos(z) + c;
	   else
	      if (index == 4) z = z*z*sin(z) + c;
	   else
	      if (index == 5) z = z*cos(z) + c;
	   else
	      if (index == 6) z = sin(z)*cos(z) + c;
	   else
	      if ((index < 1) || (index > 6))  z = Pi*cos(z) + c;

	   r = abs(z);
	   k++;

	   if (r >= maxiter) {
	     ipen = istart + k;
	     if (qmin == -qmax) {
	       putpixel(np,nq,ipen);
	       putpixel(np,npiy-nq-1,ipen);
	     }
	     else
	       putpixel(np,nq,ipen);
	   }

	   if (k == maxiter) {
	     ipen = 33;
	     if (qmin == -qmax) {
	       ypy = double(npiy) - nq - 0.5;
	       putpixel(np,ypy,ipen);
	       putpixel(np,nq,ipen);
	     }
	     else
	       putpixel(np,nq,33);
	   }

	   x = real(z);
	   y = imag(z);
	 } while (r <= maxiter && k<=maxiter);
       }
       if(kbhit()) break;
     }
     getch();
     closegraph();
}
