/*

	various dialog-box code - more in DIALOG.C

*/

#include "windows.h"
#include "winfract.h"
#include "fractint.h"
#include <math.h>
#include <stdio.h>

extern HWND hwnd;                               /* handle to main window */
extern char szHelpFileName[];                   /* Help file name*/

extern BOOL zoomflag;                /* TRUE is a zoom-box selected */

extern char *win_choices[];
extern int win_numchoices, win_choicemade;
int CurrentFractal;

extern HANDLE hDibInfo;		/* handle to the Device-independent bitmap */
extern LPBITMAPINFO pDibInfo;		/* pointer to the DIB info */

extern int time_to_restart;                               /* time to restart?  */
extern int time_to_reinit;				/* time to reinit? */
extern int time_to_cycle;                               /* time to cycle? */

extern int xdots, ydots, colors, maxiter;
extern int ytop, ybottom, xleft, xright;
extern double xxmin, xxmax, yymin, yymax;
extern int fractype;
extern int calc_status;
extern double param[4];

extern int inside, outside, biomorph, decomp, debugflag;
extern int usr_stdcalcmode, usr_floatflag;
extern	int	invert; 	/* non-zero if inversion active */
extern	double	inversion[3];	/* radius, xcenter, ycenter */

int tempfractype;
int tempcolors;
char tempstdcalcmode, tempfloatflag;

int numparams,numtrig;
static char *trg[] = {"First Function","Second Function",
		      "Third Function","Fourth Function"};
static int paramt[] = {ID_FRACPARTX1, ID_FRACPARTX2,
                       ID_FRACPARTX3, ID_FRACPARTX4 };
static int paramv[] = {ID_FRACPARAM1, ID_FRACPARAM2,
                       ID_FRACPARAM3, ID_FRACPARAM4, };

extern int win_release;
extern char win_comment[];

extern char DialogTitle[];

/****************************************************************************

    FUNCTION: About(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "About" dialog box

    MESSAGES:

        WM_INITDIALOG - initialize dialog box
        WM_COMMAND    - Input received

****************************************************************************/

BOOL FAR PASCAL About(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

float temp;
char tempname[40];

    switch (message) {

         case WM_KEYDOWN:
             switch (wParam) {
                 case VK_F1:
                 /* F1, shifted F1 bring up the Help Index */
                     WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                     break;
                 }

        case WM_INITDIALOG:
            temp = win_release / 100.0;
            sprintf(tempname,"Fractint for Windows - Vers %5.2f", temp);
            SetDlgItemText(hDlg, ID_VERSION,tempname);
            SetDlgItemText(hDlg, ID_COMMENT,win_comment);
            return (TRUE);

        case WM_COMMAND:
	    if (wParam == IDOK
                || wParam == IDCANCEL) {
                EndDialog(hDlg, TRUE);
                return (TRUE);
            }
            break;
    }
    return (FALSE);
}

/****************************************************************************

    FUNCTION: Status(HWND, unsigned, WORD, LONG)

    PURPOSE:  Processes messages for "Status" dialog box

    MESSAGES:

        WM_INITDIALOG - initialize dialog box
        WM_COMMAND    - Input received

****************************************************************************/

BOOL FAR PASCAL Status(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{
char tempstring[100];
int i, j;

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
            sprintf(tempstring,"fractal type: ");
            strcat(tempstring, fractalspecific[fractype].name);
            if (calc_status == 1)
                strcat(tempstring,"    (still being calculated)");
            else
                strcat(tempstring,"    (interrupted/completed)");
            /* ##### */
            SetDlgItemText(hDlg, IDS_LINE1,tempstring);
            if(fractalspecific[fractype].param[0][0] == 0)
                tempstring[0] = 0;
            else
                sprintf(tempstring,"%-30.30s   %14.10f",
                    fractalspecific[fractype].param[0], param[0]);
            SetDlgItemText(hDlg, IDS_LINE2,tempstring);
            if(fractalspecific[fractype].param[1][0] == 0)
                tempstring[0] = 0;
            else
                sprintf(tempstring,"%-30.30s   %14.10f",
                    fractalspecific[fractype].param[1], param[1]);
            SetDlgItemText(hDlg, IDS_LINE3,tempstring);
            if(fractalspecific[fractype].param[2][0] == 0)
                tempstring[0] = 0;
            else
                sprintf(tempstring,"%-30.30s   %14.10f",
                    fractalspecific[fractype].param[2], param[2]);
            SetDlgItemText(hDlg, IDS_LINE4,tempstring);
            if(fractalspecific[fractype].param[3][0] == 0)
                tempstring[0] = 0;
            else
                sprintf(tempstring,"%-30.30s   %14.10f",
                    fractalspecific[fractype].param[3], param[3]);
            SetDlgItemText(hDlg, IDS_LINE5,tempstring);
            sprintf(tempstring,"Xmin:        %25.16f", xxmin);
            SetDlgItemText(hDlg, IDS_LINE6,tempstring);
            sprintf(tempstring,"Xmax:        %25.16f", xxmax);
            SetDlgItemText(hDlg, IDS_LINE7,tempstring);
            sprintf(tempstring,"Ymin:        %25.16f", yymin);
            SetDlgItemText(hDlg, IDS_LINE8,tempstring);
            sprintf(tempstring,"Ymax:        %25.16f", yymax);
            SetDlgItemText(hDlg, IDS_LINE9,tempstring);
            return (TRUE);

        case WM_COMMAND:
	    if (wParam == IDOK
                || wParam == IDCANCEL) {
                EndDialog(hDlg, TRUE);
                return (TRUE);
            }
            break;
    }
    return (FALSE);
}

/****************************************************************************

    FUNCTION: SelectFractal(HWND, unsigned, WORD, LONG)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL FAR PASCAL SelectFractal(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    int i;
    int index;

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
            SetDlgItemText(hDlg, ID_LISTTITLE, DialogTitle);
            for (i = 0; i < win_numchoices; i++) 
                SendDlgItemMessage(hDlg, IDM_FRACTAL, LB_ADDSTRING,
                    NULL, (LONG) (LPSTR) win_choices[i]);
            SendDlgItemMessage(hDlg, IDM_FRACTAL, LB_SETCURSEL,
                win_choicemade, 0L);
            return (TRUE);
            break;
        
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
okay:           
                    index=SendDlgItemMessage(hDlg, IDM_FRACTAL,
                        LB_GETCURSEL, 0, 0L);
                    if (index == LB_ERR) {
                        MessageBox(hDlg, "No Choice selected",
                            "Select From a List", MB_OK | MB_ICONEXCLAMATION);
                        break;
                        }
                    win_choicemade = index;
                    EndDialog(hDlg, 1);
                    break;
                  
                case IDCANCEL:
                    win_choicemade = -1;
                    EndDialog(hDlg, 0);
                    break;
                    
                case IDM_FRACTAL:
                    switch (HIWORD(lParam)) {
                        case LBN_SELCHANGE:
                            index = SendDlgItemMessage(hDlg, IDM_FRACTAL,
                                LB_GETCURSEL, 0, 0L);
                            if (index == LB_ERR)
                                break;
                            break;
                         
                       case LBN_DBLCLK:
                            goto okay;
                            break;
                    }
                break;
                }
        
        }
    return (FALSE);
}

/****************************************************************************

    FUNCTION: SelectFracParams(HWND, unsigned, WORD, LONG)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL FAR PASCAL SelectFracParams(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    int i;
    int index;
    char temp[30];

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
                tempfractype = CurrentFractal;
                for (numparams = 0; numparams < 4; numparams++)
                    if (fractalspecific[tempfractype].param[numparams][0] == 0)
                        break;
                numtrig = (fractalspecific[tempfractype].flags >> 6) & 7;
                for (i = 0; i < 4; i++) {
                    sprintf(temp,"%f",fractalspecific[tempfractype].paramvalue[i]);
                    SetDlgItemText(hDlg, paramv[i], temp);
                    SetDlgItemText(hDlg, paramt[i],"(n/a)");
                    if (i < numparams)
                       SetDlgItemText(hDlg, paramt[i],
                           fractalspecific[tempfractype].param[i]);
                    }
               for(i=0; i<numtrig; i++) {
                    SetDlgItemText(hDlg, paramt[i+numparams], trg[i]);
                    SetDlgItemText(hDlg, paramv[i+numparams],
                        trigfn[trigndx[i]].name);
                    }
            sprintf(temp,"%f",fractalspecific[tempfractype].xmin);
	    SetDlgItemText(hDlg, ID_FRACXMIN,   temp);
            sprintf(temp,"%f",fractalspecific[tempfractype].xmax);
	    SetDlgItemText(hDlg, ID_FRACXMAX,   temp);
            sprintf(temp,"%f",fractalspecific[tempfractype].ymin);
	    SetDlgItemText(hDlg, ID_FRACYMIN,   temp);
            sprintf(temp,"%f",fractalspecific[tempfractype].ymax);
	    SetDlgItemText(hDlg, ID_FRACYMAX,   temp);
	    SetDlgItemText(hDlg, ID_FRACNAME,   fractalspecific[tempfractype].name);
            return (TRUE);
            break;
        
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    for (i = 0; i < 4; i++) {
                        GetDlgItemText(hDlg, paramv[i], temp, 10);
                        param[i] = atof(temp);
                        }
                    for (i = 0; i < numtrig; i++) {
                        GetDlgItemText(hDlg, paramv[i+numparams], temp, 10);
                        temp[4] = 0;
                        if (temp[3] == 32) temp[3] = 0;
                        set_trig_array(i, temp);
                        }
		    GetDlgItemText(hDlg, ID_FRACXMIN  , temp, 10);
		    xxmin = atof(temp);
		    GetDlgItemText(hDlg, ID_FRACXMAX  , temp, 10);
		    xxmax = atof(temp);
		    GetDlgItemText(hDlg, ID_FRACYMIN  , temp, 10);
		    yymin = atof(temp);
		    GetDlgItemText(hDlg, ID_FRACYMAX  , temp, 10);
		    yymax = atof(temp);
                    invert = 0;
                    inversion[0] = inversion[1] = inversion[2] = 0;
                    fractype = CurrentFractal;
                    EndDialog(hDlg, 1);
                    break;
                  
                case IDCANCEL:
                    EndDialog(hDlg, 0);
                    break;

                }
        
        }
    return (FALSE);
}

/****************************************************************************

    FUNCTION: SelectImage(HWND, unsigned, WORD, LONG)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL FAR PASCAL SelectImage(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    int i;
    int index;
    char temp[15];

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
            tempcolors = colors;
            if (tempcolors == 2)
                CheckDlgButton(hDlg, ID_ICOLORS1, 1);
            else if (tempcolors == 16)
                CheckDlgButton(hDlg, ID_ICOLORS2, 1);
            else
                CheckDlgButton(hDlg, ID_ICOLORS3, 1);
            sprintf(temp,"%d",xdots);
	    SetDlgItemText(hDlg, ID_ISIZEX, temp);
            sprintf(temp,"%d",ydots);
	    SetDlgItemText(hDlg, ID_ISIZEY, temp);
	    i = ID_ISIZE7;
	    if (xdots ==  200 && ydots == 150) i = ID_ISIZE1;
	    if (xdots ==  320 && ydots == 200) i = ID_ISIZE2;
	    if (xdots ==  640 && ydots == 350) i = ID_ISIZE3;
	    if (xdots ==  640 && ydots == 480) i = ID_ISIZE4;
	    if (xdots ==  800 && ydots == 600) i = ID_ISIZE5;
	    if (xdots == 1024 && ydots == 768) i = ID_ISIZE6;
            CheckRadioButton(hDlg, ID_ISIZE1, ID_ISIZE7, i);
            return (TRUE);
            break;
        
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    /* retrieve and validate the results */
		    GetDlgItemText(hDlg, ID_ISIZEX, temp, 10);
		    xdots = atoi(temp);
		    if (xdots < 50) xdots = 50;
		    if (xdots > 2048) xdots = 2048;
		    GetDlgItemText(hDlg, ID_ISIZEY, temp, 10);
		    ydots = atoi(temp);
		    if (ydots < 50) ydots = 50;
		    if (ydots > 2048) ydots = 2048;
                    colors = tempcolors;
                    /* allocate and lock a pixel array for the bitmap */
                    /* problem, here - can't just RETURN!!! */
                    tryagain:
                    if (!clear_screen(0)) {
                        MessageBox(hDlg, "Not Enough Memory for that sized Image",
                            NULL, MB_OK | MB_ICONHAND);
                        xdots = ydots = 100;
                        goto tryagain;
                        };
                    ytop    = 0;		/* reset the zoom-box */
                    ybottom = ydots-1;
                    xleft   = 0;
                    xright  = xdots-1;
                    set_win_offset();
                    zoomflag = TRUE;
                    time_to_restart = 1;
                    EndDialog(hDlg, 1);
                    break;
                  
                case IDCANCEL:
                    EndDialog(hDlg, 0);
                    break;

                case ID_ISIZE1:
		    CheckRadioButton(hDlg, ID_ISIZE1, ID_ISIZE7, ID_ISIZE1);
		    SetDlgItemInt(hDlg, ID_ISIZEX, 200, TRUE);
		    SetDlgItemInt(hDlg, ID_ISIZEY, 150, TRUE);
                    break;

                case ID_ISIZE2:
		    CheckRadioButton(hDlg, ID_ISIZE1, ID_ISIZE7, ID_ISIZE2);
		    SetDlgItemInt(hDlg, ID_ISIZEX, 320, TRUE);
		    SetDlgItemInt(hDlg, ID_ISIZEY, 200, TRUE);
                    break;

                case ID_ISIZE3:
		    CheckRadioButton(hDlg, ID_ISIZE1, ID_ISIZE7, ID_ISIZE3);
		    SetDlgItemInt(hDlg, ID_ISIZEX, 640, TRUE);
		    SetDlgItemInt(hDlg, ID_ISIZEY, 350, TRUE);
                    break;

                case ID_ISIZE4:
		    CheckRadioButton(hDlg, ID_ISIZE1, ID_ISIZE7, ID_ISIZE4);
		    SetDlgItemInt(hDlg, ID_ISIZEX, 640, TRUE);
		    SetDlgItemInt(hDlg, ID_ISIZEY, 480, TRUE);
                    break;

                case ID_ISIZE5:
		    CheckRadioButton(hDlg, ID_ISIZE1, ID_ISIZE7, ID_ISIZE5);
		    SetDlgItemInt(hDlg, ID_ISIZEX, 800, TRUE);
		    SetDlgItemInt(hDlg, ID_ISIZEY, 600, TRUE);
                    break;

                case ID_ISIZE6:
		    CheckRadioButton(hDlg, ID_ISIZE1, ID_ISIZE7, ID_ISIZE6);
		    SetDlgItemInt(hDlg, ID_ISIZEX, 1024, TRUE);
		    SetDlgItemInt(hDlg, ID_ISIZEY, 768, TRUE);
                    break;

                case ID_ISIZE7:
		    CheckRadioButton(hDlg, ID_ISIZE1, ID_ISIZE7, ID_ISIZE7);
                    break;

                case ID_ICOLORS1:
		    CheckRadioButton(hDlg, ID_ICOLORS1, ID_ICOLORS3, ID_ICOLORS1);
                    tempcolors = 2;
                    break;

                case ID_ICOLORS2:
		    CheckRadioButton(hDlg, ID_ICOLORS1, ID_ICOLORS3, ID_ICOLORS2);
                    tempcolors = 16;
                    break;

                case ID_ICOLORS3:
		    CheckRadioButton(hDlg, ID_ICOLORS1, ID_ICOLORS3, ID_ICOLORS3);
                    tempcolors = 256;
                    break;

                }
        
        }
    return (FALSE);
}

/****************************************************************************

    FUNCTION: SelectDoodads(HWND, unsigned, WORD, LONG)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/

BOOL FAR PASCAL SelectDoodads(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    int i;
    int index;
    char temp[80];
    double win_invert;

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
            tempfloatflag = usr_floatflag;
            tempstdcalcmode = usr_stdcalcmode;
            if (tempstdcalcmode == '1')
                CheckDlgButton(hDlg, ID_PASS1, 1);
            if (tempstdcalcmode == '2')
                CheckDlgButton(hDlg, ID_PASS2, 1);
            if (tempstdcalcmode == 'g')
                CheckDlgButton(hDlg, ID_PASSS, 1);
            if (tempstdcalcmode == 'b')
                CheckDlgButton(hDlg, ID_PASSB, 1);
            if (tempfloatflag)
                CheckDlgButton(hDlg, ID_MATHF, 1);
            else
                CheckDlgButton(hDlg, ID_MATHI, 1);
            sprintf(temp,"%d",maxiter);
	    SetDlgItemText(hDlg, ID_MAXIT, temp);
            sprintf(temp,"%d",biomorph);
	    SetDlgItemText(hDlg, ID_BIOMORPH, temp);
            sprintf(temp,"%d",decomp);
	    SetDlgItemText(hDlg, ID_DECOMP, temp);
            sprintf(temp,"%d",inside);
	    SetDlgItemText(hDlg, ID_INSIDE, temp);
            sprintf(temp,"%d",outside);
	    SetDlgItemText(hDlg, ID_OUTSIDE, temp);
	    win_invert = -1;
	    if (invert != 0) {
	        win_invert = 0;
	        if (inversion[0] != AUTOINVERT)
	            win_invert = inversion[0];
	        }
            sprintf(temp,"%f",win_invert);
	    SetDlgItemText(hDlg, ID_INVERT, temp);
            return (TRUE);
            break;
        
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    /* retrieve and validate the results */
                    usr_stdcalcmode = tempstdcalcmode;
                    usr_floatflag = tempfloatflag;
                    GetDlgItemText(hDlg, ID_MAXIT, temp, 10);
                    maxiter = atoi(temp);
                    if (maxiter < 10) maxiter = 10;
                    if (maxiter > 32000) maxiter = 32000;
                    GetDlgItemText(hDlg, ID_BIOMORPH, temp, 10);
                    biomorph = atoi(temp);
                    if (biomorph < 0) biomorph = -1;
                    if (biomorph >= colors) biomorph = colors-1;
                    GetDlgItemText(hDlg, ID_DECOMP, temp, 10);
                    decomp = atoi(temp);
                    if (decomp < 0) decomp = 0;
                    if (decomp > 256) decomp = 256;
                    GetDlgItemText(hDlg, ID_INSIDE, temp, 10);
                    inside = atoi(temp);
                    if (inside < 0) inside = 0;
                    if (inside >= colors) inside = colors-1;
                    GetDlgItemText(hDlg, ID_OUTSIDE, temp, 10);
                    outside = atoi(temp);
                    if (outside < 0) outside = -1;
                    if (outside >= colors) outside = colors-1;
                    GetDlgItemText(hDlg, ID_INVERT, temp, 10);
                    win_invert = atof(temp);
                    invert = 0;
                    if (win_invert >= 0) {
                        invert = 1;
                        inversion[0] = AUTOINVERT;
                        if (win_invert > 0)
                            inversion[0] = win_invert;
                        }
                    time_to_restart = 1;
                    EndDialog(hDlg, 1);
                    break;
                  
                case IDCANCEL:
                    EndDialog(hDlg, 0);
                    break;

                case ID_PASS1:
                    tempstdcalcmode = '1';
                    CheckRadioButton(hDlg, ID_PASS1, ID_PASSB, ID_PASS1);
                    break;

                case ID_PASS2:
                    tempstdcalcmode = '2';
                    CheckRadioButton(hDlg, ID_PASS1, ID_PASSB, ID_PASS2);
                    break;

                case ID_PASSS:
                    tempstdcalcmode = 'g';
                    CheckRadioButton(hDlg, ID_PASS1, ID_PASSB, ID_PASSS);
                    break;

                case ID_PASSB:
                    tempstdcalcmode = 'b';
                    CheckRadioButton(hDlg, ID_PASS1, ID_PASSB, ID_PASSB);
                    break;

                case ID_MATHI:
                    tempfloatflag = 0;
                    CheckRadioButton(hDlg, ID_MATHI, ID_MATHF, ID_MATHI);
                    break;

                case ID_MATHF:
                    tempfloatflag = 1;
                    CheckRadioButton(hDlg, ID_MATHI, ID_MATHF, ID_MATHF);
                    break;

                }
        
        }
    return (FALSE);
}

/****************************************************************************

    FUNCTION: SelectCycle(HWND, unsigned, WORD, LONG)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/


int win_cycledir = -1, win_cyclerand = 0, win_cyclefreq = 0;
int win_tempcycle, win_tempcycledir, win_tempcyclerand, win_tempcyclefreq;

BOOL FAR PASCAL SelectCycle(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    int i;
    int index;
    char temp[80];

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
            win_tempcycle = time_to_cycle;
            win_tempcycledir = win_cycledir;
            win_tempcyclerand = win_cyclerand;
            win_tempcyclefreq = win_cyclefreq;
            if (win_tempcycle == 0)
                CheckDlgButton(hDlg, ID_CYCLEOFF, 1);
            else
                CheckDlgButton(hDlg, ID_CYCLEON, 1);
            if (win_tempcycledir == -1)
                CheckDlgButton(hDlg, ID_CYCLEOUT, 1);
            else
                CheckDlgButton(hDlg, ID_CYCLEIN, 1);
            if (win_tempcyclerand == 0)
                CheckDlgButton(hDlg, ID_CYCLESTAT, 1);
            else
                CheckDlgButton(hDlg, ID_CYCLECHG, 1);
            if (win_tempcyclefreq == 0)
                CheckDlgButton(hDlg, ID_CYCLELOW, 1);
            else if (win_tempcyclefreq == 1)
                CheckDlgButton(hDlg, ID_CYCLEMED, 1);
            else
                CheckDlgButton(hDlg, ID_CYCLEHIGH, 1);
            return (TRUE);
            break;
        
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    /* retrieve and validate the results */
                    time_to_cycle = win_tempcycle;
                    win_cycledir = win_tempcycledir;
                    win_cyclerand = win_tempcyclerand;
                    win_cyclefreq = win_tempcyclefreq;
                    EndDialog(hDlg, 1);
                    break;
                  
                case IDCANCEL:
                    EndDialog(hDlg, 0);
                    break;

                case ID_CYCLEOFF:
                    win_tempcycle = 0;
                    CheckRadioButton(hDlg, ID_CYCLEOFF, ID_CYCLEON, ID_CYCLEOFF);
                    break;

                case ID_CYCLEON:
                    win_tempcycle = 1;
                    CheckRadioButton(hDlg, ID_CYCLEOFF, ID_CYCLEON, ID_CYCLEON);
                    break;

                case ID_CYCLEOUT:
                    win_tempcycledir = -1;
                    CheckRadioButton(hDlg, ID_CYCLEOUT, ID_CYCLEIN, ID_CYCLEOUT);
                    break;

                case ID_CYCLEIN:
                    win_tempcycledir = 1;
                    CheckRadioButton(hDlg, ID_CYCLEOUT, ID_CYCLEIN, ID_CYCLEIN);
                    break;

                case ID_CYCLESTAT:
                    win_tempcyclerand = 0;
                    CheckRadioButton(hDlg, ID_CYCLESTAT, ID_CYCLECHG, ID_CYCLESTAT);
                    break;

                case ID_CYCLECHG:
                    win_tempcyclerand = 1;
                    CheckRadioButton(hDlg, ID_CYCLESTAT, ID_CYCLECHG, ID_CYCLECHG);
                    break;

                case ID_CYCLELOW:
                    win_tempcyclefreq = 0;
                    CheckRadioButton(hDlg, ID_CYCLELOW, ID_CYCLEHIGH, ID_CYCLELOW);
                    break;

                case ID_CYCLEMED:
                    win_tempcyclefreq = 1;
                    CheckRadioButton(hDlg, ID_CYCLELOW, ID_CYCLEHIGH, ID_CYCLEMED);
                    break;

                case ID_CYCLEHIGH:
                    win_tempcyclefreq = 2;
                    CheckRadioButton(hDlg, ID_CYCLELOW, ID_CYCLEHIGH, ID_CYCLEHIGH);
                    break;

                }
        
        }
    return (FALSE);
}

FARPROC lpSelectFullScreen;

struct fullscreenvalues
{
   int type;   /* 'd' for decimal, 's' for string, '*' for comment */
   union
   {
      double dval;
      char   sval[16];
   } uval;
};

extern HANDLE hInst;

int win_fullscreen_count;
char * far win_fullscreen_prompts[20];
char *win_fullscreen_heading;
static struct fullscreenvalues win_fullscreen_values[20];

int fullscreen_prompt(	/* full-screen prompting routine */
	char *hdg,		/* heading, lines separated by \n */
	int numprompts, 	/* there are this many prompts (max) */
	char * far *prompts,	/* array of prompting pointers */
	struct fullscreenvalues values[], /* array of values */
	int options,		/* future use bits in case we need them */
	int fkeymask		/* bit n on if Fn to cause return */
	)
{
int i;
int Return;

win_fullscreen_count = numprompts;
win_fullscreen_heading = hdg;
win_fullscreen_count = numprompts;
for (i = 0; i < win_fullscreen_count; i++) {
   win_fullscreen_prompts[i] = prompts[i]; 
   win_fullscreen_values[i]  = values[i];
   }

lpSelectFullScreen = MakeProcInstance(SelectFullScreen, hInst);
Return = DialogBox(hInst, "SelectFullScreen", hwnd, lpSelectFullScreen);
FreeProcInstance(lpSelectFullScreen);

if (Return) {
    for (i = 0; i < win_fullscreen_count; i++) {
        values[i] = win_fullscreen_values[i];
    }
    return(0);
    }

return(-1);
}

BOOL FAR PASCAL SelectFullScreen(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    int i;
    char temp[80];

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
            SetDlgItemText(hDlg, ID_PROMPT00,win_fullscreen_heading);
            for (i = 0; i < win_fullscreen_count; i++) {
                SetDlgItemText(hDlg, ID_PROMPT01+i,win_fullscreen_prompts[i]);
                if (win_fullscreen_values[i].type == 'd')
                    sprintf(temp,"%10.5f",win_fullscreen_values[i].uval.dval);
                else
                    strcpy(temp,win_fullscreen_values[i].uval.sval);
                SetDlgItemText(hDlg, ID_ANSWER01+i,temp);
                }
            return (TRUE);
            break;
        
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    for (i = 0; i < win_fullscreen_count; i++) {
                        GetDlgItemText(hDlg, ID_ANSWER01+i , temp, 10);
                        if (win_fullscreen_values[i].type == 'd')
                            win_fullscreen_values[i].uval.dval = atof(temp);
                        else
                            strcpy(win_fullscreen_values[i].uval.sval,temp);
                    }
                    EndDialog(hDlg, 1);
                    break;
                  
                case IDCANCEL:
                    EndDialog(hDlg, 0);
                    break;

                }
        
        }
    return (FALSE);
}


extern int init3d[];
extern int win_3dspherical;
extern char preview, showbox;
extern int previewfactor, glassestype, whichimage;
extern int xtrans, ytrans, transparent[2], RANDOMIZE;

static int win_answers[20];

BOOL FAR PASCAL Select3D(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    int i, tempfill;
    char temp[80];

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
            win_answers[0] = preview;
            win_answers[1] = showbox;
            win_answers[2] = SPHERE;
            win_answers[3] = previewfactor;
            win_answers[4] = glassestype;
            win_answers[5] = FILLTYPE+1;
            for (i = ID_PREVIEW; i <= ID_SPHERICAL; i++)
                CheckDlgButton(hDlg, i, win_answers[i-ID_PREVIEW]);
            sprintf(temp,"%d",win_answers[3]);
	    SetDlgItemText(hDlg, ID_PREVIEWFACTOR, temp);
            CheckRadioButton(hDlg, ID_STEREO1, ID_STEREO4,
                ID_STEREO1+win_answers[4]);
            CheckRadioButton(hDlg, ID_FILL1, ID_FILL8,
                ID_FILL1+win_answers[5]);
            return (TRUE);
            break;
        
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    if(win_answers[2] != SPHERE) {
                        SPHERE = win_answers[2];
                        set_3d_defaults();
                        }
                    preview = win_answers[0];
                    showbox = win_answers[1];
                    SPHERE  = win_answers[2];
                    GetDlgItemText(hDlg, ID_PREVIEWFACTOR, temp, 10);
                    previewfactor = atoi(temp);
                    glassestype = win_answers[4];
                    FILLTYPE = win_answers[5]-1;
                    win_3dspherical = SPHERE;
                    if(previewfactor < 8)
                       previewfactor = 8;
                    if(previewfactor > 128)
                       previewfactor = 128;
                    if(glassestype < 0)
                       glassestype = 0;
                    if(glassestype > 3)
                       glassestype = 3;
                    whichimage = 0;
                    if(glassestype)
                       whichimage = 1;
                    EndDialog(hDlg, 1);
                    break;
                    
                case ID_PREVIEW:
                case ID_SHOWBOX:
                case ID_SPHERICAL:
                    i = wParam - ID_PREVIEW;
                    win_answers[i] = 1 - win_answers[i];
                    CheckDlgButton(hDlg, ID_PREVIEW + i, win_answers[i]);
                    break;

                case ID_FILL1:
                case ID_FILL2:
                case ID_FILL3:
                case ID_FILL4:
                case ID_FILL5:
                case ID_FILL6:
                case ID_FILL7:
                case ID_FILL8:
                    i = wParam - ID_FILL1;
                    win_answers[5] = i;
                    CheckRadioButton(hDlg, ID_FILL1, ID_FILL8,
                        ID_FILL1+win_answers[5]);
                    break;

                case ID_STEREO1:
                case ID_STEREO2:
                case ID_STEREO3:
                case ID_STEREO4:
                    i = wParam - ID_STEREO1;
                    win_answers[4] = i;
                    CheckRadioButton(hDlg, ID_STEREO1, ID_STEREO4,
                        ID_STEREO1+win_answers[4]);
                    break;

                case IDCANCEL:
                    EndDialog(hDlg, 0);
                    break;

                }
        
        }
    return (FALSE);
}

BOOL FAR PASCAL Select3DPlanar(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    int i;
    char temp[80];

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
            win_answers[0] = XROT;
            win_answers[1] = YROT;
            win_answers[2] = ZROT;
            win_answers[3] = XSCALE;
            win_answers[4] = YSCALE;
            win_answers[5] = ROUGH;
            win_answers[6] = WATERLINE;
            win_answers[7] = ZVIEWER;
            win_answers[8] = XSHIFT;
            win_answers[9] = YSHIFT;
            win_answers[10] = xtrans;
            win_answers[11] = ytrans;
            win_answers[12] = transparent[0];
            win_answers[13] = transparent[1];
            win_answers[14] = RANDOMIZE;
            for (i = 0; i < 15; i++) {
                sprintf(temp,"%d", win_answers[i]);
                SetDlgItemText(hDlg, ID_ANS1+i,temp);
                }
            return (TRUE);
            break;
        
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    for (i = 0; i < 15; i++) {
                        GetDlgItemText(hDlg, ID_ANS1+i, temp, 10);
                        win_answers[i] = atof(temp);
                        }
                    XROT =           win_answers[0];
                    YROT =           win_answers[1];
                    ZROT =           win_answers[2];
                    XSCALE =         win_answers[3];
                    YSCALE =         win_answers[4];
                    ROUGH =          win_answers[5];
                    WATERLINE =      win_answers[6];
                    ZVIEWER =        win_answers[7];
                    XSHIFT =         win_answers[8];
                    YSHIFT =         win_answers[9];
                    xtrans =         win_answers[10];
                    ytrans =         win_answers[11];
                    transparent[0] = win_answers[12];
                    transparent[1] = win_answers[13];
                    RANDOMIZE =      win_answers[14];
                    if (RANDOMIZE >= 7) RANDOMIZE = 7;
                    if (RANDOMIZE <= 0) RANDOMIZE = 0;
                    EndDialog(hDlg, 1);
                    break;
                  
                case IDCANCEL:
                    EndDialog(hDlg, 0);
                    break;

                }
        
        }
    return (FALSE);
}

BOOL FAR PASCAL Select3DSpherical(hDlg, message, wParam, lParam)
HWND hDlg;
unsigned message;
WORD wParam;
LONG lParam;
{

    int i;
    char temp[80];

    switch (message) {

        case WM_KEYDOWN:
            switch (wParam) {
                case VK_F1:
                /* F1, shifted F1 bring up the Help Index */
                    WinHelp(hwnd,szHelpFileName,HELP_INDEX,0L);
                    break;
                }

        case WM_INITDIALOG:
            win_answers[0] = XROT;
            win_answers[1] = YROT;
            win_answers[2] = ZROT;
            win_answers[3] = XSCALE;
            win_answers[4] = YSCALE;
            win_answers[5] = ROUGH;
            win_answers[6] = WATERLINE;
            win_answers[7] = ZVIEWER;
            win_answers[8] = XSHIFT;
            win_answers[9] = YSHIFT;
            win_answers[10] = xtrans;
            win_answers[11] = ytrans;
            win_answers[12] = transparent[0];
            win_answers[13] = transparent[1];
            win_answers[14] = RANDOMIZE;
            for (i = 0; i < 15; i++) {
                sprintf(temp,"%d", win_answers[i]);
                SetDlgItemText(hDlg, ID_ANS1+i,temp);
                }
            return (TRUE);
            break;
        
        case WM_COMMAND:
            switch (wParam) {
                case IDOK:
                    for (i = 0; i < 15; i++) {
                        GetDlgItemText(hDlg, ID_ANS1+i, temp, 10);
                        win_answers[i] = atof(temp);
                        }
                    XROT =           win_answers[0];
                    YROT =           win_answers[1];
                    ZROT =           win_answers[2];
                    XSCALE =         win_answers[3];
                    YSCALE =         win_answers[4];
                    ROUGH =          win_answers[5];
                    WATERLINE =      win_answers[6];
                    ZVIEWER =        win_answers[7];
                    XSHIFT =         win_answers[8];
                    YSHIFT =         win_answers[9];
                    xtrans =         win_answers[10];
                    ytrans =         win_answers[11];
                    transparent[0] = win_answers[12];
                    transparent[1] = win_answers[13];
                    RANDOMIZE =      win_answers[14];
                    if (RANDOMIZE >= 7) RANDOMIZE = 7;
                    if (RANDOMIZE <= 0) RANDOMIZE = 0;
                    EndDialog(hDlg, 1);
                    break;
                  
                case IDCANCEL:
                    EndDialog(hDlg, 0);
                    break;

                }
        
        }
    return (FALSE);
}
