/*
	Routines which simulate DOS functions in the existing
	Fractint for DOS
*/

#include "windows.h"
#include "fractint.h"
#include "winfract.h"
#include <time.h>
#include <stdio.h>

int save_system;           /* tag identifying Fractint for Windows */
int save_release;          /* tag identifying version number */
int win_release = 310;     /* tag identifying version number */
char win_comment[] =       /* "About..." comment */ 
    {" "};                 /*  publicly-released version */
/*  {"Test Version - Not for Release"};   /* interim test versions */

extern BOOL bTrack;                  /* TRUE if user is selecting a region */
extern BOOL zoomflag;                /* TRUE is a zoom-box selected */

extern HWND hwnd;                    /* handle to main window */

extern int xdots, ydots, colors, maxiter;
extern int xposition, yposition, win_xoffset, win_yoffset, xpagesize, ypagesize;
extern int win_xdots, win_ydots;

extern int last_written_y;           /* last line written */
extern int screen_to_be_cleared;     /* clear screen flag */

extern int time_to_act;              /* time to take some action? */
extern int time_to_restart;          /* time to restart?  */
extern int time_to_quit;             /* time to quit? */
extern int time_to_reinit;           /* time to reinitialize? */
extern int time_to_load;             /* time to load? (DECODE) */
extern int time_to_save;             /* time to save? (ENCODE) */
extern int time_to_print;            /* time to print? (PRINTER) */
extern int time_to_cycle;            /* time to begin color-cycling? */

extern unsigned char dacbox[256][3];

extern BOOL win_systempaletteused;	/* flag system palette set */

extern unsigned char far temp_array[];   /* temporary spot for Encoder rtns */

extern HANDLE hpixels;			/* handle to the DIB pixels */
extern unsigned char huge *pixels;   /* the device-independent bitmap pixels */
int pixels_per_byte;                 /* pixels/byte in the pixmap */
long pixels_per_bytem1;              /* pixels / byte - 1 (for ANDing) */
int pixelshift_per_byte;             /* 0, 1, 2, or 3 */
int bytes_per_pixelline;             /* pixels/line / pixels/byte */
long win_bitmapsize;                 /* bitmap size, in bytes */

extern int kbdcount;

extern int win_overlay3d;
extern int win_display3d;

/****************************************************************************

    FUNCTION: keypressed(), getakey()

    PURPOSE:
         keypressed()
              Checks for, and processes, messages.
              Returns -1 if it's time to wrap up and go home.
              Returns 0 otherwise.
        getakey()
              same, but doesn't return until it's time to.


****************************************************************************/

BOOL dont_wait_for_a_key = TRUE;

int getakey()
{
int i;

dont_wait_for_a_key = FALSE;
i = keypressed();
dont_wait_for_a_key = TRUE;
zoomflag = FALSE;
return(i);

}

int keypressed()
{
MSG msg;

if (dont_wait_for_a_key)
    if (PeekMessage(&msg, NULL, NULL, NULL, PM_NOREMOVE) == 0) {
        time_to_act = time_to_reinit+time_to_restart+time_to_quit+
            time_to_load+time_to_save+time_to_print+time_to_cycle;
        /* bail out if nothing is happening */
        return(time_to_act);
        }

while (GetMessage(&msg, NULL, NULL, NULL)) {

    TranslateMessage(&msg);
    DispatchMessage(&msg); 

    if (!bTrack) {                /* don't do this if mouse-button is down */
        time_to_act = time_to_reinit+time_to_restart+time_to_quit+
            time_to_load+time_to_save+time_to_print+time_to_cycle;
        if (dont_wait_for_a_key || time_to_act)
            return(time_to_act);
        }

    }

if (!dont_wait_for_a_key)
    time_to_quit = 1;
        
    /* bail out if nothing is happening */
    time_to_act = time_to_reinit+time_to_restart+time_to_quit+
        time_to_load+time_to_save+time_to_print+time_to_cycle;
    return(time_to_act);

}

/****************************************************************************

    FUNCTION: putcolor(int x, int y, int color), getcolor(int x, int y)

    PURPOSE:
        putcolor:
           sets the "color" value of the pixel at location x,y
           (actually, a palette value)
        getcolor:
           returns the "color" value of the pixel at location x,y
           (actually, a palette value)

****************************************************************************/

extern int debug_fastupdate;

time_t last_time;
time_t update_time;
long minimum_update;
long pixelsout;
int top_changed, bottom_changed;

static unsigned char win_andmask[8];
static unsigned char win_notmask[8];
static unsigned char win_bitshift[8];

void putcolor(int x, int y, int color)
{
RECT tempRect;                   /* temporary rectangle structure */
long i;
int j, tempcolor, temp_top_changed, temp_bottom_changed;
time_t this_time;

kbdcount--;      /* partially adjust for the lower speed of Win graphics */

last_written_y = y;
if (y < top_changed) top_changed = y;
if (y > bottom_changed) bottom_changed = y;

i = win_ydots-1-y;
i = (i * win_xdots) + x;

if (x >= 0 && x < xdots && y >= 0 && y < ydots) {
    if (pixelshift_per_byte == 0) {
          pixels[i] = color % colors;
          }
     else {
          unsigned int j;
          j = i & pixels_per_bytem1;
          i = i >> pixelshift_per_byte;
          pixels[i] = (pixels[i] & win_notmask[j]) +
              (((unsigned char)(color % colors)) << win_bitshift[j]);
          }

     /* check the time every nnn pixels */
     if (debug_fastupdate || ++pixelsout > 100) {
          pixelsout = 0;
          this_time = time(NULL);
          /* time to update the screen? */
          if (debug_fastupdate || (this_time - last_time) > update_time ||
              (minimum_update*(this_time-last_time)) > (bottom_changed-top_changed)) {
              temp_top_changed = top_changed - win_yoffset;
              temp_bottom_changed = bottom_changed - win_yoffset;
              if (!(temp_top_changed >= ypagesize || temp_bottom_changed < 0)) {
                  if (temp_top_changed < 0) temp_top_changed = 0;
                  if (temp_bottom_changed < 0) temp_bottom_changed = 0;
                  tempRect.top = temp_top_changed;
                  tempRect.bottom = temp_bottom_changed+1;
                  tempRect.left = 0;
                  tempRect.right = xdots;
                  InvalidateRect(hwnd, &tempRect, FALSE);
                  keypressed();    /* force a look-see at the screen */
                  }
              last_time = this_time;
              top_changed = win_ydots;
              bottom_changed = 0;
              }
          }
     }

}

int getcolor(int x, int y)
{
long i;

i = win_ydots-1-y;
i = (i * win_xdots) + x;

if (x >= 0 && x < xdots && y >= 0 && y < ydots) {
    if (pixelshift_per_byte == 0) {
          return(pixels[i]);
          }
     else {
          unsigned int j;
          j = i & pixels_per_bytem1;
          i = i >> pixelshift_per_byte;
          return((int)((pixels[i] & win_andmask[j]) >> win_bitshift[j]));
          }
     }
else
     return(0);
}

int put_line(int rownum, int leftpt, int rightpt, unsigned char *localvalues)
{
int i, len;
long startloc;

len = rightpt - leftpt;
if (rightpt >= xdots) len = xdots - 1 - leftpt;
startloc = win_ydots-1-rownum;
startloc = (startloc * win_xdots) + leftpt;

kbdcount -= (len>>2);      /* adjust for the lower speed of Win graphics */

if (rownum < 0 || rownum >= ydots || leftpt < 0) {
    return(0);
    }

if (pixelshift_per_byte == 0) {
    for (i = 0; i <= len; i++)
        pixels[startloc+i] = localvalues[i];
    }
else {
    unsigned int j;
    long k;
    for (i = 0; i <= len; i++) {
        k = startloc + i;
        j = k & pixels_per_bytem1;
        k = k >> pixelshift_per_byte;
        pixels[k] = (pixels[k] & win_notmask[j]) +
            (((unsigned char)(localvalues[i] % colors)) << win_bitshift[j]);
        }
    }
pixelsout += len;
putcolor(leftpt, rownum, localvalues[0]);
}

int get_line(int rownum, int leftpt, int rightpt, unsigned char *localvalues)
{
int i, len;
long startloc;

len = rightpt - leftpt;
if (rightpt >= xdots) len = xdots - 1 - leftpt;
startloc = win_ydots-1-rownum;
startloc = (startloc * win_xdots) + leftpt;

if (rownum < 0 || rownum >= ydots || leftpt < 0 || rightpt >= xdots) {
    for (i = 0; i <= len; i++)
        localvalues[i] = 0;
    return(0);
    }

if (pixelshift_per_byte == 0) {
    for (i = 0; i <= len; i++)
        localvalues[i] = pixels[startloc+i];
    }
else {
    unsigned int j;
    long k;
    for (i = 0; i <= len; i++) {
        k = startloc + i;
        j = k & pixels_per_bytem1;
        k = k >> pixelshift_per_byte;
        localvalues[i] = (pixels[k] & win_andmask[j]) >> win_bitshift[j];
        }
    }
}

extern int rowcount;

int out_line(unsigned char *localvalues, int numberofdots)
{
    put_line(rowcount++, 0, numberofdots, localvalues);
}

extern LPBITMAPINFO pDibInfo;		/* pointer to the DIB info */

int clear_screen(int forceclear)
{
long numdots;
int i;

win_xdots = (xdots+3) & 0xfffc;
win_ydots = ydots;
pixelshift_per_byte = 0;
pixels_per_byte   = 1;
pixels_per_bytem1 = 0;
if (colors == 16) {
    win_xdots = (xdots+7) & 0xfff8;
    pixelshift_per_byte = 1;
    pixels_per_byte = 2;
    pixels_per_bytem1 = 1;
    win_andmask[0] = 0xf0;  win_notmask[0] = 0x0f; win_bitshift[0] = 4;
    win_andmask[1] = 0x0f;  win_notmask[1] = 0xf0; win_bitshift[1] = 0;
    }
if (colors == 2) {
    win_xdots = (xdots+31) & 0xffe0;
    pixelshift_per_byte = 3;
    pixels_per_byte = 8;
    pixels_per_bytem1 = 7;
    win_andmask[0] = 0x80;  win_notmask[0] = 0x7f; win_bitshift[0] = 7;
    for (i = 1; i < 8; i++) {
        win_andmask[i] = win_andmask[i-1] >> 1;
        win_notmask[i] = (win_notmask[i-1] >> 1) + 0x80;
        win_bitshift[i] = win_bitshift[i-1] - 1;
        }
    }

numdots = (long)win_xdots * (long) win_ydots;
update_time = 2;
if (numdots > 200000L) update_time = 4;
if (numdots > 400000L) update_time = 8;
last_time = time(NULL) - update_time + 1;
minimum_update = 7500/xdots;	/* assume 75,000 dots/sec drawing speed */

last_written_y = -1;
pixelsout = 0;
top_changed = win_ydots;
bottom_changed = 0;

bytes_per_pixelline = win_xdots >> pixelshift_per_byte;

/* Create the Device-independent Bitmap entries */
pDibInfo->bmiHeader.biWidth  = win_xdots;
pDibInfo->bmiHeader.biHeight = win_ydots;
pDibInfo->bmiHeader.biSizeImage = (DWORD)bytes_per_pixelline * win_ydots;
pDibInfo->bmiHeader.biBitCount = 8 / pixels_per_byte;

/* hard to believe, but this is the fast way to clear the pixel map */
if (hpixels) {
     GlobalUnlock(hpixels);
     GlobalFree(hpixels);
     }

win_bitmapsize = (numdots >> pixelshift_per_byte)+1;

if (!(hpixels = GlobalAlloc(GMEM_FIXED | GMEM_ZEROINIT, win_bitmapsize)))
     return(0);
if (!(pixels = (char huge *)GlobalLock(hpixels))) {
     GlobalFree(hpixels);
     return(0);
     }

/* adjust the colors for B&W or default */
if (colors == 2) {
    dacbox[0][0] = dacbox[0][1] = dacbox[0][2] = 0;
    dacbox[1][0] = dacbox[1][1] = dacbox[1][2] = 63;
    spindac(0,1);
    }
else
    restoredac();   /* color palette */

screen_to_be_cleared = 1;
InvalidateRect(hwnd, NULL, TRUE);

if (forceclear)
    keypressed();		/* force a look-see at the screen */

return(1);
}

int flush_screen()
{

last_written_y = 0;

InvalidateRect(hwnd, NULL, FALSE);

}

/****************************************************************************

    FUNCTION: buzzer(int buzzertype)

    PURPOSE:
              make some sort of sound (hey, we do what we can)

****************************************************************************/

void buzzer(int i)
{

MessageBeep(0);

}

/****************************************************************************

    FUNCTION: unsigned char far * farmemalloc(long bytecount)
              void farmemfree(unsigned char * bytepointer)
    PURPOSE:
              allocate and free memory in a manner consistent with
              Fractint for DOS

****************************************************************************/

#define MAXFARMEMALLOCS  20		/* max active farmemallocs */
int   farmemallocinit = 0;              /* any memory been allocated yet?   */
HANDLE farmemallochandles[MAXFARMEMALLOCS];			/* handles  */
unsigned char far *farmemallocpointers[MAXFARMEMALLOCS];	/* pointers */

unsigned char far * farmemalloc(long bytecount)
{
int i;
HANDLE temphandle;
unsigned char far *temppointer;

if (!farmemallocinit) {		/* never been here yet - initialize */
    farmemallocinit = 1;
    for (i = 0; i < MAXFARMEMALLOCS; i++) {
        farmemallochandles[i] = (HANDLE)0;
        farmemallocpointers[i] = NULL;
        }
    }

for (i = 0; i < MAXFARMEMALLOCS; i++)  /* look for a free handle */
    if (farmemallochandles[i] == (HANDLE)0) break;

if (i == MAXFARMEMALLOCS)       /* uh-oh - no more handles */
   return(NULL);		/* can't get far memory this way */

if (!(temphandle = GlobalAlloc(GMEM_FIXED | GMEM_ZEROINIT, bytecount)))
     return(NULL);		/* can't allocate the memory */
if (!(temppointer = (unsigned char far *)GlobalLock(temphandle))) {
     GlobalFree(temphandle);
     return(NULL);		/* ?? can't lock the memory ?? */
     }

farmemallochandles[i] =  temphandle;
farmemallocpointers[i] = temppointer;
return(temppointer);
}

void farmemfree(unsigned char far *bytepointer)
{
int i;
HANDLE temphandle;
unsigned char far *temppointer;

if (bytepointer == (unsigned char far *)NULL) return;

for (i = 0; i < MAXFARMEMALLOCS; i++)	/* search for a matching pointer */
    if (farmemallocpointers[i] == bytepointer)
         break;
if (i < MAXFARMEMALLOCS) {		/* got one */
    GlobalUnlock(farmemallochandles[i]);
    GlobalFree(farmemallochandles[i]);
    farmemallochandles[i] = (HANDLE)0;
    }

}

debugmessage(char *msg1, char *msg2)
{
MessageBox (
    GetFocus(),
    msg2,
    msg1,
    MB_ICONASTERISK | MB_OK);

}

texttempmsg(char *msg1)
{
MessageBox (
    GetFocus(),
    msg1,
    "Encoder",
    MB_ICONASTERISK | MB_OK);
}

stopmsg(int flags, unsigned char far *msg1)
{
int result;

if (! (flags & 4)) MessageBeep(0);

result = IDOK;

if (!(flags & 2))
    MessageBox (
        GetFocus(),
        msg1,
        "Fractint for Windows",
        MB_ICONASTERISK | MB_OK);
else 
    result = MessageBox (
        GetFocus(),
        msg1,
        "Fractint for Windows",
        MB_ICONQUESTION | MB_OKCANCEL);

if (result == 0 || result == IDOK || result == IDYES)
    return(0);
else
    return(-1);
}

extern char readname[];
extern int fileydots, filexdots, filecolors;
extern int     iNumColors;    /* Number of colors supported by device	       */

win_load()
{
int i;
char temp[80];

time_to_load = 0;

    start_wait();
    if ((i = read_overlay()) >= 0 && (!win_display3d || 
        xdots < filexdots || ydots < fileydots)) {
        if (win_display3d) stopmsg(0,
            "3D and Overlay3D file image sizes must be\nat least as large as the display image.\nAltering your display image to match the file.");
        xdots = filexdots;
        ydots = fileydots;
        colors = filecolors;
        if (colors > 16) colors = 256;
        if (colors >  2 && colors < 16) colors = 16;
        if (xdots < 50) xdots = 50;
        if (xdots > 2048) xdots = 2048;
        if (ydots < 50) ydots = 50;
        if (ydots > 2048) ydots = 2048;
        set_win_offset();
        clear_screen(0);
        }
    end_wait();
    return(i);
}

win_save()
{
    start_wait();
    time_to_save = 0;
    save_system = 1;
    save_release = win_release;
    savetodisk(readname);
    end_wait();
}

extern HDC PASCAL GetPrinterDC(void);

win_print()
{
int Return;
int display_xpixperinch, display_ypixperinch;
int printer_xdots, printer_ydots, printer_colors;
int printer_xpixperinch, printer_ypixperinch;
int printer_xmill, printer_ymill;
int printer_xacross, printer_yacross;
int printer_bandable;
long firstpixel;
float daspect, paspect;
HDC printerDC, displayDC;
WORD printer_usage;
RECT printerRect;
int more;

time_to_print = 0;

displayDC = GetDC(NULL);
display_xpixperinch  =  GetDeviceCaps(displayDC,LOGPIXELSX);
display_ypixperinch  =  GetDeviceCaps(displayDC,LOGPIXELSY);
ReleaseDC(NULL,displayDC);
daspect = ((float)xdots / (float)display_xpixperinch) /
    ((float)ydots / (float)display_ypixperinch);

if ((printerDC = GetPrinterDC())) {
    start_wait();
    printer_xpixperinch  =  GetDeviceCaps(printerDC,LOGPIXELSX);
    printer_ypixperinch  =  GetDeviceCaps(printerDC,LOGPIXELSY);
    printer_xmill  =  GetDeviceCaps(printerDC,HORZSIZE);
    printer_ymill  =  GetDeviceCaps(printerDC,VERTSIZE);
    printer_xdots  =  GetDeviceCaps(printerDC,HORZRES);
    printer_ydots  =  GetDeviceCaps(printerDC,VERTRES);
    printer_colors =  GetDeviceCaps(printerDC,NUMCOLORS);
    printer_bandable =  GetDeviceCaps(printerDC,RASTERCAPS) & RC_BANDING;
    printer_bandable = 0;
    paspect = ((float)printer_xdots / (float) printer_xmill) /
        ((float)printer_ydots / (float) printer_ymill);
    printer_xacross = printer_xdots;
    printer_yacross = (float)printer_xdots / daspect / paspect;
    if (printer_yacross > printer_ydots) {
        printer_xacross = (float)printer_xacross * (float) printer_ydots /
            (float)printer_yacross;
        if (printer_xacross > printer_xdots)
            printer_xacross = printer_xdots;
        printer_yacross = printer_ydots;
        }
    firstpixel = win_ydots - ydots;
    firstpixel = firstpixel * bytes_per_pixelline;
    printer_usage = DIB_PAL_COLORS;
    if (printer_colors <= 2) {
        mono_dib_palette();      /* B&W stripes for B&W printers */
        printer_usage = DIB_RGB_COLORS;
        }
    Return = Escape (printerDC, STARTDOC, 17, (LPSTR)"Fractint Printout", NULL);
    if (Return <= 0) goto oops;
    if (printer_bandable)
        Escape(printerDC, NEXTBAND, 0, NULL, (LPSTR) &printerRect);
    more = 1;
    while (more) {
        if (printer_bandable)
            DPtoLP(printerDC, (LPPOINT) &printerRect, 2);
        Return = StretchDIBits(printerDC,
            0, 0,
            printer_xacross, printer_yacross,
            0, 0,
            xdots, ydots,
            &pixels[firstpixel], (LPBITMAPINFO)pDibInfo,
            printer_usage, SRCCOPY);
        if (Return <= 0) goto oops;
        more = 0;
        if (printer_bandable) {
            Escape(printerDC, NEXTBAND, 0, NULL, (LPSTR) &printerRect);
            more = IsRectEmpty(&printerRect);
            }
        }
    Return = Escape(printerDC, NEWFRAME, 0, NULL, NULL);
    if (Return <= 0) goto oops;
oops: Escape(printerDC, ENDDOC, 0, NULL, NULL);
    DeleteDC(printerDC);
    default_dib_palette();   /* replace the palette */
    end_wait();
    if (Return < 0) stopmsg(0,
        "File Print failed\nYou probably ran out of memory\nSorry...");
    }
else
    stopmsg(0,"?? Can't find the printer!! ???");
}

extern int win_cycledir, win_cyclerand, win_cyclefreq;

extern HANDLE  hPal;       /* Palette Handle */
extern LPLOGPALETTE pLogPal;  /* pointer to the application's logical palette */
extern unsigned char far win_dacbox[256][3];
#define PALETTESIZE 256               /* dull-normal VGA                    */

static int win_fsteps[] = {54, 24, 8};

int win_animate_flag = 0;
int win_syscolorindex[21];
DWORD win_syscolorold[21];
DWORD win_syscolornew[21];

extern int debugflag;

win_cycle()
{
int istep, jstep, fstep, step, oldstep, last, next, maxreg;
int incr, random, fromred, fromblue, fromgreen, tored, toblue, togreen;
HDC hDC;                      /* handle to device context           */

fstep = 1;                              /* randomization frequency      */
oldstep = 1;				/* single-step			*/
step = 256;				/* single-step			*/
incr = 999;				/* ready to randomize		*/
maxreg = 256;				/* maximum register to rotate   */
last = maxreg-1;			/* last box that was filled	*/
next = 1;				/* next box to be filled	*/
if (win_cycledir < 0) {
	last = 1;
	next = maxreg;
	}
srand((unsigned)time(NULL));		/* randomize things		*/

hDC = GetDC(GetFocus());

win_animate_flag = 1;
SetPaletteEntries(hPal, 0, pLogPal->palNumEntries, pLogPal->palPalEntry);
SelectPalette (hDC, hPal, 1);

if ((iNumColors == 16 || debugflag == 1000) && !win_systempaletteused) {
    int i;
    DWORD white, black;
    win_systempaletteused = TRUE;
    white = 0xffffff00;
    black = 0;
    for (i = 0; i <= COLOR_ENDCOLORS; i++) {
        win_syscolorindex[i] = i;
        win_syscolorold[i] = GetSysColor(i);
        win_syscolornew[i] = black;
        }
    win_syscolornew[COLOR_BTNTEXT] = white;
    win_syscolornew[COLOR_CAPTIONTEXT] = white;
    win_syscolornew[COLOR_GRAYTEXT] = white;
    win_syscolornew[COLOR_HIGHLIGHTTEXT] = white;
    win_syscolornew[COLOR_MENUTEXT] = white;
    win_syscolornew[COLOR_WINDOWTEXT] = white;
    win_syscolornew[COLOR_WINDOWFRAME] = white;
    win_syscolornew[COLOR_INACTIVECAPTION] = white;
    win_syscolornew[COLOR_INACTIVEBORDER] = white;
    SetSysColors(COLOR_ENDCOLORS,win_syscolorindex,win_syscolornew);
    SetSystemPaletteUse(hDC,SYSPAL_NOSTATIC);
    UnrealizeObject(hPal);
    }

while (time_to_cycle) {
    if (win_cyclerand) {
        for (istep = 0; istep < step; istep++) {
            jstep = next + (istep * win_cycledir);
            if (jstep <=	  0) jstep += maxreg-1;
            if (jstep >= maxreg) jstep -= maxreg-1;
            if (++incr > fstep) {	/* time to randomize	*/
                incr = 1;
                fstep = ((win_fsteps[win_cyclefreq]*
                    (rand() >> 8)) >> 6) + 1;
                fromred   = dacbox[last][0];
                fromgreen = dacbox[last][1];
                fromblue  = dacbox[last][2];
                tored	  = rand() >> 9;
                togreen   = rand() >> 9;
                toblue	  = rand() >> 9;
                }
            dacbox[jstep][0] = fromred   + (((tored   - fromred  )*incr)/fstep);
            dacbox[jstep][1] = fromgreen + (((togreen - fromgreen)*incr)/fstep);
            dacbox[jstep][2] = fromblue  + (((toblue  - fromblue )*incr)/fstep);
            }
        }
        if (step >= 256) step = oldstep;

    spindac(win_cycledir,step);
    AnimatePalette(hPal, 0, pLogPal->palNumEntries, pLogPal->palPalEntry);
    RealizePalette(hDC); 
    keypressed();
    if (win_cyclerand == 2) {
        win_cyclerand = 1;
        step = 256;
        }
    }

win_animate_flag = 0;
ReleaseDC(GetFocus(),hDC);

}

/* cursor routines */

HANDLE hSaveCursor = 0;             /* the original cursor value */
HANDLE hHourGlass = 0;              /* the hourglass cursor value */

start_wait()
{
if (!hHourGlass) hHourGlass = LoadCursor(NULL, IDC_WAIT);
if (hHourGlass)  SetCursor(hHourGlass);
/* keypressed();   just to give messages, like cursor-changes, a chance */
}

end_wait()
{
if (!hSaveCursor) hSaveCursor = LoadCursor(NULL,IDC_ARROW);
if (hSaveCursor)  SetCursor(hSaveCursor);
/* keypressed();   just to give messages, like cursor-changes, a chance */
}

/* video-mode routines */

extern int    viewwindow;		/* 0 for full screen, 1 for window */
extern float  viewreduction;		/* window auto-sizing */
extern float  finalaspectratio; 	/* for view shape and rotation */
extern int    viewxdots,viewydots;	/* explicit view sizing */
extern int    fileydots, filexdots, filecolors;
extern float  fileaspectratio;
extern int    skipxdots,skipydots;	/* for decoder, when reducing image */

int get_video_mode(struct fractal_info *info)
{
   viewwindow = viewxdots = viewydots = 0;
   fileaspectratio = .75;
   skipxdots = skipydots = 0;
   return(0);
}


void spindac(int direction, int step)
{
int i, j, k;

for (k = 0; k < step; k++) {
    if (direction > 0) {
        for (j = 0; j < 3; j++) {
            for (i = 255; i >= 1; i--)
                dacbox[i+1][j] = dacbox[i][j];
            dacbox[1][j] = dacbox[256][j];
            }
        }
    if (direction < 0) {
        for (j = 0; j < 3; j++) {
            dacbox[256][j] = dacbox[1][j];
            for (i = 1; i < 256; i++)
                dacbox[i][j] = dacbox[i+1][j];
            }
        }
    }

    /* fill in intensities for all palette entry colors */
    for (i = 0; i < 256; i++) {
        pLogPal->palPalEntry[i].peRed   = ((BYTE)dacbox[i][0]) << 2;
        pLogPal->palPalEntry[i].peGreen = ((BYTE)dacbox[i][1]) << 2;
        pLogPal->palPalEntry[i].peBlue  = ((BYTE)dacbox[i][2]) << 2;
        pLogPal->palPalEntry[i].peFlags = PC_RESERVED;
        }

    if (!win_animate_flag) {
        HDC hDC;
        hDC = GetDC(GetFocus());
        SetPaletteEntries(hPal, 0, pLogPal->palNumEntries, pLogPal->palPalEntry);
        SelectPalette (hDC, hPal, 1);
        RealizePalette(hDC); 
        ReleaseDC(GetFocus(),hDC);
        }
}

restoredac()
{
int iLoop;
int j;

    /* fill in intensities for all palette entry colors */
    for (iLoop = 0; iLoop < PALETTESIZE; iLoop++) 
        for (j = 0; j < 3; j++)
            dacbox[iLoop][j] = win_dacbox[iLoop][j];
    spindac(0,1);
}

int ValidateLuts( char * fn )
{
FILE * f;
unsigned	r, g, b, index;
unsigned char	line[101];
unsigned char	temp[81];
	strcpy (temp,fn);
	if (strchr(temp,'.') == NULL) /* Did name have an extension? */
		strcat(temp,".map");  /* No? Then add .map */
	findpath( temp, line);	      /* search the dos path */
	f = fopen( line, "r" );
	if (f == NULL)
		return 1;
	for( index = 0; index < 256; index++ ) {
		if (fgets(line,100,f) == NULL)
			break;
		sscanf( line, "%d %d %d", &r, &g, &b );
		/** load global dac values **/
		dacbox[index][0] = r >> 2;	/* maps default to 8 bits */
		dacbox[index][1] = g >> 2;	/* DAC wants 6 bits */
		dacbox[index][2] = b >> 2;
	}
	fclose( f );
	return 0;
}

int win_thinking = 0;

int thinking(int waiting, char *dummy)
{
if (waiting && ! win_thinking) {
    win_thinking = 1;
    start_wait();
    }
if (!waiting)
    end_wait();
return(keypressed());
}

/* fake/not-yet-implemented subroutines */

int kbhit() { return(keypressed()); }
int getch() {return(13);}

void farmessage(unsigned char far *foo) {}
void setvideomode(int foo1, int foo2, int foo3, int foo4) {}
int fromvideotable() {}
int setforgraphics() {}
int setfortext() {}
int movecursor() {}
int home() {}
int _FAR_ _cdecl printf() {}
int help_overlay() {}
int prompts_overlay() {}
int rotate_overlay() {}
int printer_overlay() {}
int miscovl_overlay() {}
int pot_startdisk() {}
int SetTgaColors() {}
int startdisk() {}
int enddisk() {}
int readdisk() {}
int writedisk() {}
int nosnd(){}
int snd(){}
int targa_startdisk(){}
int targa_writedisk(){}
int SetColorPaletteName() {}
int get_3d_params() { return(0);}
int findfont() {return(0);}
int readticker(){return(0);}
int EndTGA(){}

int setattr(){}
int helptitle(){}
int stackscreen(){}
int unstackscreen(){}
void putstring(int foo1, int foo2, int foo3, unsigned char far *foo4){}
int putstringcenter(int foo1, int foo2, int foo3, int foo4, char far *foo5){}
int dvid_status(){}
int goodbye(){}
int tovideotable(){}
int _bios_serialcom(){}
