all: winfract.hlp res

.c.obj:
#       cl /AM /c /Od /Gsw /Zpei $*.c
        cl /AM /c /Oait /Gsw /Zpe $*.c

.asm.obj:
	masm /ML $*;

.rc.res:
        rc -r $*.rc

winfract.hlp: winfract.rtf
	hc winfract

winfract.res: winfract.rc mathtool.rc mathtool.h coord.dlg winfract.h

winfract.obj: winfract.c winfract.h

mathtool.obj: mathtool.c winfract.h mathtool.h

dialog.obj: dialog.c winfract.h fractint.h

dialog2.obj: dialog2.c winfract.h fractint.h

select.obj: select.c select.h

windos.obj: windos.c winfract.h

mainfrac.obj: mainfrac.c fractint.h

calcfrac.obj: calcfrac.c fractint.h fractype.h

fractals.obj: fractals.c fractint.h fractype.h

fracsubr.obj: fracsubr.c fractint.h fractype.h

lorenz.obj: lorenz.c fractint.h fractype.h

testpt.obj: testpt.c fractint.h 

parser.obj: parser.c

jb.obj: jb.c fractint.h 

lsys.obj: lsys.c fractint.h 

cmdfiles.obj: cmdfiles.c fractint.h fractype.h

plot3d.obj: plot3d.c fractint.h 

3d.obj: 3d.c fractint.h 

loadfile.obj: loadfile.c fractint.h 

decoder.obj: decoder.c fractint.h 

encoder.obj: encoder.c fractint.h 

gifview.obj: gifview.c fractint.h 

tgaview.obj: tgaview.c fractint.h 

f16.obj: f16.c fractint.h 

line3d.obj: line3d.c fractint.h 

miscres.obj: miscres.c fractint.h fractype.h

mpmath_c.obj: mpmath_c.c mpmath.h

fpu387.obj: fpu387.asm

fpu087.obj: fpu087.asm

mpmath_a.obj: mpmath_a.asm

wgeneral.obj: wgeneral.asm

calcmand.obj: calcmand.asm

fracsuba.obj: fracsuba.asm

newton.obj: newton.asm

winfract.exe: lorenz.obj parser.obj jb.obj testpt.obj miscres.obj \
    plot3d.obj 3d.obj line3d.obj loadfile.obj decoder.obj mathtool.obj \
    encoder.obj gifview.obj tgaview.obj f16.obj lsys.obj \
    mpmath_c.obj mpmath_a.obj fpu387.obj fpu087.obj cmdfiles.obj \
    calcfrac.obj fractals.obj fracsubr.obj newton.obj calcmand.obj \
    fracsuba.obj winfract.obj dialog.obj dialog2.obj select.obj \
    winfract.def windos.obj wgeneral.obj mainfrac.obj 
    rem ilink /E "link /CO /PADC /PADD /INC @winfract.lnk" winfract.exe @winfract.lnk
    ilink /E "link /PADC /PADD /INC @winfract.lnk" winfract.exe @winfract.lnk
    rem link @winfract.lnk > errors.lst
    rem type errors.lst

res: winfract.res winfract.exe
    rc winfract
